/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mq;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.mq.MessageAcker;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fpm.business.mq.AbstractMessageConsumer;
import kd.tmc.fpm.business.mq.TMCMQMessage;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGenerateParam;
import kd.tmc.fpm.business.mvc.service.report.generate.impl.ReportGenerateServiceImpl;
import kd.tmc.fpm.common.enums.MQBusinessTypeEnum;
import kd.tmc.fpm.common.enums.MQMsgStatusEnum;
import kd.tmc.fpm.common.helper.StringHelper;
import kd.tmc.fpm.common.property.TMCMQRecordProp;
import kd.tmc.fpm.common.utils.FpmAssertUtil;

public class GenFixedFreqReportConsumer
extends AbstractMessageConsumer {
    @Override
    public boolean canApply(String type) {
        return MQBusinessTypeEnum.GEN_FIXED_FREQ_REPORT.getValue().equals(type);
    }

    public void onMessage(Object o, String messageId, boolean b, MessageAcker messageAcker) {
        TMCMQMessage tmcmqMessage = (TMCMQMessage)o;
        Long mqRecordId = tmcmqMessage.getMqRecordId();
        String prop = String.join((CharSequence)",", TMCMQRecordProp.HEAD_MSGSTATUS, TMCMQRecordProp.HEAD_BUSINESSSTATUS);
        DynamicObject recordObj = QueryServiceHelper.queryOne((String)"tmc_mq_record", (String)prop, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)mqRecordId)});
        DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)"tmc_mq_record");
        record.set("id", (Object)mqRecordId);
        record.set(TMCMQRecordProp.HEAD_MSGSTATUS, (Object)recordObj.getString(TMCMQRecordProp.HEAD_MSGSTATUS));
        record.set(TMCMQRecordProp.HEAD_BUSINESSSTATUS, recordObj.get(TMCMQRecordProp.HEAD_BUSINESSSTATUS));
        String msgStatus = record.getString(TMCMQRecordProp.HEAD_MSGSTATUS);
        if (!MQMsgStatusEnum.SEND.getValue().equals(msgStatus) && !MQMsgStatusEnum.REP.getValue().equals(msgStatus)) {
            messageAcker.ack(messageId);
            return;
        }
        try {
            String content = (String)tmcmqMessage.getMessageContent();
            Map taskParam = (Map)SerializationUtils.fromJsonString((String)content, HashMap.class);
            String reportPrepareIdStr = StringHelper.getStringValue(taskParam.get("reportPrepareId"));
            logger.info("[GenFixedFreqReportConsumer] >>>>> \u5f00\u59cb\u5904\u7406\u7f16\u62a5\u51c6\u5907\u751f\u4ea7\u7f16\u5236\u8868\u4efb\u52a1:{}", (Object)reportPrepareIdStr);
            FpmAssertUtil.isNotBlank((String)reportPrepareIdStr, (String)"reportPrepareId is empty");
            long reportPrepareId = Long.parseLong(reportPrepareIdStr);
            String reportPeriodIdStr = StringHelper.getStringValue(taskParam.get("historyPeriodMemberIds"));
            String[] split = StringHelper.split((String)reportPeriodIdStr, (String[])new String[0]);
            List<Long> reportPeriodIds = Arrays.stream(split).map(Long::parseLong).collect(Collectors.toList());
            ReportGenerateParam reportGenerateParam = ReportGenerateParam.getInstance(reportPrepareId, reportPeriodIds);
            ReportGenerateServiceImpl reportGenerateService = new ReportGenerateServiceImpl();
            reportGenerateService.generate(reportGenerateParam);
            logger.info("[GenFixedFreqReportConsumer] >>>>> \u5904\u7406\u7f16\u62a5\u51c6\u5907\u751f\u4ea7\u7f16\u5236\u8868\u4efb\u52a1\u7ed3\u7b97:{}", (Object)reportPrepareIdStr);
            this.updateRecordStatus(record, MQMsgStatusEnum.FIN, null);
        }
        catch (Exception e) {
            this.updateRecordStatus(record, MQMsgStatusEnum.ERR, e.getStackTrace());
            logger.error("[GenFixedFreqReportConsumer] >>>>> MQ\u6d88\u8d39\u5f02\u5e38\uff1a", (Throwable)e);
        }
        messageAcker.ack(messageId);
    }
}

