/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mq;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.mq.MessageAcker;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.dataproc.save.impl.DataSaveServiceImpl;
import kd.tmc.fpm.business.domain.enums.TaskStatus;
import kd.tmc.fpm.business.domain.enums.TaskType;
import kd.tmc.fpm.business.domain.model.task.TaskRecord;
import kd.tmc.fpm.business.helper.ExceptionMessageHelper;
import kd.tmc.fpm.business.mq.AbstractMessageConsumer;
import kd.tmc.fpm.business.mq.TMCMQMessage;
import kd.tmc.fpm.business.mq.TMCMQPublisher;
import kd.tmc.fpm.business.mvc.service.dto.TaskRecordQueryParamsDTO;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskHandleService;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskProcessService;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskProcessServiceLifeCycleListener;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskRecordQueryService;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskSequentFactory;
import kd.tmc.fpm.business.mvc.service.seqtask.impl.TaskHandleServiceImpl;
import kd.tmc.fpm.business.mvc.service.seqtask.impl.TaskRecordQueryServiceImpl;
import kd.tmc.fpm.business.opservice.report.mutex.ILockStrategy;
import kd.tmc.fpm.business.opservice.report.mutex.ILockStrategyFactory;
import kd.tmc.fpm.business.opservice.report.mutex.LockStrategyFactoryFactory;
import kd.tmc.fpm.business.utils.ListHelper;
import kd.tmc.fpm.common.constant.GenericConstant;
import kd.tmc.fpm.common.enums.MQBusinessTypeEnum;
import kd.tmc.fpm.common.enums.MQMsgStatusEnum;
import kd.tmc.fpm.common.property.TMCMQRecordProp;

public class LocalSequentTaskConsumer
extends AbstractMessageConsumer {
    private final TaskRecordQueryService taskRecordQueryService = new TaskRecordQueryServiceImpl();
    private final TaskHandleService handleService = new TaskHandleServiceImpl();
    private final IDataSaveService dataSaveService = new DataSaveServiceImpl();

    @Override
    public boolean canApply(String type) {
        return MQBusinessTypeEnum.LOCAL_SEQUENT_TASK.getValue().equals(type);
    }

    public void onMessage(Object o, String messageId, boolean b, MessageAcker messageAcker) {
        TMCMQMessage tmcmqMessage = (TMCMQMessage)o;
        Long mqRecordId = tmcmqMessage.getMqRecordId();
        DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)mqRecordId, (String)"tmc_mq_record");
        String msgStatus = record.getString(TMCMQRecordProp.HEAD_MSGSTATUS);
        if (!MQMsgStatusEnum.SEND.getValue().equals(msgStatus) && !MQMsgStatusEnum.REP.getValue().equals(msgStatus)) {
            messageAcker.ack(messageId);
            return;
        }
        try (TXHandle ignored = TX.requiresNew();){
            this.doProcess(tmcmqMessage);
            this.updateRecordStatus(record, MQMsgStatusEnum.FIN, null);
        }
        catch (Exception e) {
            logger.error("[LocalSequentTaskConsumer] >>>>> MQ\u6d88\u8d39\u5f02\u5e38\uff1a", (Throwable)e);
            try (TXHandle ignore = TX.requiresNew();){
                this.updateRecordStatus(record, MQMsgStatusEnum.ERR, e.getStackTrace());
            }
        }
        messageAcker.ack(messageId);
    }

    private void doProcess(TMCMQMessage tmcmqMessage) {
        TaskRecord record = (TaskRecord)SerializationUtils.fromJsonString((String)tmcmqMessage.getMessageContent().toString(), TaskRecord.class);
        TaskType type = TaskType.getByName(record.getTaskType());
        String groupId = record.getGroupId();
        boolean hasHandlingTask = this.taskRecordQueryService.existHandlingTask(groupId, type);
        if (hasHandlingTask) {
            logger.info("[LocalSequentTaskConsumer] >>>>> \u5f53\u524d\u6d88\u8d39\u8005\u5224\u65ad\u5b58\u5728\u6b63\u5728\u5904\u7406\u4e2d\u7684\u4efb\u52a1\uff0c\u6545\u7ec8\u6b62\u6267\u884c\uff0ctaskId:{}", (Object)record.getId());
            return;
        }
        this.handleByPage(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleByPage(TaskRecord record) {
        TaskType type = TaskType.getByName(record.getTaskType());
        logger.info("[LocalSequentTaskConsumer] >>>>> \u5f53\u524d\u6d88\u8d39\u8005\u6b63\u5728\u5c06\u4efb\u52a1\u6309\u987a\u5e8f\u6267\u884c\uff0ctaskId:{}", (Object)record.getId());
        List<TaskRecord> taskRecords = this.loadTaskByParams(record);
        if (CollectionUtils.isEmpty(taskRecords)) {
            logger.info("[LocalSequentTaskConsumer] >>>>> \u53ef\u6267\u884c\u4efb\u52a1\u4e3a\u7a7a\uff0c\u6545\u7ec8\u6b62\u6267\u884c\uff0ctaskId:{}", (Object)record.getId());
            return;
        }
        ILockStrategyFactory lockStrategyFactory = LockStrategyFactoryFactory.getLockStrategyFactory(record);
        ILockStrategy lockStrategy = lockStrategyFactory.getLockStrategy(taskRecords);
        try {
            if (lockStrategy.tryLock()) {
                this.doProcessInLock(record, taskRecords);
            } else {
                this.lockFailed(lockStrategy, record, taskRecords);
            }
        }
        finally {
            try {
                lockStrategy.unLock();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            if (lockStrategy instanceof AutoCloseable) {
                AutoCloseable autoCloseable = (AutoCloseable)((Object)lockStrategy);
                try {
                    autoCloseable.close();
                }
                catch (Exception ee) {
                    logger.error(ee.getMessage(), (Throwable)ee);
                }
            }
        }
        this.afterProcess(record);
    }

    private void afterProcess(TaskRecord currentTaskRecord) {
        List<TaskRecord> taskRecords = this.loadTaskByParams(currentTaskRecord);
        if (CollectionUtils.isEmpty(taskRecords)) {
            logger.info("[LocalSequentTaskConsumer] >>>>> \u53ef\u6267\u884c\u4efb\u52a1\u4e3a\u7a7a\uff0c\u6545\u7ec8\u6b62\u6267\u884c\uff0ctaskId:{}", (Object)currentTaskRecord.getId());
        } else {
            TMCMQPublisher.sendFpmDefaultMsg(MQBusinessTypeEnum.LOCAL_SEQUENT_TASK, SerializationUtils.toJsonString((Object)taskRecords.get(0)));
            logger.info("[LocalSequentTaskConsumer] >>>>> \u5b58\u5728\u53ef\u6267\u884c\u4efb\u52a1\uff1a{}\u4e2a\uff0c\u91cd\u65b0\u53d1\u9001\u6d88\u606f\u5904\u7406\u3002taskId:{}", (Object)taskRecords.size(), (Object)currentTaskRecord.getId());
        }
        this.addCleanTaskIfNeed();
    }

    private void addCleanTaskIfNeed() {
        try {
            Date date = (Date)DB.query((DBRoute)DBRouteConst.TMC, (String)"select max(fcreatetime) from t_fpm_task_record where ftasktype=? ", (Object[])new Object[]{TaskType.TASK_CLEAN.name()}, resultSet -> {
                Date createTime = null;
                if (resultSet.next()) {
                    createTime = resultSet.getDate(1);
                }
                if (createTime == null) {
                    createTime = DateUtils.stringToDate((String)"1970-01-01", (String)"yyyy-MM-dd");
                }
                return createTime;
            });
            Date currentDate = DateUtils.getCurrentDate();
            Date lastMonth = DateUtils.getLastMonth((Date)currentDate, (int)1);
            if (date.after(lastMonth)) {
                return;
            }
            Long count = (Long)DB.query((DBRoute)DBRouteConst.TMC, (String)"select count(*) from t_fpm_task_record", resultSet -> {
                if (resultSet.next()) {
                    return resultSet.getLong(1);
                }
                return 0L;
            });
            if (count < GenericConstant.CLEAN_TASK_LIMIT) {
                return;
            }
            try (TXHandle ignore = TX.requiresNew();){
                long id = DB.genGlobalLongId();
                TaskRecord taskRecord = TaskRecord.builder().id(id).taskType(TaskType.TASK_CLEAN.name()).objectId(GenericConstant.CLEAN_TASK_ID).name("taskClean").taskNum(0).createTime(new Date()).groupId(GenericConstant.CLEAN_TASK_ID + "").objectEntityNumber("fpm_taskrecord").status(TaskStatus.WAITING.name()).build();
                new TaskHandleServiceImpl().saveTaskIfNotRepeat(taskRecord);
                TMCMQPublisher.sendFpmDefaultMsg(MQBusinessTypeEnum.LOCAL_SEQUENT_TASK, SerializationUtils.toJsonString((Object)taskRecord));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void lockFailed(ILockStrategy lockStrategy, TaskRecord record, List<TaskRecord> taskRecords) {
        Exception exception = lockStrategy.getException();
        if (exception != null) {
            logger.error("[LocalSequentTaskConsumer] >>>>> \u52a0\u9501\u5931\u8d25\uff0c\u5f53\u524d\u6d88\u8d39\u8005\u5224\u65ad\u5b58\u5728\u6b63\u5728\u5904\u7406\u4e2d\u7684\u4efb\u52a1\uff0c\u6545\u7ec8\u6b62\u6267\u884c\uff0c\u5f53\u524d\u4efb\u52a1\uff1a{}\uff0c\u5f85\u6267\u884c\u4efb\u52a1\u5927\u5c0f:{}\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}\uff0c{}", new Object[]{record.getId(), taskRecords.size(), exception.getMessage(), exception});
        } else {
            logger.info("[LocalSequentTaskConsumer] >>>>> \u52a0\u9501\u5931\u8d25\uff0c\u5f53\u524d\u6d88\u8d39\u8005\u5224\u65ad\u5b58\u5728\u6b63\u5728\u5904\u7406\u4e2d\u7684\u4efb\u52a1\uff0c\u6545\u7ec8\u6b62\u6267\u884c\uff0c\u5f53\u524d\u4efb\u52a1\uff1a{}\uff0c\u5f85\u6267\u884c\u4efb\u52a1\u5927\u5c0f:{}", (Object)record.getId(), (Object)taskRecords.size());
        }
    }

    private List<TaskRecord> loadTaskByParams(TaskRecord record) {
        TaskRecordQueryParamsDTO taskRecordQueryParamsDTO = new TaskRecordQueryParamsDTO();
        taskRecordQueryParamsDTO.setGroupId(record.getGroupId());
        taskRecordQueryParamsDTO.setTaskType(TaskType.getByName(record.getTaskType()));
        taskRecordQueryParamsDTO.setTaskStatusList(ListHelper.asList(TaskStatus.WAITING, TaskStatus.RETRYING));
        taskRecordQueryParamsDTO.setMaxSize(10);
        taskRecordQueryParamsDTO.setOrderBy("createtime asc");
        return this.taskRecordQueryService.loadTaskByParamsCompatible(taskRecordQueryParamsDTO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcessInLock(TaskRecord currentTaskRecord, List<TaskRecord> taskRecords) {
        int executeTaskCount = taskRecords.size();
        int oldTaskRecordSize = taskRecords.size();
        taskRecords = this.loadTaskByParams(currentTaskRecord);
        if (EmptyUtil.isEmpty(taskRecords)) {
            logger.info("[LocalSequentTaskConsumer] >>>>>\u5f53\u524d\u4efb\u52a1:{},\u52a0\u9501\u524d\u5f85\u5904\u7406\u4efb\u52a1\u5927\u5c0f\uff1a{}\uff0c\u52a0\u9501\u6210\u529f\u540e\u5f85\u5904\u7406\u4efb\u52a1\u4e3a0", (Object)currentTaskRecord.getId(), (Object)oldTaskRecordSize);
            return;
        }
        TaskProcessService taskProcessService = TaskSequentFactory.getService(currentTaskRecord.getTaskType());
        List<TaskProcessServiceLifeCycleListener> taskProcessServiceLifeCycleListeners = taskProcessService.getTaskProcessServiceListeners();
        this.updateTaskRecordStatusHandlingInNewTransaction(currentTaskRecord, taskRecords);
        logger.info("[LocalSequentTaskConsumer] >>>>>\u5f53\u524d\u4efb\u52a1:{},\u52a0\u9501\u524d\u5f85\u5904\u7406\u4efb\u52a1\u5927\u5c0f\uff1a{}\uff0c\u52a0\u9501\u6210\u529f\u540e\u5f85\u5904\u7406\u4efb\u52a1\u5927\u5c0f\uff1a{}", new Object[]{currentTaskRecord.getId(), oldTaskRecordSize, taskRecords.size()});
        try {
            this.initialize(taskProcessServiceLifeCycleListeners, taskRecords);
            for (TaskRecord taskRecord : taskRecords) {
                taskRecord.setTaskNum(taskRecord.getTaskNum() + 1);
                taskRecord.addRetry();
                try {
                    TXHandle ignored = TX.requiresNew();
                    Throwable throwable = null;
                    try {
                        logger.info("[LocalSequentTaskConsumer] >>>>> \u5f53\u524d\u6b63\u5728\u6267\u884c\u4efb\u52a1ID\uff1a{}, \u4efb\u52a1\u7c7b\u578b:{}", (Object)taskRecord.getId(), (Object)taskRecord.getTaskType());
                        if (!taskRecord.isIgnore()) {
                            taskProcessService.doProcess(taskRecord);
                        }
                        taskRecord.setStatus(TaskStatus.DONE.name());
                        this.updateTaskRecordStatus(Collections.singletonList(taskRecord));
                        logger.info("[LocalSequentTaskConsumer] >>>>> \u5f53\u524d\u4efb\u52a1ID\uff1a{}\uff0c\u5df2\u6267\u884c\u6210\u529f", (Object)taskRecord.getId());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ignored == null) continue;
                        if (throwable != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ignored.close();
                    }
                }
                catch (Exception e) {
                    logger.error("[LocalSequentTaskConsumer] >>>>> \u5f53\u524d\u4efb\u52a1ID\uff1a{}\uff0c\u6267\u884c\u5931\u8d25", (Object)taskRecord.getId(), (Object)e);
                    taskRecord.setStatus(taskRecord.getRetry() < 8 ? TaskStatus.RETRYING.name() : TaskStatus.FAILED.name());
                    taskRecord.setErrorMsg(ExceptionMessageHelper.getStackTraceMessage(e));
                    TXHandle ignored = TX.requiresNew();
                    Throwable throwable = null;
                    try {
                        this.handleService.updateTask(taskRecord);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (ignored == null) continue;
                        if (throwable != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        ignored.close();
                    }
                }
            }
            logger.info("[LocalSequentTaskConsumer] >>>>> \u5f53\u524d\u4efb\u52a1\uff1a{},\u672c\u5730\u987a\u5e8f\u5171\u8ba1\u6267\u884c:{}\u4e2a\u4efb\u52a1", (Object)currentTaskRecord.getId(), (Object)executeTaskCount);
        }
        finally {
            this.done(taskProcessServiceLifeCycleListeners);
        }
    }

    private void done(List<TaskProcessServiceLifeCycleListener> taskProcessServiceLifeCycleListeners) {
        if (EmptyUtil.isEmpty(taskProcessServiceLifeCycleListeners)) {
            return;
        }
        taskProcessServiceLifeCycleListeners.forEach(TaskProcessServiceLifeCycleListener::done);
    }

    private void initialize(List<TaskProcessServiceLifeCycleListener> taskProcessServiceListeners, List<TaskRecord> taskRecords) {
        if (EmptyUtil.isEmpty(taskProcessServiceListeners)) {
            return;
        }
        try {
            taskProcessServiceListeners.forEach(taskProcessServiceListener -> taskProcessServiceListener.initialize(taskRecords));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void updateTaskRecordStatusHandlingInNewTransaction(TaskRecord currentTaskRecord, List<TaskRecord> taskRecords) {
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                String traceId = RequestContext.get().getTraceId();
                this.dataSaveService.updateAndCheckResult(() -> "update t_fpm_task_record set fstatus=?,factexecutetraceid=?,fexecutetaskid=? where fid=?", taskRecords, (t, d) -> {
                    d.add(TaskStatus.HANDLING.name());
                    d.add(traceId);
                    d.add(currentTaskRecord.getId());
                    d.add(t.getId());
                });
            }
            catch (Exception e) {
                txHandle.markRollback();
            }
        }
    }

    private void updateTaskRecordStatus(List<TaskRecord> taskRecords) {
        this.dataSaveService.updateAndCheckResult(() -> "update t_fpm_task_record set fstatus=?,ftasknum=?,fretry=? where fid=?", taskRecords, (t, d) -> {
            d.add(t.getStatus());
            d.add(t.getTaskNum());
            d.add(t.getRetry());
            d.add(t.getId());
        });
    }
}

