/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mq;

import com.alibaba.fastjson.JSON;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.mq.MessageAcker;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mq.AbstractMessageConsumer;
import kd.tmc.fpm.business.mq.TMCMQMessage;
import kd.tmc.fpm.business.mvc.service.ISumPlanBizService;
import kd.tmc.fpm.business.mvc.service.impl.SumPlanBizServiceImpl;
import kd.tmc.fpm.common.enums.MQBusinessTypeEnum;
import kd.tmc.fpm.common.enums.MQMsgStatusEnum;
import kd.tmc.fpm.common.property.TMCMQRecordProp;

public class ReportSummaryConsumer
extends AbstractMessageConsumer {
    private ISumPlanBizService sumPlanBizService = new SumPlanBizServiceImpl();

    @Override
    public boolean canApply(String type) {
        return MQBusinessTypeEnum.FPM_SUMPLAN_SUM.getValue().equals(type);
    }

    public void onMessage(Object message, String messageId, boolean b, MessageAcker messageAcker) {
        TMCMQMessage tmcmqMessage = (TMCMQMessage)message;
        long mqRecordId = tmcmqMessage.getMqRecordId();
        String prop = String.join((CharSequence)",", TMCMQRecordProp.HEAD_MSGSTATUS, TMCMQRecordProp.HEAD_BUSINESSSTATUS, TMCMQRecordProp.HEAD_ERRORMSG, TMCMQRecordProp.HEAD_ERRORMSG_TAG);
        DynamicObject record = QueryServiceHelper.queryOne((String)"tmc_mq_record", (String)prop, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)mqRecordId)});
        String msgStatus = record.getString(TMCMQRecordProp.HEAD_MSGSTATUS);
        if (!MQMsgStatusEnum.SEND.getValue().equals(msgStatus) && !MQMsgStatusEnum.REP.getValue().equals(msgStatus)) {
            messageAcker.ack(messageId);
            return;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                List sumRecordIdList = (List)tmcmqMessage.getMessageContent();
                logger.info("[ReportSummaryConsumer] >>>>> \u6c47\u603b\u8bb0\u5f55\u751f\u6210----MQ\u6d88\u8d39---{}", (Object)sumRecordIdList);
                for (Long sumRecordId : sumRecordIdList) {
                    FpmOperateResult<Void> voidFpmOperateResult = this.sumPlanBizService.sumReportSumAllData(sumRecordId);
                    if (voidFpmOperateResult.isSuccess()) continue;
                    throw new KDBizException(JSON.toJSONString(voidFpmOperateResult.getMessageList()));
                }
                this.updateRecordStatus(record, MQMsgStatusEnum.FIN, null);
            }
            catch (Exception e) {
                logger.error("[ReportSummaryConsumer] >>>>> MQ\u6d88\u8d39\u5f02\u5e38\uff1a", (Throwable)e);
                this.updateRecordStatus(record, MQMsgStatusEnum.ERR, e.getStackTrace());
                txHandle.markRollback();
                if (txHandle != null) {
                    if (var12_11 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var12_11.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return;
            }
        }
        messageAcker.ack(messageId);
    }
}

