/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.controller.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.IFpmPageCacheService;
import kd.tmc.fpm.business.cache.data.CacheCell;
import kd.tmc.fpm.business.cache.data.CellDataSource;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecordCount;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.controller.BaseManageController;
import kd.tmc.fpm.business.mvc.controller.ISumPlanManageController;
import kd.tmc.fpm.business.mvc.controller.impl.AbstractFpmFormOperate;
import kd.tmc.fpm.business.mvc.service.IReportManageService;
import kd.tmc.fpm.business.mvc.service.ISumPlanManageService;
import kd.tmc.fpm.business.mvc.service.impl.ReportManageService;
import kd.tmc.fpm.business.mvc.service.impl.SumPlanManageServiceImpl;
import kd.tmc.fpm.business.mvc.view.IFpmFormView;
import kd.tmc.fpm.business.mvc.view.ISumPlanManageView;
import kd.tmc.fpm.business.spread.datamanager.CellDataUpdateInfo;
import kd.tmc.fpm.business.spread.datamanager.IReportDataManagerV2;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportDataManagerV2;
import kd.tmc.fpm.business.spread.generator.AuxiliaryCellStyleConvert;
import kd.tmc.fpm.business.spread.generator.AuxiliaryCellStyleInfo;
import kd.tmc.fpm.business.spread.generator.SpreadDataGeneratorFactory;
import kd.tmc.fpm.business.spread.generator.report.IReportSpreadDataGenerator;
import kd.tmc.fpm.common.enums.CellDimTypeEnum;
import kd.tmc.fpm.common.enums.SumPlanLoadType;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.style.CellStyleInfo;
import org.apache.commons.collections4.CollectionUtils;

public class SumPlanManageController
extends BaseManageController
implements ISumPlanManageController {
    private static final Log logger = LogFactory.getLog(SumPlanManageController.class);
    private ISumPlanManageView view;
    private ISumPlanManageService service;
    private IReportManageService reportManageService;

    public SumPlanManageController(ISumPlanManageView view) {
        this.view = view;
        this.service = new SumPlanManageServiceImpl();
        this.reportManageService = new ReportManageService();
    }

    @Override
    public void load(final Long id, final Long systemId, SumPlanLoadType sumPlanLoadType) {
        final String option = sumPlanLoadType.getName();
        this.doFormOperate(new AbstractFpmFormOperate<IReportDataManagerV2>((IFpmFormView)this.view, option){

            @Override
            public FpmOperateResult<IReportDataManagerV2> doOperate() {
                logger.info(String.format("\u5f00\u59cb\u52a0\u8f7d\u6c47\u603b\u5355: reportId => %s", id));
                return SumPlanManageController.this.service.load(id, systemId, SumPlanManageController.this.view.getReferIndex(false), SumPlanManageController.this.getCacheService(SumPlanManageController.this.view.getPageId()));
            }

            @Override
            public void onOperateError(FpmOperateResult<IReportDataManagerV2> result) {
                List<String> errorMsgList = CollectionUtils.isEmpty(result.getMessageList()) ? Collections.singletonList(super.getDefaultErrMessage()) : result.getMessageList();
                SumPlanManageController.this.view.loadCallback(false, errorMsgList);
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<IReportDataManagerV2> result) {
                super.onOperateSuccess(result);
                try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(SumPlanManageController.class.getSimpleName());){
                    SumPlanManageController.this.view.loadCallback(true, null);
                    IReportDataManagerV2 managerImpl = result.getData();
                    ReportTemplate reportTemplate = managerImpl.getReportTemplate();
                    ReportCalcModel currCalcModel = managerImpl.getCurrCalcModel();
                    span.addTag("Create spreadDataGenerator");
                    IReportSpreadDataGenerator spreadDataGenerator = SpreadDataGeneratorFactory.createReportDataGenerator();
                    Book book = spreadDataGenerator.generate(currCalcModel);
                    span.addTag("cache Cell");
                    SumPlanManageController.this.cacheBookCell(book, currCalcModel);
                    SumPlanManageController.this.renderCellStyle(SumPlanManageController.this.getCellDataSource(SumPlanManageController.this.view.getPageId()), managerImpl.getSystem(), book.getSheet().getCellList());
                    span.addTag("Refresh Page Dimension");
                    SumPlanManageController.this.view.refreshPageDim(currCalcModel.getPageDimValList(), true, reportTemplate);
                    span.addTag("Refresh Control");
                    span.addTag("Refresh page Book");
                    SumPlanManageController.this.view.refreshBook(book);
                    span.addTag("Set cache");
                    SumPlanManageController.this.setManagerIntoCache(managerImpl, option);
                }
            }
        });
    }

    @Override
    public void save() {
        final String option = ResManager.loadKDString((String)"\u4fdd\u5b58\u62a5\u8868", (String)"SumPlanManageController_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
        AbstractFpmFormOperate<IReportDataManagerV2> formOperate = new AbstractFpmFormOperate<IReportDataManagerV2>((IFpmFormView)this.view, option){

            @Override
            public FpmOperateResult<IReportDataManagerV2> doOperate() {
                logger.info(String.format("%s \u64cd\u4f5c\u5f00\u59cb\u6267\u884c", option));
                IReportDataManagerV2 reportDataManagerV2 = SumPlanManageController.this.getManagerFromCache();
                return SumPlanManageController.this.service.save(reportDataManagerV2, SumPlanManageController.this.getCellDataSource(SumPlanManageController.this.view.getPageId()));
            }
        };
        formOperate.setShowSuccessMessage(false);
        this.doFormOperate(formOperate);
    }

    @Override
    public void release() {
        this.release(this.view.getPageId());
    }

    @Override
    public void interiorOffset(final Long sumId) {
        String option = ResManager.loadKDString((String)"\u5185\u90e8\u62b5\u6d88", (String)"SumPlanManageController_1", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<SumPlanRecord>((IFpmFormView)this.view, option){

            @Override
            public FpmOperateResult<SumPlanRecord> doOperate() {
                FpmOperateResult<SumPlanRecord> result = SumPlanManageController.this.service.innerCancelAmt(sumId);
                return result;
            }

            @Override
            public void afterDoThings(FpmOperateResult<SumPlanRecord> result) {
                super.afterDoThings(result);
                final SumPlanRecord data = result.getData();
                if (data != null) {
                    HashMap<String, Object> params = new HashMap<String, Object>(16){
                        {
                            super(x0);
                            this.put("offsetornot", data.isInnerCancel());
                        }
                    };
                    SumPlanManageController.this.view.refreshFields((Map<String, Object>)params);
                }
            }
        });
    }

    @Override
    public void countSumPlan(final Long sumRecordId) {
        final String option = ResManager.loadKDString((String)"\u7edf\u8ba1\u6c47\u603b\u5355", (String)"SumPlanManageController_2", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<SumPlanRecordCount>((IFpmFormView)this.view, option){

            @Override
            public FpmOperateResult<SumPlanRecordCount> doOperate() {
                logger.info(String.format("%s \u5f00\u59cb\u6267\u884c\u8ba1\u7b97", option));
                return SumPlanManageController.this.service.countSumPlan(sumRecordId);
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<SumPlanRecordCount> result) {
                SumPlanRecordCount sumPlanRecordCount = result.getData();
                SumPlanManageController.this.view.refreshCnt(sumPlanRecordCount);
            }
        });
    }

    @Override
    public IReportDataManagerV2 getManagerFromCache() {
        String managerJson = this.view.getCache().get("sumplanbill_reportdata_manager_cache");
        IReportDataManagerV2 reportDataManagerV2 = (IReportDataManagerV2)FpmSerializeUtil.deserialize((String)managerJson, ReportDataManagerV2.class);
        IFpmPageCacheService cacheService = this.getCacheService(this.view.getPageId());
        reportDataManagerV2.setCacheService(cacheService);
        return reportDataManagerV2;
    }

    @Override
    public void updateReportData(final List<Cell> cells) {
        final IReportDataManagerV2 manager = this.getManagerFromCache();
        final ArrayList resultCells = new ArrayList(1);
        final String option = ResManager.loadKDString((String)"\u66f4\u65b0\u5355\u5143\u683c", (String)"SumPlanManageController_5", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<List<Cell>>((IFpmFormView)this.view, option){

            @Override
            public FpmOperateResult<List<Cell>> doOperate() {
                manager.setCacheService(SumPlanManageController.this.getCacheService(SumPlanManageController.this.view.getPageId()));
                List<CellDataUpdateInfo> cellDataUpdateInfos = cells.stream().filter(Objects::nonNull).map(o -> {
                    CellDataUpdateInfo cellDataUpdateInfo = new CellDataUpdateInfo();
                    cellDataUpdateInfo.setRow(o.getRow());
                    cellDataUpdateInfo.setCol(o.getCol());
                    cellDataUpdateInfo.setVal(o.getNewValue());
                    return cellDataUpdateInfo;
                }).collect(Collectors.toList());
                FpmOperateResult<List<Cell>> result = SumPlanManageController.this.reportManageService.updateReportData(manager, SumPlanManageController.this.getCellDataSource(SumPlanManageController.this.view.getPageId()), cellDataUpdateInfos);
                resultCells.addAll((Collection)result.getData());
                return result;
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<List<Cell>> result) {
                super.onOperateSuccess(result);
                SumPlanManageController.this.getCellDataSource(SumPlanManageController.this.view.getPageId()).updateCell(resultCells.stream().map(o -> (CacheCell)((Object)o)).collect(Collectors.toList()));
                SumPlanManageController.this.setManagerIntoCache(manager, option);
            }

            @Override
            public void afterDoThings(FpmOperateResult<List<Cell>> result) {
                super.afterDoThings(result);
                if (resultCells.size() > 0) {
                    resultCells.forEach(cell -> {
                        String cellStyleMark = cell.getCellStyleMark();
                        AuxiliaryCellStyleInfo auxiliaryCellStyleInfo = new AuxiliaryCellStyleConvert().toAuxiliaryCellStyle(cellStyleMark);
                        CellStyleInfo cellStyleInfo = auxiliaryCellStyleInfo.generateStyle();
                        cell.setStyleInfo(cellStyleInfo);
                        cell.setColSpan(1);
                        cell.setRowSpan(1);
                    });
                    SumPlanManageController.this.renderCellStyle(resultCells);
                    SumPlanManageController.this.view.updateCell(resultCells);
                }
            }
        });
    }

    private void setManagerIntoCache(IReportDataManagerV2 manager, String option) {
        String managerJson = FpmSerializeUtil.serialize((Object)manager);
        this.view.getCache().put("sumplanbill_reportdata_manager_cache", managerJson);
        logger.info(String.format("\u3010%s\u3011\u4e1a\u52a1\u64cd\u4f5c\u7ed3\u675f: manager => {%s}", option, managerJson));
    }

    private void clearManagerCache() {
        this.view.getCache().remove("sumplanbill_reportdata_manager_cache");
    }

    private void cacheBookCell(Book book, ReportCalcModel calcModel) {
        List<Cell> needCacheCellList = book.getSheet().getCellList().stream().filter(item -> item.getCol() >= calcModel.getColOffset() && item.getRow() >= calcModel.getRowOffset()).collect(Collectors.toList());
        CellDataSource ds = this.getCellDataSource(this.view.getPageId());
        ds.saveAll(needCacheCellList, CacheCell.getFixReportCachePropList(), calcModel);
    }

    private void renderCellStyle(CellDataSource cellDataSource, FundPlanSystem fundPlanSystem, List<Cell> cells) {
        List<ReportCalcValTreeNode> leafColDims = cellDataSource.getMeta().getColDimTree().getLeafList();
        MetricMember ogAmtMember = fundPlanSystem.getMainDimensionByDimType(DimensionType.METRIC).getAllDimMemberList().stream().map(MetricMember.class::cast).filter(metricMember -> metricMember.getTemplateMetricType() == TemplateMetricType.ORIGINALPLANAMT).findFirst().get();
        MetricMember reportPlanAmtMember = fundPlanSystem.getMainDimensionByDimType(DimensionType.METRIC).getAllDimMemberList().stream().map(MetricMember.class::cast).filter(metricMember -> metricMember.getTemplateMetricType() == TemplateMetricType.REPORTPLANAMT).findFirst().get();
        Set ogAmtCols = leafColDims.stream().map(ReportCalcValTreeNode::getCalcVal).filter(calcVal -> ogAmtMember.getId().equals(calcVal.getValue())).map(ReportCalcVal::getCol).collect(Collectors.toSet());
        Set reportPlanAmtCols = leafColDims.stream().map(ReportCalcValTreeNode::getCalcVal).filter(calcVal -> reportPlanAmtMember.getId().equals(calcVal.getValue())).map(ReportCalcVal::getCol).collect(Collectors.toSet());
        cells = cells.stream().filter(Objects::nonNull).filter(cell -> cell.getCellDimType() == CellDimTypeEnum.DATADIMS).filter(cell -> ogAmtCols.contains(cell.getCol())).collect(Collectors.toList());
        for (Cell cell2 : cells) {
            CellStyleInfo styleInfo = cell2.getStyleInfo();
            int col = cell2.getCol();
            if (cell2.getCellType() != CellTypeEnum.AMOUNT || !reportPlanAmtCols.contains(col - 1)) continue;
            Object value = cell2.getValue();
            CacheCell reportPlanCell = cellDataSource.getCell(cell2.getRow(), cell2.getCol() - 1);
            if (reportPlanCell == null || !EmptyUtil.isNoEmpty((Object)value) || Objects.equals(reportPlanCell.getValue(), value)) continue;
            styleInfo.setBkc("#EAF9FF");
            styleInfo.setFrc("#000000");
        }
    }
}

