/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.controller.impl;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateBaseInfo;
import kd.tmc.fpm.business.domain.model.template.TemplateLayout;
import kd.tmc.fpm.business.domain.model.template.TemplateReportType;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.controller.ITemplateManageController;
import kd.tmc.fpm.business.mvc.controller.impl.AbstractFpmFormOperate;
import kd.tmc.fpm.business.mvc.service.ITemplateManageService;
import kd.tmc.fpm.business.mvc.service.impl.TemplateManageService;
import kd.tmc.fpm.business.mvc.view.IFpmFormView;
import kd.tmc.fpm.business.mvc.view.ITemplateManageView;
import kd.tmc.fpm.business.spread.generator.SpreadDataGeneratorFactory;
import kd.tmc.fpm.business.spread.generator.report.IReportSpreadDataGenerator;
import kd.tmc.fpm.common.enums.TemplateTypeEnum;
import kd.tmc.fpm.spread.widget.core.Book;

public class TemplateManageController
implements ITemplateManageController {
    private ITemplateManageView view;
    private ITemplateManageService service;
    private static final String KEY_CACHE_REPORTMANAGER = "KEY_CACHE_REPORTMANAGER";

    public TemplateManageController(ITemplateManageView view) {
        this.view = view;
        this.service = new TemplateManageService();
    }

    @Override
    public void newTemplate(final TemplateBaseInfo baseInfo) {
        this.doFormOperate(new AbstractFpmFormOperate<ReportTemplate>((IFpmFormView)this.view){

            @Override
            public FpmOperateResult<ReportTemplate> doOperate() {
                return TemplateManageController.this.service.createTemplate(baseInfo);
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<ReportTemplate> result) {
                super.onOperateSuccess(result);
                ReportTemplate template = result.getData();
                TemplateManageController.this.view.updateBaseInfo(template);
                TemplateManageController.this.view.updatePageDim(template.getDimLayout().getPageLayout(), template.getPageDimList());
                TemplateManageController.this.view.updateColDim(template.getDimLayout().getColLayout(), template.getColDimList());
                TemplateManageController.this.view.updateRowDim(template.getDimLayout().getRowLayout(), template.getRowDimList());
                TemplateManageController.this.view.updateDimLayout(template.getDimLayout().getDimLayoutInfoList(), template);
            }

            @Override
            public boolean isShowSuccessMessage() {
                return false;
            }
        });
    }

    @Override
    public void loadTemplate(final long templateId) {
        this.doFormOperate(new AbstractFpmFormOperate<ReportTemplate>((IFpmFormView)this.view, ResManager.loadKDString((String)"\u6253\u5f00\u6a21\u677f", (String)"TemplateManageController_0", (String)"tmc-fpm-business", (Object[])new Object[0]), Boolean.FALSE){

            @Override
            public FpmOperateResult<ReportTemplate> doOperate() {
                return TemplateManageController.this.service.loadTemplate(templateId);
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<ReportTemplate> result) {
                super.onOperateSuccess(result);
                ReportTemplate reportTemplate = result.getData();
                TemplateManageController.this.view.updateBaseInfo(reportTemplate);
                TemplateManageController.this.view.updateColDim(reportTemplate.getDimLayout().getColLayout(), reportTemplate.getColDimList());
                TemplateManageController.this.view.updatePageDim(reportTemplate.getDimLayout().getPageLayout(), reportTemplate.getPageDimList());
                TemplateManageController.this.view.updateDimLayout(reportTemplate.getDimLayout().getDimLayoutInfoList(), reportTemplate);
                TemplateManageController.this.view.updateRowDim(reportTemplate.getDimLayout().getRowLayout(), reportTemplate.getRowDimList());
                TemplateManageController.this.view.updateAccountSetting(reportTemplate);
                List<TemplateReportType> reportTypeList = reportTemplate.getReportTypeList();
                if (reportTypeList != null && reportTypeList.size() > 0) {
                    TemplateManageController.this.view.refreshReport(reportTemplate, reportTypeList.get(0).getReportTypeId());
                }
            }

            @Override
            public boolean isShowSuccessMessage() {
                return false;
            }
        });
    }

    @Override
    public void copyTemplate(final long templateId) {
        this.doFormOperate(new AbstractFpmFormOperate<ReportTemplate>((IFpmFormView)this.view, ResManager.loadKDString((String)"\u590d\u5236\u6a21\u677f", (String)"TemplateManageController_1", (String)"tmc-fpm-business", (Object[])new Object[0])){

            @Override
            public FpmOperateResult<ReportTemplate> doOperate() {
                return TemplateManageController.this.service.loadTemplate(templateId);
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<ReportTemplate> result) {
                super.onOperateSuccess(result);
                ReportTemplate reportTemplate = result.getData();
                reportTemplate.setId(0L);
                reportTemplate.setRelease(false);
                DynamicObject newObj = BusinessDataServiceHelper.newDynamicObject((String)"fpm_template");
                newObj.set("templatetype", (Object)TemplateTypeEnum.get((String)reportTemplate.getTemplateType().getNumber()).getValue());
                String number = CodeRuleHelper.generateNumber((String)"fpm_template", (DynamicObject)newObj, null, null);
                reportTemplate.setNumber(number);
                reportTemplate.setUserIdList(null);
                TemplateManageController.this.view.updateBaseInfo(reportTemplate);
                TemplateManageController.this.view.updateColDim(reportTemplate.getDimLayout().getColLayout(), reportTemplate.getColDimList());
                TemplateManageController.this.view.updatePageDim(reportTemplate.getDimLayout().getPageLayout(), reportTemplate.getPageDimList());
                TemplateManageController.this.view.updateRowDim(reportTemplate.getDimLayout().getRowLayout(), reportTemplate.getRowDimList());
                TemplateManageController.this.view.updateDimLayout(reportTemplate.getDimLayout().getDimLayoutInfoList(), reportTemplate);
                TemplateManageController.this.view.updateAccountSetting(reportTemplate);
                if (reportTemplate.getReportTypeList() != null && reportTemplate.getReportTypeList().size() > 0) {
                    TemplateManageController.this.view.refreshReport(reportTemplate, reportTemplate.getReportTypeList().get(0).getReportTypeId());
                }
            }

            @Override
            public boolean isShowSuccessMessage() {
                return false;
            }
        });
    }

    @Override
    public void saveTemplate(final ReportTemplate template) {
        this.doFormOperate(new AbstractFpmFormOperate<ReportTemplate>((IFpmFormView)this.view, ResManager.loadKDString((String)"\u4fdd\u5b58\u6a21\u677f", (String)"TemplateManageController_2", (String)"tmc-fpm-business", (Object[])new Object[0])){

            @Override
            public FpmOperateResult<ReportTemplate> doOperate() {
                return TemplateManageController.this.service.saveTemplate(template);
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<ReportTemplate> result) {
                super.onOperateSuccess(result);
                ReportTemplate reportTemplate = result.getData();
                TemplateManageController.this.view.updateBaseInfo(reportTemplate);
                if (reportTemplate.getReportTypeList() != null && reportTemplate.getReportTypeList().size() > 0) {
                    TemplateManageController.this.view.refreshReport(reportTemplate, reportTemplate.getReportTypeList().get(0).getReportTypeId());
                }
            }
        });
    }

    @Override
    public void refreshReport(ReportTemplate template, Long periodTypeId) {
        this.refreshReport(template, periodTypeId, null);
    }

    @Override
    public void refreshReport(final ReportTemplate template, final Long periodTypeId, final Long sumOrgId) {
        this.doFormOperate(new AbstractFpmFormOperate<ReportModel>((IFpmFormView)this.view){

            @Override
            public FpmOperateResult<ReportModel> doOperate() {
                return TemplateManageController.this.service.refreshReport(template, periodTypeId, sumOrgId);
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<ReportModel> result) {
                super.onOperateSuccess(result);
                ReportModel reportModel = result.getData();
                ReportCalcModel templateModel = reportModel.getTemplateModel();
                IReportSpreadDataGenerator spreadDataGenerator = SpreadDataGeneratorFactory.createReportDataGenerator();
                Book book = spreadDataGenerator.generate(templateModel);
                TemplateManageController.this.view.updateReport(book);
                Set<Integer> hideRowSet = templateModel.getRowDimValList().stream().filter(ReportCalcVal::isHide).map(ReportCalcVal::getRow).collect(Collectors.toSet());
                TemplateManageController.this.view.hideRows(hideRowSet);
            }

            @Override
            public boolean isShowSuccessMessage() {
                return false;
            }
        });
    }

    @Override
    public void updateDimLayout(final ReportTemplate template, final TemplateLayout layout) {
        this.doFormOperate(new AbstractFpmFormOperate<ReportTemplate>((IFpmFormView)this.view, ResManager.loadKDString((String)"\u7ef4\u5ea6\u5e03\u5c40\u8bbe\u7f6e", (String)"TemplateManageController_3", (String)"tmc-fpm-business", (Object[])new Object[0])){

            @Override
            public FpmOperateResult<ReportTemplate> doOperate() {
                return TemplateManageController.this.service.updateDimLayout(template, layout);
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<ReportTemplate> result) {
                super.onOperateSuccess(result);
                TemplateManageController.this.view.updateDimLayout(template.getDimLayout().getDimLayoutInfoList(), template);
                TemplateManageController.this.view.updatePageDim(layout.getPageLayout(), template.getPageDimList());
                TemplateManageController.this.view.updateColDim(layout.getColLayout(), template.getColDimList());
                TemplateManageController.this.view.updateRowDim(layout.getRowLayout(), template.getRowDimList());
            }
        });
    }

    @Override
    public void updateAccountSetting(final ReportTemplate template) {
        this.doFormOperate(new AbstractFpmFormOperate<Void>((IFpmFormView)this.view, ResManager.loadKDString((String)"\u79d1\u76ee\u6210\u5458\u5c5e\u6027\u8bbe\u7f6e", (String)"TemplateManageController_4", (String)"tmc-fpm-business", (Object[])new Object[0])){

            @Override
            public FpmOperateResult<Void> doOperate() {
                return FpmOperateResult.success();
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<Void> result) {
                super.onOperateSuccess(result);
                TemplateManageController.this.view.updateAccountSetting(template);
            }
        });
    }

    @Override
    public void updateBaseInfo(final ReportTemplate template, final TemplateBaseInfo templateBaseInfo) {
        this.doFormOperate(new AbstractFpmFormOperate<Void>((IFpmFormView)this.view, ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u8bbe\u7f6e", (String)"TemplateManageController_5", (String)"tmc-fpm-business", (Object[])new Object[0])){

            @Override
            public FpmOperateResult<Void> doOperate() {
                template.fillBaseInfo(templateBaseInfo);
                return FpmOperateResult.success();
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<Void> result) {
                super.onOperateSuccess(result);
                TemplateManageController.this.view.updateBaseInfo(template);
            }
        });
    }

    @Override
    public void releaseTemplate(final ReportTemplate template) {
        this.doFormOperate(new AbstractFpmFormOperate<ReportTemplate>((IFpmFormView)this.view, ResManager.loadKDString((String)"\u6a21\u677f\u53d1\u5e03", (String)"TemplateManageController_6", (String)"tmc-fpm-business", (Object[])new Object[0])){

            @Override
            public FpmOperateResult<ReportTemplate> doOperate() {
                return TemplateManageController.this.service.releaseTemplate(template);
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<ReportTemplate> result) {
                super.onOperateSuccess(result);
                TemplateManageController.this.view.updateBaseInfo(template);
            }
        });
    }

    private <T> void doFormOperate(AbstractFpmFormOperate<T> formOperate) {
        FpmOperateResult result = formOperate.doOperate();
        if (result.isSuccess()) {
            formOperate.onOperateSuccess(result);
        } else {
            formOperate.onOperateError(result);
        }
    }
}

