/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.util.Objects;
import kd.bos.algo.Row;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.model.report.AdjustAmtInfo;
import kd.tmc.fpm.business.mvc.converter.control.IConverter;

public class AdjustAmtInfoConverter
implements IConverter<AdjustAmtInfo, Row> {
    @Override
    public AdjustAmtInfo convert(Row row) {
        Long currencyId = row.getLong(String.join((CharSequence)".", "adjust_entryentity", "adjust_currency"));
        Long pageMember1 = row.getLong(String.join((CharSequence)".", "adjust_entryentity", "adjust_custompage1"));
        Long pageMember2 = row.getLong(String.join((CharSequence)".", "adjust_entryentity", "adjust_custompage2"));
        String amtUnit = row.getString(String.join((CharSequence)".", "adjust_entryentity", "adjust_amtunit"));
        if (Objects.isNull(amtUnit)) {
            return null;
        }
        AdjustAmtInfo adjustAmtInfo = new AdjustAmtInfo(new AdjustAmtInfo.CombinationKey(currencyId, pageMember1, pageMember2), AmountUnit.getByNumber(amtUnit));
        adjustAmtInfo.setAdjustSumAmtIn(row.getBigDecimal(String.join((CharSequence)".", "adjust_entryentity", "adjust_adjustsumamtin")));
        adjustAmtInfo.setAdjustSumAmtOut(row.getBigDecimal(String.join((CharSequence)".", "adjust_entryentity", "adjust_adjustsumamtout")));
        adjustAmtInfo.setAdjustSumAmtBal(row.getBigDecimal(String.join((CharSequence)".", "adjust_entryentity", "adjust_adjustsumamtbal")));
        return adjustAmtInfo;
    }
}

