/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.exception.FpmRequestException;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryService;
import kd.tmc.fpm.business.dataproc.save.domain.ReportDataBatchSaveObject;
import kd.tmc.fpm.business.dataproc.save.domain.ReportDataBatchSaveParam;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.FpmErrorCodeEnum;
import kd.tmc.fpm.business.domain.enums.ReportDataType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.BatchSaveSDKReportData;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.converter.control.IConverter;
import kd.tmc.fpm.business.utils.MetricValueUtils;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.utils.AmountUtil;
import org.apache.commons.collections4.CollectionUtils;

public class BatchSaveParamReportConverter
implements IConverter<Report, ReportDataBatchSaveParam> {
    private Report report;
    private FundPlanSystem fundPlanSystem;
    private ReportTemplate reportTemplate;
    private Long reportOrgId;
    private Map<String, List<TemplateDim>> templateMainDimMap;
    private Map<String, Long> dimMemberCodeAndIdMap;
    private List<TemplateAccountSetting> leafSubjectList;
    private List<PeriodMember> currentAllPeriodMembers;
    private BigDecimal INVALID_AMT = new BigDecimal(Long.MAX_VALUE);

    public BatchSaveParamReportConverter() {
    }

    public BatchSaveParamReportConverter(Report report, FundPlanSystem fundPlanSystem, Long reportOrgId) {
        this.report = report;
        this.fundPlanSystem = fundPlanSystem;
        this.reportTemplate = report.getTemplate();
        this.reportOrgId = reportOrgId;
        this.templateMainDimMap = this.reportTemplate.getAllTemplateDim().stream().filter(item -> item.getDimType() != DimensionType.DETAILDIM).collect(Collectors.groupingBy(o -> o.getDimType().getNumber()));
        this.dimMemberCodeAndIdMap = new HashMap<String, Long>(16);
        this.leafSubjectList = report.getTemplate().getAccountSettings().stream().filter(subject -> EmptyUtil.isEmpty(subject.getChildren())).collect(Collectors.toList());
        this.currentAllPeriodMembers = this.report.getCurrentAllPeriodMembers();
    }

    @Override
    public Report convert(ReportDataBatchSaveParam saveParam) {
        List<ReportData> reportDataList = this.convertSaveParam2ReportData(saveParam.getBatchSaveData());
        this.updateReportDataList(reportDataList);
        return this.report;
    }

    private List<ReportData> convertSaveParam2ReportData(List<ReportDataBatchSaveObject> batchSaveData) {
        ArrayList<ReportData> reportDataList = new ArrayList<ReportData>(batchSaveData.size());
        for (ReportDataBatchSaveObject saveObject : batchSaveData) {
            ArrayList<TemplateDim> dimList = new ArrayList<TemplateDim>(8);
            ArrayList<Object> dimValList = new ArrayList<Object>(8);
            this.dealDimMemberDataOfMainDim(saveObject, dimList, dimValList);
            BatchSaveSDKReportData reportData = new BatchSaveSDKReportData();
            reportData.setDimList(dimList);
            reportData.setDimValList(dimValList);
            reportData.setVersion(1);
            reportData.setLinkedReportId(this.report.getId());
            reportData.setDirty(true);
            reportData.setReportPeriodId(this.report.getPeriodMemberList().get(0).getId());
            reportData.setMainTable(this.report.getTemplate().isMainTable());
            reportData.setReportId(this.report.getId());
            reportData.setDataType(ReportDataType.DIM_MEM);
            reportData.setSystemId(this.fundPlanSystem.getId());
            reportData.setEffectFlag(false);
            this.setReportDataAmt(saveObject.getMetricMembers(), reportData);
            reportData.setRow(0);
            reportData.setCol(0);
            MetricValueUtils.fillMetricValMap(reportData, this.report);
            reportDataList.add(reportData);
        }
        return reportDataList;
    }

    private void dealDimMemberDataOfMainDim(ReportDataBatchSaveObject saveObject, List<TemplateDim> dimList, List<Object> dimValList) {
        Set<Map.Entry<String, String>> mainDimEntrySet = ReportDataQueryService.MAINDIM_ENTRY_MAPPING_MAP.entrySet();
        for (Map.Entry<String, String> mainDimEntry : mainDimEntrySet) {
            List<TemplateDim> templateDimList;
            String key = mainDimEntry.getKey();
            if (this.dealCustomMember(saveObject, dimList, dimValList, key) || CollectionUtils.isEmpty(templateDimList = this.templateMainDimMap.get(mainDimEntry.getKey()))) continue;
            TemplateDim templateDim = templateDimList.get(0);
            Long dimMemberId = 0L;
            switch (templateDim.getDimType()) {
                case ORG: {
                    dimMemberId = this.reportOrgId;
                    break;
                }
                case CURRENCY: {
                    dimMemberId = this.getDimMemberId(templateDim, saveObject.getCurrencyCode());
                    break;
                }
                case PERIOD: {
                    dimMemberId = this.getDimMemberId(templateDim, saveObject.getEntryPeriodCode());
                    break;
                }
                case SUBJECTS: {
                    dimMemberId = this.getSubjectMemberId(templateDim, saveObject.getSubjectCode());
                    break;
                }
                case COMPANY: {
                    dimMemberId = this.getDimMemberId(templateDim, saveObject.getCompanyCode());
                    break;
                }
                case SETTLEMENT_TYPE: {
                    dimMemberId = this.getDimMemberId(templateDim, saveObject.getSettleTypeCode());
                    break;
                }
            }
            if (Objects.equals(dimMemberId, 0L)) continue;
            dimList.add(templateDim);
            dimValList.add(dimMemberId);
        }
    }

    private Long getSubjectMemberId(TemplateDim templateDim, String subjectCode) {
        Long dimMemberId = this.getDimMemberId(templateDim, subjectCode);
        boolean isLeafSubject = this.leafSubjectList.stream().anyMatch(c -> dimMemberId.equals(c.getAccountMemId()));
        if (!isLeafSubject) {
            throw new FpmRequestException(FpmErrorCodeEnum.INVALID_NON_LEAF_DIM_MEMBER, subjectCode);
        }
        return dimMemberId;
    }

    private boolean dealCustomMember(ReportDataBatchSaveObject saveObject, List<TemplateDim> dimList, List<Object> dimValList, String key) {
        if (!Objects.equals(DimensionType.CUSTOM.getNumber(), key)) {
            return false;
        }
        List<TemplateDim> templateDimList = this.templateMainDimMap.get(key);
        if (EmptyUtil.isEmpty(templateDimList)) {
            return true;
        }
        for (int i = 0; i < templateDimList.size(); ++i) {
            Long memberId;
            if (i == 0 && EmptyUtil.isNoEmpty((String)saveObject.getCustom1Code())) {
                memberId = this.getDimMemberId(templateDimList.get(i), saveObject.getCustom1Code());
                if (Objects.isNull(memberId)) continue;
                dimList.add(templateDimList.get(i));
                dimValList.add(memberId);
                continue;
            }
            if (i == 1 && EmptyUtil.isNoEmpty((String)saveObject.getCustom2Code())) {
                memberId = this.getDimMemberId(templateDimList.get(i), saveObject.getCustom2Code());
                if (Objects.isNull(memberId)) continue;
                dimList.add(templateDimList.get(i));
                dimValList.add(memberId);
                continue;
            }
            if (i != 2 || !EmptyUtil.isNoEmpty((String)saveObject.getCustom3Code()) || Objects.isNull(memberId = this.getDimMemberId(templateDimList.get(i), saveObject.getCustom3Code()))) continue;
            dimList.add(templateDimList.get(i));
            dimValList.add(memberId);
        }
        return true;
    }

    private Long getDimMemberId(TemplateDim templateDim, String dimMemberCode) {
        boolean nonExistTemplateMemberScope;
        Long memberId = this.dimMemberCodeAndIdMap.computeIfAbsent(dimMemberCode, code -> {
            Dimension dimension = this.fundPlanSystem.getMainDimensionByDimensionId(templateDim.getDimensionId());
            Optional<DimMember> custom1DimMemberOp = dimension.getAllDimMemberList().stream().filter(dimMember -> Objects.equals(dimMember.getNumber(), dimMemberCode)).findAny();
            return custom1DimMemberOp.map(DimMember::getId).orElse(null);
        });
        if (Objects.isNull(memberId)) {
            throw new FpmRequestException(FpmErrorCodeEnum.NON_EXIST_DIM_MEMBER, dimMemberCode);
        }
        boolean bl = templateDim.getDimType() == DimensionType.PERIOD ? this.currentAllPeriodMembers.stream().noneMatch(periodMember -> periodMember.getId().equals(memberId)) : (nonExistTemplateMemberScope = !templateDim.getMemberScope().contains(memberId));
        if (nonExistTemplateMemberScope) {
            throw new FpmRequestException(FpmErrorCodeEnum.NON_EXIST_TEMPLATE_DIM_MEMBER, dimMemberCode);
        }
        return memberId;
    }

    private void setReportDataAmt(List<ReportDataBatchSaveObject.MetricMember> metricMembers, ReportData reportData) {
        this.setInvalidAmt(reportData);
        metricMembers.forEach(metricMember -> {
            AmountUnitEnum sourceAmountUnit = Optional.ofNullable(metricMember.getAmountUnit()).map(unit -> AmountUnitEnum.get((String)unit.getNumber())).orElse(AmountUnitEnum.ONE);
            AmountUnitEnum targetAmountUnit = AmountUnitEnum.get((String)this.reportTemplate.getAmountUnit().getNumber());
            BigDecimal convertAmt = AmountUtil.convert((AmountUnitEnum)sourceAmountUnit, (AmountUnitEnum)targetAmountUnit, (BigDecimal)metricMember.getAmount());
            reportData.setAmountUnit(this.reportTemplate.getAmountUnit());
            MetricValueUtils.setMetricValue(metricMember.getTemplateMetricType(), reportData, convertAmt);
        });
    }

    private void updateReportDataList(List<ReportData> newReportDataList) {
        DimensionIndexTree indexTree = this.report.getIndexTree(this.fundPlanSystem);
        ArrayList<ReportData> removeList = new ArrayList<ReportData>(newReportDataList.size());
        for (ReportData reportData : newReportDataList) {
            ArrayList<Long> dimIdList = new ArrayList<Long>(reportData.getDimList().size());
            ArrayList<Object> dimMemIdList = new ArrayList<Object>(reportData.getDimList().size());
            List<Object> prepareData = reportData.getDimValList();
            for (int inx = 0; inx < reportData.getDimList().size(); ++inx) {
                TemplateDim templateDim = reportData.getDimList().get(inx);
                if (templateDim.getDimType() == DimensionType.DETAILDIM) continue;
                dimIdList.add(templateDim.getDimensionId());
                dimMemIdList.add(prepareData.get(inx));
            }
            DimensionInfoBean dimensionInfoBean = new DimensionInfoBean();
            dimensionInfoBean.setDimensionIdList(dimIdList);
            dimensionInfoBean.setMemberIdList(dimMemIdList);
            TreeNode node = indexTree.find(dimensionInfoBean);
            if (!Objects.nonNull(node) || !CollectionUtils.isNotEmpty(node.getDataList())) continue;
            node.getDataList().stream().map(data -> (ReportData)data).forEach(dbReportData -> {
                dbReportData.setPlanAmt(this.isValidAmt(reportData.getPlanAmt()) ? reportData.getPlanAmt() : dbReportData.getPlanAmt());
                dbReportData.setReportPlanAmt(this.isValidAmt(reportData.getReportPlanAmt()) ? reportData.getReportPlanAmt() : dbReportData.getReportPlanAmt());
                dbReportData.setOriginalPlanAmt(this.isValidAmt(reportData.getOriginalPlanAmt()) ? reportData.getOriginalPlanAmt() : dbReportData.getOriginalPlanAmt());
                dbReportData.setPlanReferenceAmt(this.isValidAmt(reportData.getPlanReferenceAmt()) ? reportData.getPlanReferenceAmt() : dbReportData.getPlanReferenceAmt());
                dbReportData.setLockAmt(this.isValidAmt(reportData.getLockAmt()) ? reportData.getLockAmt() : dbReportData.getLockAmt());
                dbReportData.setActAmt(this.isValidAmt(reportData.getActAmt()) ? reportData.getActAmt() : dbReportData.getActAmt());
                dbReportData.setDirty(true);
            });
            removeList.add(reportData);
        }
        newReportDataList.removeAll(removeList);
        newReportDataList.forEach(this::setZeroAmtIfInvalidAmtExist);
        this.report.getReportDataList().addAll(newReportDataList);
    }

    private boolean isValidAmt(BigDecimal amt) {
        return this.INVALID_AMT.compareTo(amt) != 0;
    }

    private void setInvalidAmt(ReportData reportData) {
        reportData.setPlanAmt(this.INVALID_AMT);
        reportData.setReportPlanAmt(this.INVALID_AMT);
        reportData.setOriginalPlanAmt(this.INVALID_AMT);
        reportData.setPlanReferenceAmt(this.INVALID_AMT);
        reportData.setLockAmt(this.INVALID_AMT);
        reportData.setActAmt(this.INVALID_AMT);
    }

    private void setZeroAmtIfInvalidAmtExist(ReportData reportData) {
        reportData.setPlanAmt(this.isValidAmt(reportData.getPlanAmt()) ? reportData.getPlanAmt() : BigDecimal.ZERO);
        reportData.setReportPlanAmt(this.isValidAmt(reportData.getReportPlanAmt()) ? reportData.getReportPlanAmt() : BigDecimal.ZERO);
        reportData.setOriginalPlanAmt(this.isValidAmt(reportData.getOriginalPlanAmt()) ? reportData.getOriginalPlanAmt() : BigDecimal.ZERO);
        reportData.setPlanReferenceAmt(this.isValidAmt(reportData.getPlanReferenceAmt()) ? reportData.getPlanReferenceAmt() : BigDecimal.ZERO);
        reportData.setLockAmt(this.isValidAmt(reportData.getLockAmt()) ? reportData.getLockAmt() : BigDecimal.ZERO);
        reportData.setActAmt(this.isValidAmt(reportData.getActAmt()) ? reportData.getActAmt() : BigDecimal.ZERO);
    }
}

