/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.domain.enums.ControlMatchType;
import kd.tmc.fpm.business.domain.enums.MatchPropType;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.control.MatchMapping;
import kd.tmc.fpm.business.domain.model.dimension.DimMemberMapping;
import kd.tmc.fpm.common.enums.MatchRuleMapRelationEnum;
import org.apache.commons.lang3.StringUtils;

public class BillMatchRuleConverter {
    private static final Log logger = LogFactory.getLog(BillMatchRuleConverter.class);

    public static List<BillMatchRule> batchConvertToBillMatchRule(DynamicObject[] matchRules, Map<Long, List<DimMemberMapping>> memberMappingInfoMaps) {
        ArrayList<BillMatchRule> matchRuleList = new ArrayList<BillMatchRule>(matchRules.length);
        for (DynamicObject matchRuleDy : matchRules) {
            BillMatchRule matchRule = BillMatchRuleConverter.singleConvertToBillMatchRule(matchRuleDy, memberMappingInfoMaps);
            if (matchRule == null) continue;
            matchRuleList.add(matchRule);
        }
        return matchRuleList;
    }

    public static BillMatchRule singleConvertToBillMatchRule(DynamicObject matchRuleDy, Map<Long, List<DimMemberMapping>> memberMappingInfoMaps) {
        if (matchRuleDy == null) {
            return null;
        }
        BillMatchRule matchRule = new BillMatchRule();
        Long id = matchRuleDy.getLong("id");
        if (id.equals(0L)) {
            id = Long.valueOf(matchRuleDy.getPkValue().toString());
        }
        matchRule.setId(id);
        matchRule.setSystemId(matchRuleDy.getLong(String.join((CharSequence)".", "bodysys", "id")));
        matchRule.setName(matchRuleDy.getString("name"));
        matchRule.setNumber(matchRuleDy.getString("number"));
        matchRule.setEntityType(matchRuleDy.getString("businessbill.number"));
        matchRule.setExtraCondition(matchRuleDy.getString("abnormalcondition_real_TAG"));
        matchRule.setMappingEntryNumber(matchRuleDy.getString("linkentity"));
        matchRule.setApplyCondition(matchRuleDy.getString("applycondition_real_TAG"));
        matchRule.setEnable(matchRuleDy.getBoolean("enable"));
        DynamicObjectCollection mappingEntrys = matchRuleDy.getDynamicObjectCollection("entryentity");
        ArrayList<MatchMapping> matchMappings = null;
        if (null != mappingEntrys && mappingEntrys.size() > 0) {
            matchMappings = new ArrayList<MatchMapping>(mappingEntrys.size());
            for (DynamicObject mappingEntryDy : mappingEntrys) {
                MatchMapping matchMapping = new MatchMapping();
                matchMapping.setDimId(mappingEntryDy.getLong(String.join((CharSequence)".", "entry_dimensiondetail", "id")));
                matchMapping.setBizProp(mappingEntryDy.getString("entry_businessbillfield"));
                matchMapping.setAssistBizProp(mappingEntryDy.getString("entry_secondbusinessbill"));
                matchMapping.setSkipNullVal(mappingEntryDy.getBoolean("entry_allowempty"));
                DimMemberMapping dimMemberMappingLst = Optional.ofNullable(mappingEntryDy.getDynamicObject("entry_dimensionmembermap")).map(o -> BillMatchRuleConverter.getMemberMMappingById(memberMappingInfoMaps, o.getPkValue())).orElseGet(() -> null);
                String matchProp = mappingEntryDy.getString("entry_matchprop");
                if (StringUtils.isNotEmpty((CharSequence)matchProp)) {
                    matchMapping.setMatchPropType(MatchPropType.getByNumber(matchProp));
                }
                matchMapping.setDimMapping(dimMemberMappingLst);
                String mapRelation = mappingEntryDy.getString("entry_maprelation");
                if (MatchRuleMapRelationEnum.EQUALS.getCode().equals(mapRelation)) {
                    matchMapping.setMatchType(ControlMatchType.EQUALS);
                } else if (MatchRuleMapRelationEnum.CONTAINS.getCode().equals(mapRelation)) {
                    matchMapping.setMatchType(ControlMatchType.CONTAIN);
                }
                matchMappings.add(matchMapping);
            }
        }
        matchRule.setMappings(matchMappings);
        return matchRule;
    }

    private static DimMemberMapping getMemberMMappingById(Map<Long, List<DimMemberMapping>> memberMappingInfoMaps, Object memberId) {
        List<DimMemberMapping> dimMemberMappings = memberMappingInfoMaps.get(memberId);
        if (dimMemberMappings == null || dimMemberMappings.size() == 0) {
            return null;
        }
        return dimMemberMappings.get(0);
    }
}

