/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.control.BizProps;
import kd.tmc.fpm.business.domain.model.control.MatchMapping;
import kd.tmc.fpm.business.mvc.converter.control.IConverter;
import kd.tmc.fpm.business.mvc.service.dto.ControlExcuteServiceLogParamDTO;
import kd.tmc.fpm.business.mvc.service.params.BillDimensionMatchInfo;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;

public class ControlExecuteParamConverter
implements IConverter<ControlExecuteParam, ControlExcuteServiceLogParamDTO> {
    @Override
    public ControlExecuteParam convert(ControlExcuteServiceLogParamDTO controlExcuteServiceLogParamDTO) {
        ControlExecuteParam controlExecuteParam = new ControlExecuteParam();
        if (Objects.isNull(controlExcuteServiceLogParamDTO)) {
            return controlExecuteParam;
        }
        controlExecuteParam.setBillBizInfo(controlExcuteServiceLogParamDTO.getBillBizInfo());
        controlExecuteParam.setMatchRule(controlExcuteServiceLogParamDTO.getMatchRule());
        controlExecuteParam.setBizOpName(controlExcuteServiceLogParamDTO.getBizOpName());
        controlExecuteParam.setReportOrgId(controlExcuteServiceLogParamDTO.getReportOrgId());
        controlExecuteParam.setActAmount(controlExcuteServiceLogParamDTO.getOpAmount());
        controlExecuteParam.setOpType(controlExcuteServiceLogParamDTO.getServiceType());
        controlExecuteParam.setUniqueId(controlExcuteServiceLogParamDTO.getUniqueId());
        controlExecuteParam.setSystemId(controlExcuteServiceLogParamDTO.getMatchRule().getSystemId());
        this.fillBillDimensionMatchInfo(controlExecuteParam);
        return controlExecuteParam;
    }

    private void fillBillDimensionMatchInfo(ControlExecuteParam controlExecuteParam) {
        BillMatchRule matchRule = controlExecuteParam.getMatchRule();
        List<BizProps> bizProps = controlExecuteParam.getBillBizInfo().getBizProps();
        if (EmptyUtil.isEmpty((Object)matchRule)) {
            return;
        }
        if (EmptyUtil.isEmpty(bizProps)) {
            return;
        }
        Map<String, Object> bizPropMap = bizProps.stream().filter(prop -> EmptyUtil.isNoEmpty((Object)prop.getValue())).collect(Collectors.toMap(BizProps::getBizProp, BizProps::getValue, (a, b) -> a));
        List<MatchMapping> mappings = matchRule.getMappings();
        BillDimensionMatchInfo billDimensionMatchInfo = new BillDimensionMatchInfo(controlExecuteParam.getBillBizInfo().getBillId());
        for (MatchMapping matchMapping : mappings) {
            Long dimId = matchMapping.getDimId();
            String bizProp = matchMapping.getBizProp();
            String assistBizProp = matchMapping.getAssistBizProp();
            Object matchValue = bizPropMap.getOrDefault(bizProp, "");
            if (EmptyUtil.isNoEmpty((String)assistBizProp)) {
                bizProp = String.join((CharSequence)"#", bizProp, assistBizProp);
                Object assistMatchValue = bizPropMap.getOrDefault(assistBizProp, "");
                matchValue = String.join((CharSequence)"#", matchValue.toString(), assistMatchValue.toString());
            }
            billDimensionMatchInfo.addMatchInfo(dimId, bizProp, matchValue);
        }
        controlExecuteParam.setBillDimensionMatchInfo(billDimensionMatchInfo);
    }
}

