/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.sumplan.DetailEntryReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.converter.ReportPoConverter;
import kd.tmc.fpm.business.mvc.converter.control.IConverter;
import kd.tmc.fpm.business.utils.DimensionMappingHelper;

public class DetailEntryReportDataDynamicConverter
implements IConverter<DynamicObject, DetailEntryReportData> {
    private static final Set<DetailDimType> BASE_DATA_PROP;

    @Override
    public DynamicObject convert(DetailEntryReportData reportData) {
        if (Objects.isNull(reportData)) {
            return null;
        }
        DynamicObject detailEntry = this.getDynamicObject();
        detailEntry.set("id", (Object)reportData.getId());
        detailEntry.set("maindimdataid", (Object)reportData.getId());
        detailEntry.set("remark", (Object)reportData.getRemark());
        List<TemplateDim> dimList = reportData.getDimList();
        List<Object> dimValList = reportData.getDimValList();
        Map<String, String> detailExtraFieldsMapping = DimensionMappingHelper.getDetailExtraFieldsMapping(reportData.getSystemId(), "fpm_report");
        for (int i = 0; i < dimList.size(); ++i) {
            String entrySignByDimType;
            TemplateDim templateDim = dimList.get(i);
            Object value = dimValList.get(i);
            DimensionType dimType = templateDim.getDimType();
            if (!dimType.isDetailDim()) continue;
            DetailDimType detailDimType = templateDim.getDetailDimType();
            if (DetailDimType.isExtraField(detailDimType)) {
                entrySignByDimType = detailExtraFieldsMapping.get(detailDimType.getNumber());
                if (value instanceof Date) {
                    value = ((Date)value).getTime();
                }
            } else {
                entrySignByDimType = DetailEntryReportDataDynamicConverter.getEntrySignByDimType(detailDimType.getNumber());
            }
            if (entrySignByDimType == null) continue;
            if (BASE_DATA_PROP.contains((Object)detailDimType)) {
                entrySignByDimType = String.join((CharSequence)"_", entrySignByDimType, "id");
            }
            detailEntry.set(entrySignByDimType, value);
        }
        return detailEntry;
    }

    private static String getEntrySignByDimType(String number) {
        return ReportPoConverter.TYPE_MAPPING_MAP.get(number);
    }

    private DynamicObject getDynamicObject() {
        DynamicObject dynamicObject = TmcDataServiceHelper.newDynamicObject((String)"fpm_report");
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("detailentry");
        return dynamicObjectCollection.addNew();
    }

    static {
        HashSet<DetailDimType> set = new HashSet<DetailDimType>(16);
        set.add(DetailDimType.COUNTERPARTY_NAME);
        set.add(DetailDimType.BANK_CATE);
        set.add(DetailDimType.BUSINESS_PARTNER);
        set.add(DetailDimType.BANK_ACCOUNT);
        BASE_DATA_PROP = Collections.unmodifiableSet(set);
    }
}

