/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ReportProcessStatus;
import kd.tmc.fpm.business.domain.model.execbiasanalys.ExecBiasAnalys;
import kd.tmc.fpm.business.mvc.converter.control.IConverter;
import kd.tmc.fpm.business.utils.FpmDataServiceHelper;

public class ExecBiasAnalysDynamicConverter
implements IConverter<DynamicObject, ExecBiasAnalys> {
    @Override
    public DynamicObject convert(ExecBiasAnalys execBiasAnalys) {
        DynamicObject dynamicObject = this.getExecBiasAnalys(execBiasAnalys.getId());
        dynamicObject.set("billno", (Object)execBiasAnalys.getNumber());
        Long systemId = execBiasAnalys.getSystemId();
        dynamicObject.set("bodysys", (Object)FpmDataServiceHelper.newDynamicObject("fpm_bodysysmanage", systemId));
        dynamicObject.set("reportorg", (Object)FpmDataServiceHelper.newDynamicObject("fpm_member", execBiasAnalys.getReportOrgId()));
        dynamicObject.set("reportperiod", (Object)FpmDataServiceHelper.newDynamicObject("fpm_member", execBiasAnalys.getReportPeriodId()));
        dynamicObject.set("name", (Object)execBiasAnalys.getName());
        dynamicObject.set("sourcebilltype", (Object)execBiasAnalys.getSourceBillType().getValue());
        Long reportTypeId = execBiasAnalys.getReportTypeId();
        if (EmptyUtil.isNoEmpty((Long)reportTypeId)) {
            dynamicObject.set("reporttype", (Object)FpmDataServiceHelper.newDynamicObject("fpm_orgreporttype", reportTypeId));
        }
        dynamicObject.set("reportperiod", (Object)execBiasAnalys.getReportPeriodId());
        dynamicObject.set("creator", this.getVoucherMan(execBiasAnalys));
        dynamicObject.set("billstatus", (Object)(EmptyUtil.isEmpty((Object)((Object)execBiasAnalys.getProcessStatus())) ? ReportProcessStatus.SAVE.getValue() : execBiasAnalys.getProcessStatus().getValue()));
        dynamicObject.set("exratetable", (Object)execBiasAnalys.getExrateTableId());
        dynamicObject.set("exchangeratedate", (Object)execBiasAnalys.getExchangeRateDate());
        dynamicObject.set("amountunit", (Object)execBiasAnalys.getAmountUnit().getNumber());
        dynamicObject.set("remark", (Object)execBiasAnalys.getRemark());
        dynamicObject.set("sourcebill", (Object)execBiasAnalys.getSourcebill());
        dynamicObject.set("planstatus", EmptyUtil.isEmpty((Object)((Object)execBiasAnalys.getReportStatus())) ? null : execBiasAnalys.getReportStatus().getVal());
        dynamicObject.set("declarestartdate", (Object)execBiasAnalys.getDeclareStartDate());
        dynamicObject.set("declaredeadline", (Object)execBiasAnalys.getDeclareEndDate());
        return dynamicObject;
    }

    private Object getVoucherMan(ExecBiasAnalys execBiasAnalys) {
        ReportProcessStatus status = execBiasAnalys.getProcessStatus();
        if (Objects.nonNull((Object)status) && status != ReportProcessStatus.SAVE) {
            return execBiasAnalys.getCreatorId();
        }
        return EmptyUtil.isEmpty((Long)execBiasAnalys.getCreatorId()) ? Long.valueOf(RequestContext.get().getCurrUserId()) : execBiasAnalys.getCreatorId();
    }

    private DynamicObject getExecBiasAnalys(Long id) {
        boolean exists = TmcDataServiceHelper.exists((Object)id, (String)"fpm_execbiasanalys");
        DynamicObject execBiasAnalysDynamicObject = exists ? TmcDataServiceHelper.loadSingle((Object)id, (String)"fpm_execbiasanalys") : TmcDataServiceHelper.newDynamicObject((String)"fpm_execbiasanalys");
        return execBiasAnalysDynamicObject;
    }
}

