/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DiffProcessModeType;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.SumPlanSumType;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancelDetail;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancelRecord;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancleTotal;
import kd.tmc.fpm.business.mvc.converter.control.Converter;
import kd.tmc.fpm.common.enums.DiffDirectionEnum;
import org.apache.commons.collections4.CollectionUtils;

public class InnerCancelRecordConverter
implements Converter<InnerCancelRecord> {
    @Override
    public InnerCancelRecord convert(DynamicObject dy) {
        DynamicObjectCollection dynamicObjectCollection;
        InnerCancelRecord record = new InnerCancelRecord();
        record.setId((Long)dy.getPkValue());
        record.setCancelRuleId((Long)dy.getDynamicObject("cancelruleid").getPkValue());
        record.setSystemId((Long)dy.getDynamicObject("systemid").getPkValue());
        record.setSumPlanSumType(SumPlanSumType.REPORTPLAN);
        record.setOrgReportTypeId((Long)dy.getDynamicObject("orgreporttype").getPkValue());
        record.setOrgId((Long)dy.getDynamicObject("orgid").getPkValue());
        record.setOrgReportPeriod((Long)dy.getDynamicObject("orgreportperiod").getPkValue());
        record.setCancelPeriod((Long)dy.getDynamicObject("cancelperiod").getPkValue());
        record.setSumPlanRecordId((Long)dy.getDynamicObject("sumplanrecordid").getPkValue());
        record.setCancelRuleEntryId(dy.getLong("cancelruleentryid"));
        record.setCancelRuleEntryName(dy.getString("cancelruleentryname"));
        record.setCurrencyMap(dy.getString("currencymap"));
        record.setExchangeRateTableId((Long)dy.getDynamicObject("exratetable").getPkValue());
        record.setRateDate(dy.getDate("exratedate"));
        record.setAmountUnit(AmountUnit.getByNumber(dy.getString("amountunit")));
        record.setRemark(dy.getString("remark"));
        record.setCreator((Long)dy.getDynamicObject("creator").getPkValue());
        record.setModifier((Long)dy.getDynamicObject("modifier").getPkValue());
        record.setCreateTime(dy.getDate("createtime"));
        record.setModifyTime(dy.getDate("modifytime"));
        record.setOutflowSubject(this.convertMultiBD(dy.getDynamicObjectCollection("outflowsubject")));
        record.setInflowSubject(this.convertMultiBD(dy.getDynamicObjectCollection("inflowsubject")));
        record.setCancelRuleName(dy.getString("cancelrulename"));
        record.setCurrencyId(this.convertField(dy, "currencyid"));
        record.setCurrency(this.convertField(dy, "currency"));
        record.setDiffProcessModeType(ITypeEnum.getByNumber(dy.getString("diffprocessmodetype"), DiffProcessModeType.class));
        record.setBillNo(dy.getString("billno"));
        record.setBillStatus(dy.getString("billstatus"));
        record.setOtherOptionalDimList(this.convertMultiBD(dy.getDynamicObjectCollection("applyoptionaldim")));
        record.setOtherOptionalDim1List(this.convertMultiBD(dy.getDynamicObjectCollection("applyoptionaldim1")));
        record.setOtherOptionalDim2List(this.convertMultiBD(dy.getDynamicObjectCollection("applyoptionaldim2")));
        DynamicObjectCollection dynamicObjectCollectionTotal = dy.getDynamicObjectCollection("totalentry");
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjectCollectionTotal)) {
            ArrayList<InnerCancleTotal> innerCancleTotals = new ArrayList<InnerCancleTotal>(dynamicObjectCollectionTotal.size());
            for (DynamicObject dynamicObject : dynamicObjectCollectionTotal) {
                InnerCancleTotal innerCancleTotal = new InnerCancleTotal();
                innerCancleTotal.setOffsetBatchNumber(dynamicObject.getString("entry_offset_batch_number"));
                innerCancleTotal.setOffsetNumber(dynamicObject.getInt("entry_offset_detail_num"));
                innerCancleTotal.setSumCancelAmount(dynamicObject.getBigDecimal("entry_offset_amt_sum"));
                DiffDirectionEnum direction = Optional.ofNullable(dynamicObject.getString("entry_diff_direction")).map(o -> DiffDirectionEnum.getDirection((String)o)).orElseGet(() -> null);
                innerCancleTotal.setDiffDirection(direction);
                innerCancleTotal.setSumDiffAmount(dynamicObject.getBigDecimal("entry_diff_amt_sum"));
                innerCancleTotals.add(innerCancleTotal);
            }
            record.setInnerCancleTotals(innerCancleTotals);
        }
        if (CollectionUtils.isNotEmpty((Collection)(dynamicObjectCollection = dy.getDynamicObjectCollection("entryentity")))) {
            ArrayList<InnerCancelDetail> cancelDetailList = new ArrayList<InnerCancelDetail>(dynamicObjectCollection.size());
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                InnerCancelDetail detail = new InnerCancelDetail();
                detail.setOrgId((Long)dynamicObject.getDynamicObject("cancelorgid").getPkValue());
                detail.setSubjectId((Long)dynamicObject.getDynamicObject("subjectid").getPkValue());
                detail.setCompanyId(this.convertField(dynamicObject, "entrycompanyid"));
                detail.setSettleTypeId(this.convertField(dynamicObject, "entrysettletypeid"));
                detail.setOtherDimId(this.convertField(dynamicObject, "entryotherdimid"));
                detail.setReportId((Long)dynamicObject.get("reportid"));
                detail.setReportDataId((Long)dynamicObject.get("reportdataid"));
                detail.setCancelAmt(dynamicObject.getBigDecimal("cancelamt"));
                detail.setReportNumber(dynamicObject.getString("reportnumber"));
                detail.setBalanceAmt(dynamicObject.getBigDecimal("balanceamt"));
                detail.setAvCancelAmt(dynamicObject.getBigDecimal("avcancelamt"));
                detail.setOffsetBatchNumber(dynamicObject.getString("offsetbatchnumber"));
                Long oursideOrgId = Optional.ofNullable(dynamicObject.getDynamicObject("oursideorg")).map(o -> Long.valueOf(o.getPkValue().toString())).orElseGet(() -> 0L);
                detail.setOurSideOrg(oursideOrgId);
                String correspondenceOrgName = Objects.nonNull(dynamicObject.getLocaleString("correspondenceorgname")) ? dynamicObject.getLocaleString("correspondenceorgname").getLocaleValue() : null;
                detail.setCorrespondenceOrgName(correspondenceOrgName);
                cancelDetailList.add(detail);
            }
            record.setCancelDetailList(cancelDetailList);
        }
        return record;
    }

    private List<Long> convertMultiBD(DynamicObjectCollection dynamicObjectCollection) {
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return Collections.emptyList();
        }
        return dynamicObjectCollection.stream().map(item -> item.getDynamicObject("fbasedataid")).map(item -> (Long)item.getPkValue()).collect(Collectors.toList());
    }

    private Long convertField(DynamicObject dynamicObject, String prop) {
        DynamicObject dO = dynamicObject.getDynamicObject(prop);
        if (dO == null) {
            return null;
        }
        return (Long)dO.getPkValue();
    }
}

