/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.model.report.ListPlanChangeReport;
import kd.tmc.fpm.business.domain.model.report.PlanChangeRecord;
import kd.tmc.fpm.business.domain.model.report.PlanChangeReport;
import kd.tmc.fpm.business.mvc.converter.control.IConverter;
import kd.tmc.fpm.business.mvc.converter.utils.ConverterUtils;
import kd.tmc.fpm.business.utils.FpmDataServiceHelper;

public class PlanChangeRecordDynamicConverter
implements IConverter<DynamicObject, PlanChangeRecord> {
    @Override
    public DynamicObject convert(PlanChangeRecord planChangeRecord) {
        List<PlanChangeReport> changeReportList = planChangeRecord.getChangeReportList();
        ListPlanChangeReport listPlanChangeReport = ListPlanChangeReport.builder().reportList(changeReportList).adjustAmtInfoList(planChangeRecord.getAdjustAmtInfoList()).recordId(planChangeRecord.getId()).build();
        DynamicObject dynamicObject = ConverterUtils.convert(DynamicObject.class, listPlanChangeReport);
        this.fillHead(dynamicObject, planChangeRecord);
        return dynamicObject;
    }

    private void fillHead(DynamicObject dynamicObject, PlanChangeRecord planChangeRecord) {
        dynamicObject.set("billno", (Object)planChangeRecord.getNumber());
        dynamicObject.set("bodysys", (Object)FpmDataServiceHelper.newDynamicObject("fpm_bodysysmanage", planChangeRecord.getSystemId()));
        dynamicObject.set("reportorg", (Object)FpmDataServiceHelper.newDynamicObject("fpm_member", planChangeRecord.getReportOrg()));
        dynamicObject.set("reportperiod", (Object)FpmDataServiceHelper.newDynamicObject("fpm_member", planChangeRecord.getReportPeriod()));
        dynamicObject.set("reporttype", (Object)FpmDataServiceHelper.newDynamicObject("fpm_orgreporttype", planChangeRecord.getReportType()));
        dynamicObject.set("adjusttype", (Object)planChangeRecord.getAdjustType().getNumber());
        dynamicObject.set("applydate", (Object)planChangeRecord.getApplyDate());
        dynamicObject.set("creator", this.getVoucherMan(planChangeRecord));
        dynamicObject.set("billstatus", (Object)(EmptyUtil.isEmpty((Object)planChangeRecord.getStatus()) ? BillStatus.STAGE.getNumber() : planChangeRecord.getStatus().getNumber()));
        dynamicObject.set("originalreportids", (Object)planChangeRecord.getOriginalReportIdList().stream().map(String::valueOf).collect(Collectors.joining(",")));
        dynamicObject.set("adjustreason", (Object)planChangeRecord.getAdjustReason());
        dynamicObject.set("mainreportid", (Object)planChangeRecord.getMainReportId());
        dynamicObject.set("pagedimensiontype1", (Object)planChangeRecord.getPageDimensionType1());
        dynamicObject.set("pagedimensiontype2", (Object)planChangeRecord.getPageDimensionType2());
        dynamicObject.set("amountunit", (Object)planChangeRecord.getAmountUnit().getNumber());
        dynamicObject.set("adjustrollperiod", (Object)planChangeRecord.getAdjustRollPeriod());
    }

    private Object getVoucherMan(PlanChangeRecord planChangeRecord) {
        BillStatus status = planChangeRecord.getStatus();
        if (Objects.nonNull(status) && status != BillStatus.STAGE) {
            return planChangeRecord.getCreatorId();
        }
        return EmptyUtil.isEmpty((String)planChangeRecord.getCreatorId()) ? Long.valueOf(RequestContext.get().getCurrUserId()) : planChangeRecord.getCreatorId();
    }
}

