/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.constant.ExecutePlanConstant;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryObject;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryService;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteStatus;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.BizProps;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.control.RecordWithoutHoldingInfo;
import kd.tmc.fpm.business.domain.model.control.WaitConsumeInfo;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.utils.DimensionMappingHelper;
import kd.tmc.fpm.business.utils.FpmDataServiceHelper;

public class PlanExecuteRecordConverter {
    private static Log logger = LogFactory.getLog(PlanExecuteRecordConverter.class);

    public static PlanExecuteRecord converterToExecuteRecord(DynamicObject dynamicObject) {
        String matchedIds = dynamicObject.getString("matchedreportdataids");
        List<Object> convert = new ArrayList(0);
        if (StringUtils.isNotEmpty((CharSequence)matchedIds)) {
            String[] split = matchedIds.split(",");
            List<Long> reportIdS = Arrays.stream(split).map(Long::valueOf).collect(Collectors.toList());
            ReportDataQueryService reportDataQueryService = new ReportDataQueryService();
            ReportDataQueryObject queryObject = new ReportDataQueryObject();
            queryObject.setIdList(reportIdS);
            queryObject.setNeedDimIfValueIsNotEmpty(true);
            List<ReportDataQueryResult> resultList = reportDataQueryService.queryReportData(queryObject);
            convert = ReportHelper.convert(resultList);
        }
        Map reportDataMap = null;
        if (!CollectionUtils.isEmpty(convert)) {
            reportDataMap = convert.stream().collect(Collectors.toMap(ReportData::getId, Function.identity(), (k1, k2) -> k1));
        }
        return PlanExecuteRecordConverter.converterToExecuteRecord(dynamicObject, reportDataMap);
    }

    public static PlanExecuteRecord converterToExecuteRecord(DynamicObject dynamicObject, Map<Long, ReportData> reportDataMap) {
        String matchedDetailFields;
        PlanExecuteRecord record = new PlanExecuteRecord();
        record.setId(dynamicObject.getLong("id"));
        record.setRelateRecordId(dynamicObject.getLong("relaterecordid"));
        record.setOriginalRecordId(dynamicObject.getLong("originalrecordid"));
        record.setRecordNumber(dynamicObject.getString("billno"));
        record.setAccurateMatch(dynamicObject.getBoolean("accuratematch"));
        String matchedDimensions = dynamicObject.getString("matcheddimensions");
        if (StringUtils.isNotBlank((CharSequence)matchedDimensions)) {
            record.setFloatMatchedDimIdS(Arrays.stream(matchedDimensions.split(",")).filter(StringUtils::isNotEmpty).map(Long::parseLong).collect(Collectors.toList()));
        }
        if (StringUtils.isNotBlank((CharSequence)(matchedDetailFields = dynamicObject.getString("matchdetailfields")))) {
            record.setDetailMatchedDimIdS(Arrays.stream(matchedDetailFields.split(",")).filter(StringUtils::isNotEmpty).map(Long::parseLong).collect(Collectors.toList()));
        }
        record.setSystemId(dynamicObject.getLong(String.join((CharSequence)".", "bodysys", "id")));
        record.setExecuteStatus(PlanExecuteStatus.getByNumber(dynamicObject.getString("executeoperatorstatus")));
        record.setOriginalExecuteStatus(record.getExecuteStatus());
        record.setExecuteDate(dynamicObject.getDate("executedate"));
        record.setBizBillAmount(dynamicObject.getBigDecimal("bizbillamount"));
        record.setVersion(dynamicObject.getString("version"));
        record.setReportOrgId(dynamicObject.getLong(String.join((CharSequence)".", "reportorg", "id")));
        record.setSubjectId(dynamicObject.getLong(String.join((CharSequence)".", "subjectmem", "id")));
        record.setMatchRuleId(dynamicObject.getLong(String.join((CharSequence)".", "billmatchrule", "id")));
        record.setRateDate(dynamicObject.getDate("ratedate"));
        record.setRate(dynamicObject.getBigDecimal("rate"));
        record.setActAmount(dynamicObject.getBigDecimal("realamt"));
        record.setExecuteOpType(PlanExecuteOpType.get(dynamicObject.getString("planexecuteop")));
        record.setBizOpName(dynamicObject.getString("executeinfo"));
        record.setDeleteStatus(dynamicObject.getBoolean("deleteflag"));
        record.setOriginalDeleteStatus(record.getDeleteStatus());
        DynamicObject reportTypeObj = dynamicObject.getDynamicObject("reporttype");
        record.setReportTypeId(EmptyUtil.isEmpty((DynamicObject)reportTypeObj) ? Long.valueOf(0L) : (Long)reportTypeObj.getPkValue());
        record.setAclRemainAmt(dynamicObject.getBigDecimal("aclremainamt"));
        record.setCreateTime(dynamicObject.getDate("createtime"));
        DynamicObject bizCurrency = dynamicObject.getDynamicObject("bizbillcurrency");
        if (Objects.nonNull(bizCurrency)) {
            record.setBizCurrencyId(bizCurrency.getLong("id"));
        }
        String matchedIds = dynamicObject.getString("matchedreportdataids");
        Long reportDataId = dynamicObject.getLong("reportdataid");
        if (StringUtils.isNotEmpty((CharSequence)matchedIds) && reportDataMap != null) {
            String[] split = matchedIds.split(",");
            List reportIdS = Arrays.stream(split).map(item -> Long.valueOf(item)).collect(Collectors.toList());
            ArrayList<ReportData> result = new ArrayList<ReportData>(reportIdS.size());
            for (Long reportId : reportIdS) {
                ReportData reportData = reportDataMap.get(reportId);
                if (reportData == null) {
                    logger.warn("ID\u4e3a {} \u7684\u6267\u884c\u8bb0\u5f55\uff0c\u5339\u914d\u5230\u7684\u62a5\u8868\u6570\u636e {}\uff0c\u5df2\u4e0d\u5b58\u5728\uff01", (Object)dynamicObject.getLong("id"), (Object)reportId);
                    continue;
                }
                if (reportData.getId().equals(reportDataId)) {
                    record.setReportData(reportData);
                }
                result.add(reportData);
            }
            record.setMatchedReportDataList(result);
        }
        BillBizInfo billBizInfo = new BillBizInfo();
        billBizInfo.setBillId(dynamicObject.getLong("bizbillid"));
        billBizInfo.setEntityType(dynamicObject.getDynamicObject("billbizetype").getPkValue().toString());
        billBizInfo.setBillNo(dynamicObject.getString("bizbillcode"));
        Object entryIdObj = dynamicObject.get("entryid");
        if (null != entryIdObj && StringUtils.isNotEmpty((CharSequence)entryIdObj.toString())) {
            billBizInfo.setEntryId(Long.valueOf(entryIdObj.toString()));
        }
        DynamicObjectCollection bizInfoColl = dynamicObject.getDynamicObjectCollection("bizinfoentry");
        ArrayList<BizProps> bizPropsList = new ArrayList<BizProps>(bizInfoColl.size());
        for (DynamicObject bizInfoObj : bizInfoColl) {
            BizProps bizProps = new BizProps();
            bizProps.setBizProp(bizInfoObj.getString("bizprop"));
            bizProps.setValue(bizInfoObj.getString("bizvalue"));
            bizPropsList.add(bizProps);
        }
        billBizInfo.setBizProps(bizPropsList);
        record.setBillBizInfo(billBizInfo);
        PlanExecuteRecordConverter.fillControlInfo(record, dynamicObject);
        return record;
    }

    private static void fillControlInfo(PlanExecuteRecord record, DynamicObject dynamicObject) {
        record.setDbRouteKey(dynamicObject.getString("dbroutekey"));
        record.setControlTraceId(dynamicObject.getLong("controltraceid"));
        record.setRequestId(dynamicObject.getLong("requestid"));
        record.setReleasedAmt(dynamicObject.getBigDecimal("releasedamt"));
        DynamicObjectCollection holdEntryEntity = dynamicObject.getDynamicObjectCollection("hold_entryentity");
        ArrayList<RecordWithoutHoldingInfo> recordWithoutHoldingInfoList = new ArrayList<RecordWithoutHoldingInfo>(holdEntryEntity.size());
        for (DynamicObject holdDy : holdEntryEntity) {
            RecordWithoutHoldingInfo holdingInfo = new RecordWithoutHoldingInfo();
            holdingInfo.setId(holdDy.getLong("id"));
            holdingInfo.setReportDataId(holdDy.getLong("hold_reportdataid"));
            holdingInfo.setHoldLockAmt(holdDy.getBigDecimal("hold_holdlockamt"));
            holdingInfo.setHoldActAmt(holdDy.getBigDecimal("hold_holdactamt"));
            recordWithoutHoldingInfoList.add(holdingInfo);
        }
        record.setRecordWithoutHoldingInfoList(recordWithoutHoldingInfoList);
        DynamicObjectCollection waitEntryEntity = dynamicObject.getDynamicObjectCollection("wait_entryentity");
        ArrayList<WaitConsumeInfo> waitConsumeInfoList = new ArrayList<WaitConsumeInfo>(waitEntryEntity.size());
        for (DynamicObject waitDy : waitEntryEntity) {
            WaitConsumeInfo waitConsumeInfo = new WaitConsumeInfo();
            waitConsumeInfo.setId(waitDy.getLong("id"));
            waitConsumeInfo.setWaitConsumeRecordId(waitDy.getLong("wait_recordid"));
            waitConsumeInfoList.add(waitConsumeInfo);
        }
        record.setWaitConsumeInfoList(waitConsumeInfoList);
    }

    public static List<PlanExecuteRecord> converterToExecuteRecord(List<DynamicObject> dynamicObjectList) {
        ArrayList<PlanExecuteRecord> result = new ArrayList<PlanExecuteRecord>(dynamicObjectList.size());
        List<Long> reportIdS = dynamicObjectList.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getString("matchedreportdataids"))).map(item -> {
            String matchedIds = item.getString("matchedreportdataids");
            String[] split = matchedIds.split(",");
            return Arrays.stream(split).map(ii -> Long.valueOf(ii)).collect(Collectors.toList());
        }).flatMap(Collection::stream).collect(Collectors.toList());
        Map reportDataMap = null;
        if (!CollectionUtils.isEmpty(reportIdS)) {
            ReportDataQueryService reportDataQueryService = new ReportDataQueryService();
            ReportDataQueryObject queryObject = new ReportDataQueryObject();
            queryObject.setIdList(reportIdS);
            queryObject.setNeedDimIfValueIsNotEmpty(true);
            List<ReportDataQueryResult> resultList = reportDataQueryService.queryReportData(queryObject);
            List<ReportData> convert = ReportHelper.convert(resultList);
            if (!CollectionUtils.isEmpty(convert)) {
                reportDataMap = convert.stream().collect(Collectors.toMap(ReportData::getId, Function.identity(), (k1, k2) -> k1));
            }
        }
        for (DynamicObject dynamicObject : dynamicObjectList) {
            result.add(PlanExecuteRecordConverter.converterToExecuteRecord(dynamicObject, reportDataMap));
        }
        return result;
    }

    public static List<DynamicObject> converterToDO(List<PlanExecuteRecord> executeRecordList) {
        Object load;
        Object ruleIdList;
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(executeRecordList.size());
        List idList = executeRecordList.stream().map(PlanExecuteRecord::getId).collect(Collectors.toList());
        DynamicObject[] dbArr = TmcDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_executeplan"));
        Map dbDataMap = Arrays.stream(dbArr).collect(Collectors.toMap(item -> item.getLong("id"), Function.identity()));
        Set ruleIdS = executeRecordList.stream().map(PlanExecuteRecord::getMatchRuleId).collect(Collectors.toSet());
        DynamicObject[] ruleArr = TmcDataServiceHelper.load((Object[])ruleIdS.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_matchrule"));
        HashMap<Long, Map<String, String>> dimAndFiledMMap = new HashMap<Long, Map<String, String>>(16);
        for (DynamicObject matchRule : ruleArr) {
            DynamicObjectCollection mappingEntry = matchRule.getDynamicObjectCollection("entryentity");
            Map<String, List<DynamicObject>> dimTypeMap = mappingEntry.stream().collect(Collectors.groupingBy(item -> item.getString("entry_dimensiontype")));
            Iterator<Map.Entry<String, List<DynamicObject>>> iterator = dimTypeMap.entrySet().iterator();
            HashMap dimInfoMap = new HashMap(16);
            while (iterator.hasNext()) {
                Map.Entry<String, List<DynamicObject>> next = iterator.next();
                String key = next.getKey();
                ruleIdList = next.getValue().stream().map(item -> item.getLong("entry_dimensiondetail.id")).collect(Collectors.toList());
                load = TmcDataServiceHelper.load((Object[])ruleIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)key));
                Map dataMap = Arrays.stream(load).collect(Collectors.toMap(item -> item.getLong("id"), Function.identity()));
                dimInfoMap.put(key, dataMap);
            }
            Map<String, String> dimAndFiledMap = mappingEntry.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getString("entry_businessbillfield"))).collect(Collectors.toMap(item -> item.getString("entry_businessbillfield"), item -> {
                String dimType = item.getString("entry_dimensiontype");
                Map dimObjColl = (Map)dimInfoMap.get(dimType);
                DynamicObject dimObj = (DynamicObject)dimObjColl.get(item.getLong(String.join((CharSequence)".", "entry_dimensiondetail", "id")));
                if (dimType.equals("fpm_dimension")) {
                    return dimObj.getString("basedata");
                }
                return dimObj.getString("detaildimtype");
            }));
            dimAndFiledMMap.put(Long.valueOf(matchRule.getPkValue().toString()), dimAndFiledMap);
        }
        HashMap<String, Long> currencyMap = new HashMap<String, Long>();
        HashMap<Long, Long> currencyAndSMap = new HashMap<Long, Long>();
        HashMap<Long, Integer> numberUsMap = new HashMap<Long, Integer>();
        for (PlanExecuteRecord planExecuteRecord : executeRecordList) {
            Long matchRuleId = planExecuteRecord.getMatchRuleId();
            Map dimAndFiledMap = (Map)dimAndFiledMMap.get(matchRuleId);
            if (planExecuteRecord.getId() != null && dbDataMap.get(planExecuteRecord.getId()) != null) {
                result.add(PlanExecuteRecordConverter.converterToDO(planExecuteRecord, (DynamicObject)dbDataMap.get(planExecuteRecord.getId()), dimAndFiledMap, currencyMap, currencyAndSMap));
                continue;
            }
            long currUs = System.nanoTime() / 1000L;
            Integer currUsCount = 0;
            if (numberUsMap.containsKey(currUs)) {
                currUsCount = (Integer)numberUsMap.get(currUs);
            }
            ruleIdList = currUsCount;
            currUsCount = currUsCount + 1;
            load = currUsCount;
            numberUsMap.put(currUs, currUsCount);
            String lsNumber = String.format("%04d", currUsCount);
            String number = String.format("PE-%s-%s", currUs, lsNumber);
            RequestContext requestContext = RequestContext.get();
            String userId = requestContext.getUserId();
            DynamicObject dO = TmcDataServiceHelper.newDynamicObject((String)"fpm_executeplan");
            PlanExecuteRecordConverter.converterToDO(planExecuteRecord, dO, dimAndFiledMap, currencyMap, currencyAndSMap);
            dO.set("billno", (Object)number);
            dO.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            dO.set("creator", (Object)userId);
            dO.set("matcheddimensions", (Object)planExecuteRecord.getFloatMatchedDimIdS().stream().map(String::valueOf).collect(Collectors.joining(",")));
            dO.set("matchdetailfields", (Object)planExecuteRecord.getDetailMatchedDimIdS().stream().map(String::valueOf).collect(Collectors.joining(",")));
            result.add(dO);
            PlanExecuteRecordConverter.fillControlInfoOfDynamic(planExecuteRecord, dO);
        }
        return result;
    }

    private static void fillControlInfoOfDynamic(PlanExecuteRecord planExecuteRecord, DynamicObject dO) {
        List<WaitConsumeInfo> waitConsumeInfoList;
        dO.set("dbroutekey", (Object)planExecuteRecord.getDbRouteKey());
        dO.set("controltraceid", (Object)planExecuteRecord.getControlTraceId());
        dO.set("requestid", (Object)planExecuteRecord.getRequestId());
        dO.set("releasedamt", (Object)planExecuteRecord.getReleasedAmt());
        dO.set("aclremainamt", (Object)planExecuteRecord.getAclRemainAmt());
        DynamicObjectCollection dynamicObjectCollection = dO.getDynamicObjectCollection("hold_entryentity");
        dynamicObjectCollection.clear();
        List<RecordWithoutHoldingInfo> recordWithoutHoldingInfoList = planExecuteRecord.getRecordWithoutHoldingInfoList();
        if (EmptyUtil.isNoEmpty(recordWithoutHoldingInfoList)) {
            for (RecordWithoutHoldingInfo holdingInfo : recordWithoutHoldingInfoList) {
                DynamicObject holdDy = dynamicObjectCollection.addNew();
                holdDy.set("id", (Object)holdingInfo.getId());
                holdDy.set("hold_reportdataid", (Object)holdingInfo.getReportDataId());
                holdDy.set("hold_holdlockamt", (Object)holdingInfo.getHoldLockAmt());
                holdDy.set("hold_holdactamt", (Object)holdingInfo.getHoldActAmt());
            }
        }
        if (EmptyUtil.isEmpty(waitConsumeInfoList = planExecuteRecord.getWaitConsumeInfoList())) {
            return;
        }
        DynamicObjectCollection waitDc = dO.getDynamicObjectCollection("wait_entryentity");
        waitDc.clear();
        for (WaitConsumeInfo waitConsumeInfo : waitConsumeInfoList) {
            DynamicObject waitDy = waitDc.addNew();
            waitDy.set("id", (Object)waitConsumeInfo.getId());
            waitDy.set("wait_recordid", (Object)waitConsumeInfo.getWaitConsumeRecordId());
        }
    }

    private static DynamicObject converterToDO(PlanExecuteRecord executeRecord, DynamicObject dO, Map<String, String> dimAndFiledMap, Map<String, Long> currencyMap, Map<Long, Long> currencyAndSorMap) {
        Long reportCurrencyId;
        List<ReportData> matchedReportDataList;
        BillBizInfo billBizInfo = executeRecord.getBillBizInfo();
        String entityType = billBizInfo.getEntityType();
        dO.set("bodysys", (Object)FpmDataServiceHelper.newDynamicObject("fpm_bodysysmanage", executeRecord.getSystemId()));
        dO.set("reportorg", (Object)FpmDataServiceHelper.newDynamicObject("fpm_member", executeRecord.getReportOrgId()));
        dO.set("billmatchrule", (Object)FpmDataServiceHelper.newDynamicObject("fpm_matchrule", executeRecord.getMatchRuleId()));
        dO.set("accuratematch", (Object)executeRecord.isAccurateMatch());
        if (executeRecord.getExecuteOpType() != null) {
            dO.set("planexecuteop", (Object)executeRecord.getExecuteOpType().getValue());
        }
        if (EmptyUtil.isNoEmpty((Long)executeRecord.getId())) {
            dO.set("id", (Object)executeRecord.getId());
        }
        dO.set("executeoperatorstatus", (Object)executeRecord.getExecuteStatus().getValue());
        dO.set("executedate", (Object)executeRecord.getExecuteDate());
        dO.set("version", (Object)executeRecord.getVersion());
        dO.set("relaterecordid", (Object)executeRecord.getRelateRecordId());
        dO.set("originalrecordid", (Object)executeRecord.getOriginalRecordId());
        dO.set("bizbillid", (Object)billBizInfo.getBillId());
        dO.set("billbizetype", (Object)entityType);
        if (executeRecord.getErrReason() != null && executeRecord.getErrReason().length() > 500) {
            dO.set("exectuefailreason", (Object)executeRecord.getErrReason().substring(0, 499));
        } else {
            dO.set("exectuefailreason", (Object)executeRecord.getErrReason());
        }
        ReportData reportData = executeRecord.getReportData();
        if (reportData != null) {
            TemplateDim templateDim;
            List<TemplateDim> dimList = reportData.getDimList();
            List<Object> dimValList = reportData.getDimValList();
            Map<TemplateDim, Object> detailMatchInfo = executeRecord.getDetailMatchInfo();
            logger.info(String.format("\u5339\u914d\u5230\u7684\u660e\u7ec6\u7ef4\u5ea6\uff0c%s", JSON.toJSONString(detailMatchInfo)));
            if (detailMatchInfo != null) {
                for (Map.Entry<TemplateDim, Object> next : detailMatchInfo.entrySet()) {
                    templateDim = next.getKey();
                    if (templateDim.getDimType() != DimensionType.DETAILDIM) continue;
                    Optional<TemplateDim> first = dimList.stream().filter(item -> item.getDimType() == templateDim.getDimType() && (item.getDetailDimType() == null && templateDim.getDetailDimType() == null || item.getDetailDimType() != null && templateDim.getDetailDimType() != null && item.getDetailDimType() == templateDim.getDetailDimType())).findFirst();
                    if (first.isPresent()) {
                        TemplateDim currDim = first.get();
                        dimValList.remove(dimList.indexOf(currDim));
                        dimList.remove(currDim);
                    }
                    dimList.add(next.getKey());
                    dimValList.add(next.getValue());
                }
            }
            Map<String, String> executePlanMappingWithoutEntry = DimensionMappingHelper.getExecutePlanMappingWithoutEntry(executeRecord.getSystemId());
            logger.info(String.format("\u5339\u914d\u89c4\u5219\u91cc\u9762\u7684\u6240\u6709\u5b57\u6bb5\u4fe1\u606f\uff0c%s", JSON.toJSONString(dimAndFiledMap.values())));
            for (int i = 0; i < dimList.size(); ++i) {
                templateDim = dimList.get(i);
                Object value = dimValList.get(i);
                DimensionType dimType = templateDim.getDimType();
                Collection<String> values = dimAndFiledMap.values();
                if (dimType == DimensionType.DETAILDIM) {
                    DetailDimType detailDimType = templateDim.getDetailDimType();
                    String propKey = (String)executePlanMappingWithoutEntry.get(detailDimType.getNumber());
                    logger.info(String.format("\u5f53\u524d\u660e\u7ec6\u5b57\u6bb5\u7c7b\u578b\uff0c\u3010%s\u3011\uff0c\u3010%s\u3011", JSON.toJSONString((Object)((Object)detailDimType)), values.contains(detailDimType.name())));
                    if (!values.contains(detailDimType.name())) continue;
                    dO.set(propKey, value);
                    continue;
                }
                if (dimType == DimensionType.CUSTOM) {
                    DynamicObject dynamicObject = dO.getDynamicObject("custommem1");
                    DynamicObject extmemTwo = dO.getDynamicObject("custommem2");
                    DynamicObject extmemThree = dO.getDynamicObject("custommem3");
                    HashSet<Object> hashSet = new HashSet<Object>();
                    if (Objects.nonNull(dynamicObject)) {
                        hashSet.add(dynamicObject.getPkValue());
                    }
                    if (Objects.nonNull(extmemTwo)) {
                        hashSet.add(extmemTwo.getPkValue());
                    }
                    if (Objects.nonNull(extmemThree)) {
                        hashSet.add(extmemThree.getPkValue());
                    }
                    if (hashSet.contains(value)) continue;
                    DynamicObject dynamicObject2 = FpmDataServiceHelper.newDynamicObject("fpm_member", value);
                    if (Objects.isNull(dynamicObject)) {
                        dO.set("custommem1", (Object)dynamicObject2);
                        continue;
                    }
                    if (Objects.isNull(extmemTwo)) {
                        dO.set("custommem2", (Object)dynamicObject2);
                        continue;
                    }
                    if (!Objects.isNull(extmemThree)) continue;
                    dO.set("custommem3", (Object)dynamicObject2);
                    continue;
                }
                String string = ExecutePlanConstant.MAINDIM_ENTRY_MAPPING_MAP.get(dimType.getNumber());
                if (StringUtils.isEmpty((CharSequence)string)) {
                    logger.info("PlanExecuteRecordConverter \u7ef4\u5ea6\u8f6c\u6362\u5f02\u5e38\uff0c\u5f02\u5e38dimtype:{}", (Object)dimType.getNumber());
                    continue;
                }
                dO.set(string, value);
            }
            dO.set("reportdataid", (Object)reportData.getId());
            dO.set("reportperiod", (Object)reportData.getReportPeriodId());
        }
        DynamicObjectCollection billBIzInfoColl = dO.getDynamicObjectCollection("bizinfoentry");
        billBIzInfoColl.clear();
        String entryKey = "";
        List<BizProps> bizProps = billBizInfo.getBizProps();
        for (BizProps bizProp : bizProps) {
            String[] propNameArr;
            if (bizProp == null) continue;
            DynamicObject bizPropInfo = billBIzInfoColl.addNew();
            String bizPropName = bizProp.getBizProp();
            bizPropInfo.set("bizprop", (Object)bizPropName);
            bizPropInfo.set("bizvalue", bizProp.getValue());
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityType);
            for (String propName : propNameArr = bizPropName.split("\\.")) {
                DynamicProperty property = dataEntityType.getProperty(propName);
                if (!(property instanceof EntryProp)) continue;
                entryKey = propName;
            }
            String string = dimAndFiledMap.get(bizPropName);
            if (string == null) continue;
            if (string.equalsIgnoreCase(DimensionType.ORG.getNumber())) {
                dO.set("bizorg", bizProp.getValue());
                continue;
            }
            if (string.equalsIgnoreCase(DimensionType.CURRENCY.getNumber())) {
                dO.set("bizbillcurrencytext", bizProp.getValue());
                continue;
            }
            if (!string.equalsIgnoreCase(DetailDimType.PLAN_AMOUNT.getNumber())) continue;
            dO.set("bizbillamount", bizProp.getValue());
        }
        if (reportData != null) {
            dO.set("realamt", (Object)executeRecord.getActAmount());
        }
        dO.set("rate", (Object)executeRecord.getRate());
        dO.set("ratedate", (Object)executeRecord.getRateDate());
        dO.set("entryid", (Object)billBizInfo.getEntryId());
        dO.set("entrytypenumber", (Object)entryKey);
        dO.set("deleteflag", (Object)executeRecord.getDeleteStatus());
        dO.set("executeinfo", (Object)executeRecord.getBizOpName());
        dO.set("bizbillcode", (Object)billBizInfo.getBillNo());
        if (EmptyUtil.isNoEmpty((Long)executeRecord.getReportTypeId())) {
            dO.set("reporttype", (Object)FpmDataServiceHelper.newDynamicObject("fpm_orgreporttype", executeRecord.getReportTypeId()));
        }
        if (EmptyUtil.isNoEmpty((Long)executeRecord.getBizCurrencyId())) {
            dO.set("bizbillcurrency", (Object)FpmDataServiceHelper.newDynamicObject("bd_currency", executeRecord.getBizCurrencyId()));
        }
        if (!CollectionUtils.isEmpty(matchedReportDataList = executeRecord.getMatchedReportDataList())) {
            List collect = matchedReportDataList.stream().map(item -> item.getId().toString()).distinct().collect(Collectors.toList());
            dO.set("matchedreportdataids", (Object)String.join((CharSequence)",", collect));
        }
        if ((reportCurrencyId = Long.valueOf(dO.getLong("currencymem"))) != null && !reportCurrencyId.equals(0L)) {
            long sourceId;
            DynamicObject reportCurrency;
            DynamicObject reportCurrencyObj;
            if (!currencyAndSorMap.containsKey(reportCurrencyId) && (reportCurrencyObj = TmcDataServiceHelper.loadSingleFromCache((Object)reportCurrencyId, (String)"fpm_member")) != null && (reportCurrency = TmcDataServiceHelper.loadSingleFromCache((Object)(sourceId = reportCurrencyObj.getLong("sourceid")), (String)"bd_currency")) != null) {
                currencyAndSorMap.put(reportCurrencyId, reportCurrency.getLong("id"));
            }
            dO.set("realamtbase", (Object)currencyAndSorMap.get(reportCurrencyId));
        }
        return dO;
    }
}

