/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.mvc.converter.control.IConverter;
import kd.tmc.fpm.business.mvc.converter.utils.ConverterUtils;
import kd.tmc.fpm.common.property.SummaryConfigSnapshotProp;
import kd.tmc.fpm.common.utils.GlobalIdUtil;
import kd.tmc.fpm.common.utils.MD5Utils;

public class SumPlanParamConfigDynamicConverter
implements IConverter<DynamicObject, SumPlanParamConfig> {
    private DynamicObject sumPlanParamConfigDy;
    private boolean isInsert;

    public SumPlanParamConfigDynamicConverter() {
    }

    public SumPlanParamConfigDynamicConverter(DynamicObject sumPlanParamConfigDy, Boolean isInsert) {
        this.sumPlanParamConfigDy = sumPlanParamConfigDy;
        this.isInsert = isInsert;
    }

    @Override
    public DynamicObject convert(SumPlanParamConfig sumPlanParamConfig) {
        long id = this.isInsert ? GlobalIdUtil.genGlobalLongId() : sumPlanParamConfig.getId();
        this.sumPlanParamConfigDy.set("id", (Object)id);
        this.sumPlanParamConfigDy.set("name", (Object)sumPlanParamConfig.getName());
        this.sumPlanParamConfigDy.set("number", (Object)sumPlanParamConfig.getNumber());
        this.sumPlanParamConfigDy.set("sumrepulsestatus", (Object)sumPlanParamConfig.getSumRepulseStatusType().getNumber());
        this.sumPlanParamConfigDy.set("bodysys", (Object)sumPlanParamConfig.getSystemId());
        this.sumPlanParamConfigDy.set("enable", (Object)(sumPlanParamConfig.isEnable() ? BaseEnableEnum.ENABLE.getValue() : BaseEnableEnum.DISABLE.getValue()));
        this.sumPlanParamConfigDy.set("allowsubmit", (Object)(sumPlanParamConfig.isAllowSubmit() ? "1" : "0"));
        DynamicObjectCollection sumReportTypeDyColl = this.sumPlanParamConfigDy.getDynamicObjectCollection("sumreporttype");
        sumPlanParamConfig.getReportPeriodTypeIdS().forEach(reportPeriodTypeId -> {
            DynamicObject reportPeriodTypeDy = sumReportTypeDyColl.addNew();
            reportPeriodTypeDy.set("fbasedataid", reportPeriodTypeId);
        });
        DynamicObjectCollection summaryMainParamDyColl = this.sumPlanParamConfigDy.getDynamicObjectCollection("treeentryentity");
        HashMap orgId2EntryRowMap = Maps.newHashMapWithExpectedSize((int)16);
        sumPlanParamConfig.getConfigInfoList().forEach(sumPlanParamConfigInfo -> {
            DynamicObject sumPlanParamConfigInfoDy = summaryMainParamDyColl.addNew();
            ConverterUtils.convertWithArgs(DynamicObject.class, sumPlanParamConfigInfo, sumPlanParamConfigInfoDy, true);
            orgId2EntryRowMap.put(sumPlanParamConfigInfo.getOrgMemberId(), sumPlanParamConfigInfoDy);
        });
        summaryMainParamDyColl.forEach(dy -> {
            Long parentOrgId = dy.getLong("sum_parentorg");
            DynamicObject parentEntryRowDy = (DynamicObject)orgId2EntryRowMap.get(parentOrgId);
            if (Objects.nonNull(parentEntryRowDy)) {
                dy.set("pid", parentEntryRowDy.getPkValue());
            }
        });
        boolean isSnapshot = Objects.equals("fpm_summaryconfig_snp", this.sumPlanParamConfigDy.getDataEntityType().getName());
        if (isSnapshot) {
            SimplePropertyPreFilter filter = new SimplePropertyPreFilter(new String[0]);
            filter.getIncludes().addAll(SummaryConfigSnapshotProp.CALCULATE_MD5_PROPS);
            SerializeFilter[] filters = new SerializeFilter[]{filter};
            String sumPlanParamConfigInfoJson = JSON.toJSONString(sumPlanParamConfig.getConfigInfoList(), (SerializeFilter[])filters, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            String MD5 = MD5Utils.getMD5Code((String)sumPlanParamConfigInfoJson);
            this.sumPlanParamConfigDy.set("treeentryentitymd5", (Object)MD5);
        }
        return this.sumPlanParamConfigDy;
    }
}

