/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.mvc.converter.control.IConverter;
import kd.tmc.fpm.business.utils.FpmDataServiceHelper;

public class SumPlanRecordDynamicConverter
implements IConverter<DynamicObject, SumPlanRecord> {
    @Override
    public DynamicObject convert(SumPlanRecord sumPlanRecord) {
        DynamicObject dynamicObject = this.getSumPlanRecord(sumPlanRecord.getId());
        dynamicObject.set("billno", (Object)sumPlanRecord.getNumber());
        Long systemId = sumPlanRecord.getSystemId();
        dynamicObject.set("bodysys", (Object)FpmDataServiceHelper.newDynamicObject("fpm_bodysysmanage", systemId));
        HashSet<Long> memberIdSet = new HashSet<Long>(4);
        Long reportOrg = sumPlanRecord.getReportOrg();
        Long reportPeriod = sumPlanRecord.getReportPeriod();
        memberIdSet.add(reportOrg);
        memberIdSet.add(reportPeriod);
        Map memberDyMap = TmcDataServiceHelper.loadFromCache((Object[])memberIdSet.toArray(), (String)"fpm_member");
        dynamicObject.set("reportorg", memberDyMap.get(reportOrg));
        dynamicObject.set("reportperiod", memberDyMap.get(reportPeriod));
        dynamicObject.set("name", (Object)sumPlanRecord.getName());
        dynamicObject.set("summarytype", (Object)sumPlanRecord.getSumPlanSumType().getNumber());
        if (EmptyUtil.isNoEmpty((Long)sumPlanRecord.getReportType())) {
            dynamicObject.set("reporttype", (Object)FpmDataServiceHelper.newDynamicObject("fpm_orgreporttype", sumPlanRecord.getReportType()));
        }
        dynamicObject.set("reportperiod", (Object)sumPlanRecord.getReportPeriodId());
        if (EmptyUtil.isNoEmpty(sumPlanRecord.getCurrencyIdList())) {
            Map currencies = TmcDataServiceHelper.loadFromCache((Object[])sumPlanRecord.getCurrencyIdList().toArray(), (String)"fpm_member");
            DynamicObjectCollection currencyRange = dynamicObject.getDynamicObjectCollection("currencyrange");
            currencyRange.clear();
            for (DynamicObject currency : currencies.values()) {
                currencyRange.addNew().set("fbasedataid", (Object)currency);
            }
            dynamicObject.set("currencyrange", (Object)currencyRange);
        }
        if (EmptyUtil.isNoEmpty(sumPlanRecord.getAttachtplIdList())) {
            Map attachTemplates = TmcDataServiceHelper.loadFromCache((Object[])sumPlanRecord.getAttachtplIdList().toArray(), (String)"fpm_template_bak");
            DynamicObjectCollection attachtpl = dynamicObject.getDynamicObjectCollection("attachtpl");
            attachtpl.clear();
            for (DynamicObject attachTemplate : attachTemplates.values()) {
                attachtpl.addNew().set("fbasedataid", (Object)attachTemplate);
            }
            dynamicObject.set("attachtpl", (Object)attachtpl);
        }
        if (EmptyUtil.isNoEmpty(sumPlanRecord.getPeriodMemberIdList())) {
            Map periods = TmcDataServiceHelper.loadFromCache((Object[])sumPlanRecord.getPeriodMemberIdList().toArray(), (String)"fpm_member");
            DynamicObjectCollection periodList = dynamicObject.getDynamicObjectCollection("periods");
            periodList.clear();
            for (DynamicObject period : periods.values()) {
                periodList.addNew().set("fbasedataid", (Object)period);
            }
            dynamicObject.set("periods", (Object)periodList);
        }
        dynamicObject.set("reportcount", (Object)sumPlanRecord.getReportCount());
        dynamicObject.set("creator", this.getVoucherMan(sumPlanRecord));
        dynamicObject.set("billstatus", (Object)(EmptyUtil.isEmpty((Object)sumPlanRecord.getStatus()) ? BillStatus.STAGE.getNumber() : sumPlanRecord.getStatus().getNumber()));
        if (EmptyUtil.isNoEmpty(sumPlanRecord.getOriginalReportIdList())) {
            dynamicObject.set("originalreportids", (Object)sumPlanRecord.getOriginalReportIdList().stream().map(String::valueOf).collect(Collectors.joining(",")));
        }
        dynamicObject.set("offsetornot", (Object)sumPlanRecord.isInnerCancel());
        dynamicObject.set("exratetable", (Object)sumPlanRecord.getExchangeRateTableId());
        dynamicObject.set("exchangeratedate", (Object)sumPlanRecord.getRateDate());
        dynamicObject.set("amountunit", (Object)sumPlanRecord.getAmountUnit().getNumber());
        dynamicObject.set("remark", (Object)sumPlanRecord.getRemark());
        dynamicObject.set("mainreportid", (Object)sumPlanRecord.getMainReportId());
        dynamicObject.set("amountunit", (Object)sumPlanRecord.getAmountUnit().getNumber());
        dynamicObject.set("planstatus", EmptyUtil.isEmpty((Object)((Object)sumPlanRecord.getReportStatus())) ? null : sumPlanRecord.getReportStatus().getVal());
        dynamicObject.set("declarestartdate", (Object)sumPlanRecord.getDeclareStartDate());
        dynamicObject.set("declaredeadline", (Object)sumPlanRecord.getDeclareEndDate());
        return dynamicObject;
    }

    private Object getVoucherMan(SumPlanRecord sumPlanRecord) {
        BillStatus status = sumPlanRecord.getStatus();
        if (Objects.nonNull(status) && status != BillStatus.STAGE) {
            return sumPlanRecord.getCreatorId();
        }
        return EmptyUtil.isEmpty((String)sumPlanRecord.getCreatorId()) ? Long.valueOf(RequestContext.get().getCurrUserId()) : sumPlanRecord.getCreatorId();
    }

    private DynamicObject getSumPlanRecord(Long id) {
        boolean exists = TmcDataServiceHelper.exists((Object)id, (String)"fpm_reportplansum");
        DynamicObject sumPlanReportDynamicObject = exists ? TmcDataServiceHelper.loadSingle((Object)id, (String)"fpm_reportplansum") : TmcDataServiceHelper.newDynamicObject((String)"fpm_reportplansum");
        return sumPlanReportDynamicObject;
    }
}

