/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DetailDataType;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.TemplateConsultSeatType;
import kd.tmc.fpm.business.domain.enums.TemplateDimMemScopeType;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.enums.TemplateReferencePosType;
import kd.tmc.fpm.business.domain.enums.TemplateSmartGetValSetType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateBaseInfo;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateLayout;
import kd.tmc.fpm.business.domain.model.template.TemplateReportType;
import kd.tmc.fpm.business.helper.DimLayoutHelper;
import kd.tmc.fpm.business.mvc.converter.MemberConverterFactory;
import kd.tmc.fpm.business.mvc.converter.TemplatePOConverter;
import kd.tmc.fpm.business.mvc.converter.member.MetricMemberConverter;
import kd.tmc.fpm.business.mvc.repository.impl.AuxiliaryFieldsRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimMemberRepository;
import kd.tmc.fpm.common.enums.DetailTemplateColDimTypeEnum;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.TemplateDimBDTypeEnum;
import kd.tmc.fpm.common.enums.TemplateTypeEnum;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import org.apache.commons.lang3.StringUtils;

public class TemplateVOConverter {
    public static ReportTemplate convertManageDataToTemplate(DynamicObject template) {
        ReportTemplate reportTemplate = new ReportTemplate();
        TemplateVOConverter.initBaseInfo(template, reportTemplate);
        TemplateLayout templateLayout = TemplateVOConverter.convertToDimLayoutModel(template);
        reportTemplate.setDimLayout(templateLayout);
        TemplateVOConverter.initTemplateDimConversion(template, reportTemplate);
        if (TemplateTypeEnum.FIXED.getValue().equals(template.getString("templatetype"))) {
            TemplateVOConverter.initSubjectSetting(template, reportTemplate);
        }
        TemplateVOConverter.initCurrencyMember(template, reportTemplate);
        return reportTemplate;
    }

    private static void handleSubjectFlowTotal(DynamicObject template) {
        DynamicObjectCollection entryEntity = template.getDynamicObjectCollection("colentry");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        boolean enableTotal = entryEntity.stream().anyMatch(item -> item.getBoolean("totalrow"));
        if (!enableTotal) {
            for (int i = 0; i < entryEntity.getRowCount(); ++i) {
                ((DynamicObject)entryEntity.get(i)).set("subjectflowtotal", (Object)false);
            }
            return;
        }
        DynamicObjectCollection collection = template.getDynamicObjectCollection("colentry");
        List subjectMemberObjs = collection.stream().filter(item -> Objects.nonNull(item.getDynamicObject("dimbd"))).filter(item -> "fpm_dimension".equals(item.getDynamicObject("dimbd").getDataEntityType().getName())).filter(item -> DimsionEnums.SUBJECT.getNumber().equals(item.getDynamicObject("dimbd").getString("basedata"))).map(item -> item.getDynamicObjectCollection("colmember")).flatMap(Collection::stream).collect(Collectors.toList());
        long subjectFlowCount = subjectMemberObjs.stream().map(item -> item.get("fbasedataid.flow")).distinct().count();
        long currencyCount = collection.stream().filter(item -> Objects.nonNull(item.getDynamicObject("dimbd"))).filter(item -> "fpm_dimension".equals(item.getDynamicObject("dimbd").getDataEntityType().getName())).filter(item -> DimsionEnums.CURRENCY.getNumber().equals(item.getDynamicObject("dimbd").getString("basedata"))).map(item -> item.getDynamicObjectCollection("colmember")).flatMap(Collection::stream).count();
        if (currencyCount * subjectFlowCount > 20L) {
            for (int i = 0; i < entryEntity.getRowCount(); ++i) {
                ((DynamicObject)entryEntity.get(i)).set("subjectflowtotal", (Object)false);
            }
            return;
        }
        for (int i = 0; i < entryEntity.getRowCount(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            if (!Objects.equals(entry.getString("dimbdtype"), TemplateDimBDTypeEnum.DIM.getValue())) {
                entry.set("subjectflowtotal", (Object)false);
                continue;
            }
            if (!Objects.equals(entry.getDynamicObject("dimbd").getString("number"), DimsionEnums.SUBJECT.getNumber())) {
                entry.set("subjectflowtotal", (Object)false);
                continue;
            }
            boolean subjectExpend = entry.getBoolean("expand");
            if (subjectExpend) {
                entry.set("subjectflowtotal", (Object)false);
                break;
            }
            entry.set("subjectflowtotal", (Object)true);
            break;
        }
    }

    private static void initBaseInfo(DynamicObject template, ReportTemplate reportTemplate) {
        TemplateBaseInfo templateBaseInfo = TemplateVOConverter.convertToBaseInfoModel(template);
        reportTemplate.fillBaseInfo(templateBaseInfo);
        reportTemplate.setId(template.getLong("id"));
        DynamicObjectCollection memberList = template.getDynamicObjectCollection("user");
        List<Long> userIdList = memberList.stream().map(o -> o.getDynamicObject("fbasedataid")).map(o -> o.getLong("id")).collect(Collectors.toList());
        reportTemplate.setUserIdList(userIdList);
        reportTemplate.setCreatorId(Long.parseLong(template.getDynamicObject("creator").getPkValue().toString()));
        reportTemplate.setRelease(template.getBoolean("releasestatus"));
    }

    private static void initTemplateDimConversion(DynamicObject template, ReportTemplate reportTemplate) {
        TemplateType templateType = TemplateType.getByNumber(template.getString("templatetype"));
        if (Objects.nonNull((Object)templateType) && templateType.isDetail()) {
            TemplateVOConverter.handleSubjectFlowTotal(template);
        }
        ArrayList<TemplateDim> pageDimLst = new ArrayList<TemplateDim>(3);
        DynamicObjectCollection pageDimEntryCol = template.getDynamicObjectCollection("pagedimentry");
        int row = 0;
        for (DynamicObject pageDimEntry : pageDimEntryCol) {
            TemplateDim templateDim = new TemplateDim();
            templateDim.setId(pageDimEntry.getLong("id"));
            templateDim.setDimensionId(pageDimEntry.getLong("pagedim.id"));
            templateDim.setIncludeSum(false);
            templateDim.setLocation(DimLocation.PAGE);
            templateDim.setVisible(true);
            templateDim.setExpand(false);
            DynamicObjectCollection memberIds = pageDimEntry.getDynamicObjectCollection("pagedimmember");
            List<Long> memberIdLst = memberIds.stream().map(o -> o.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(o -> o.getLong("id")).collect(Collectors.toList());
            templateDim.setMemberScope(memberIdLst);
            DynamicObject defaultDisplayMemberDO = (DynamicObject)pageDimEntry.get("defaultdisplaymember");
            if (defaultDisplayMemberDO != null) {
                templateDim.setDefaultDisplayMember((Long)defaultDisplayMemberDO.getPkValue());
            }
            templateDim.setLevel(0);
            templateDim.setSequence(row++);
            String pageDimStr = pageDimEntry.getString("pagedim.number");
            if (StringUtils.isEmpty((CharSequence)pageDimStr)) continue;
            templateDim.setDimType(DimensionType.getDimsionByNumber(pageDimStr));
            templateDim.setDimensionName(pageDimEntry.getString("pagedim.name"));
            pageDimLst.add(templateDim);
        }
        reportTemplate.setPageDimList(pageDimLst);
        TemplateType type = reportTemplate.getTemplateType();
        if (TemplateType.DETAIL.getNumber().equals(type.getNumber())) {
            DynamicObjectCollection colEntryColl = template.getDynamicObjectCollection("colentry");
            List detailDimIds = colEntryColl.stream().map(o -> o.getLong("dimid")).collect(Collectors.toList());
            Map detailDimMap = TmcDataServiceHelper.loadDataAndMapById((String)"fpm_detailplanfields", detailDimIds);
            ArrayList<TemplateDim> colDimList = new ArrayList<TemplateDim>(1);
            for (int i = 0; i < colEntryColl.size(); ++i) {
                DynamicObject colEntry = (DynamicObject)colEntryColl.get(i);
                TemplateDim templateDim = new TemplateDim();
                templateDim.setId(colEntry.getLong("id"));
                templateDim.setDimensionId(colEntry.getLong("dimid"));
                DynamicObject dynamicObject = colEntry.getDynamicObject("dimbd");
                if (EmptyUtil.isEmpty((DynamicObject)dynamicObject)) continue;
                templateDim.setDimensionName(dynamicObject.getString("name"));
                templateDim.setVisible(true);
                templateDim.setLocation(DimLocation.COL);
                templateDim.setLevel(1);
                if (DetailTemplateColDimTypeEnum.DETAIL.getValue().equals(colEntry.getString("coldimtype"))) {
                    templateDim.setDetailDim(true);
                    templateDim.setVisible(colEntry.getBoolean("colselect"));
                    templateDim.setDimType(DimensionType.DETAILDIM);
                    templateDim.setDetailDataType(ITypeEnum.getByNumber(((DynamicObject)detailDimMap.get(templateDim.getDimensionId())).getString("datatype"), DetailDataType.class));
                    templateDim.setDetailDimType(DetailDimType.getDimsionByNumber(((DynamicObject)detailDimMap.get(templateDim.getDimensionId())).getString("detaildimtype")));
                } else {
                    templateDim.setDimType(DimensionType.getDimsionByNumber(colEntry.getString("dimbd.number")));
                }
                if (colEntry.getBoolean("expand")) {
                    List<Long> memberList = colEntry.getDynamicObjectCollection("expandmemberids").stream().map(e -> e.getLong("fbasedataid.id")).collect(Collectors.toList());
                    templateDim.setExpand(true);
                    templateDim.setMemberScope(memberList);
                } else {
                    List<Long> scopeList = colEntry.getDynamicObjectCollection("colmember").stream().map(e -> e.getLong("fbasedataid.id")).collect(Collectors.toList());
                    templateDim.setMemberScope(scopeList);
                }
                templateDim.setSequence(i);
                templateDim.setTotalRow(colEntry.getBoolean("totalrow"));
                templateDim.setSubjectFlowTotal(colEntry.getBoolean("subjectflowtotal"));
                colDimList.add(templateDim);
            }
            reportTemplate.setColDimList(colDimList);
        } else if (TemplateType.FIXED.getNumber().equals(type.getNumber())) {
            Long lv3ColDim;
            ArrayList<TemplateDim> colDimLst = new ArrayList<TemplateDim>(4);
            DynamicObjectCollection colDimEntrys = template.getDynamicObjectCollection("colentryentity");
            DynamicObject colDimEntry = (DynamicObject)colDimEntrys.get(0);
            TemplateDim lv1ColDimTemplate = new TemplateDim();
            lv1ColDimTemplate.setId(colDimEntry.getLong("id"));
            lv1ColDimTemplate.setDimensionId(DimLayoutHelper.getDimessionId(DimLocation.COL, 1, template));
            lv1ColDimTemplate.setIncludeSum(false);
            lv1ColDimTemplate.setVisible(true);
            lv1ColDimTemplate.setLocation(DimLocation.COL);
            lv1ColDimTemplate.setExpand(false);
            DynamicObjectCollection lv1membersofcol = colDimEntry.getDynamicObjectCollection("lv1coldimmember");
            List lv1MemberIdLstOfCol = Optional.ofNullable(lv1membersofcol).map(members -> members.stream().map(o -> o.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(o -> o.getLong("id")).collect(Collectors.toList())).orElseGet(ArrayList::new);
            lv1ColDimTemplate.setMemberScope(lv1MemberIdLstOfCol);
            lv1ColDimTemplate.setLevel(1);
            lv1ColDimTemplate.setSequence(1);
            lv1ColDimTemplate.setDimType(DimensionType.getDimsionByNumber(DimLayoutHelper.getDimessionMemberType(DimLocation.COL, 1, template)));
            lv1ColDimTemplate.setDimensionName(DimLayoutHelper.getDimessionName(DimLocation.COL, 1, template));
            colDimLst.add(lv1ColDimTemplate);
            Long lv2ColDim = DimLayoutHelper.getDimessionId(DimLocation.COL, 2, template);
            if (null != lv2ColDim && 0 != lv2ColDim.compareTo(0L)) {
                TemplateDim lv2ColDimTemplate = new TemplateDim();
                lv2ColDimTemplate.setId(colDimEntry.getLong("id"));
                lv2ColDimTemplate.setDimensionId(lv2ColDim);
                lv2ColDimTemplate.setIncludeSum(colDimEntry.getBoolean("lv2colsubtotal"));
                lv2ColDimTemplate.setVisible(true);
                lv2ColDimTemplate.setExpand(false);
                lv2ColDimTemplate.setLocation(DimLocation.COL);
                DynamicObjectCollection lv2membersofcol = colDimEntry.getDynamicObjectCollection("lv2coldimmember");
                List lv2MemberIdLstOfCol = Optional.ofNullable(lv2membersofcol).map(members -> members.stream().map(o -> o.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(o -> o.getLong("id")).collect(Collectors.toList())).orElseGet(ArrayList::new);
                lv2ColDimTemplate.setMemberScope(lv2MemberIdLstOfCol);
                lv2ColDimTemplate.setLevel(2);
                lv2ColDimTemplate.setSequence(1);
                lv2ColDimTemplate.setDimType(DimensionType.getDimsionByNumber(DimLayoutHelper.getDimessionMemberType(DimLocation.COL, 2, template)));
                lv2ColDimTemplate.setDimensionName(DimLayoutHelper.getDimessionName(DimLocation.COL, 2, template));
                colDimLst.add(lv2ColDimTemplate);
            }
            if (EmptyUtil.isNoEmpty((Long)(lv3ColDim = DimLayoutHelper.getDimessionId(DimLocation.COL, 3, template)))) {
                TemplateDim lv3ColDimTemplate = new TemplateDim();
                lv3ColDimTemplate.setId(colDimEntry.getLong("id"));
                lv3ColDimTemplate.setDimensionId(lv3ColDim);
                lv3ColDimTemplate.setIncludeSum(colDimEntry.getBoolean("lv3colsubtotal"));
                lv3ColDimTemplate.setVisible(true);
                lv3ColDimTemplate.setExpand(false);
                lv3ColDimTemplate.setLocation(DimLocation.COL);
                DynamicObjectCollection lv3MembersOfCol = colDimEntry.getDynamicObjectCollection("lv3coldimmember");
                List lv3MemberIdLstOfCol = Optional.ofNullable(lv3MembersOfCol).map(members -> members.stream().map(o -> o.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(o -> o.getLong("id")).collect(Collectors.toList())).orElseGet(ArrayList::new);
                lv3ColDimTemplate.setMemberScope(lv3MemberIdLstOfCol);
                lv3ColDimTemplate.setLevel(3);
                lv3ColDimTemplate.setSequence(1);
                lv3ColDimTemplate.setDimType(DimensionType.getDimsionByNumber(DimLayoutHelper.getDimessionMemberType(DimLocation.COL, 3, template)));
                lv3ColDimTemplate.setDimensionName(DimLayoutHelper.getDimessionName(DimLocation.COL, 3, template));
                colDimLst.add(lv3ColDimTemplate);
            }
            reportTemplate.setColDimList(colDimLst);
            reportTemplate.setRemarkVisible(colDimEntry.getBoolean("isshownote"));
            reportTemplate.setRemarkName(colDimEntry.getString("notename"));
            DynamicObjectCollection remarkFieldDc = colDimEntry.getDynamicObjectCollection("remarkfield");
            reportTemplate.setRemarkFieldList(remarkFieldDc.stream().map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toList()));
            if (EmptyUtil.isNoEmpty(reportTemplate.getRemarkFieldList()) && EmptyUtil.isEmpty(reportTemplate.getRemarkEntityList())) {
                reportTemplate.setRemarkEntityList(AuxiliaryFieldsRepository.getAuxiliaryField(reportTemplate.getRemarkFieldList()));
            }
            reportTemplate.setShowcombine(colDimEntry.getBoolean("isshowcombine"));
            reportTemplate.setDistinguish(colDimEntry.getBoolean("isdistinguish"));
            DynamicObjectCollection rowDimEntrys = template.getDynamicObjectCollection("rowentryentity");
            DynamicObject rowDimEntry = (DynamicObject)rowDimEntrys.get(0);
            ArrayList<TemplateDim> rowDimList = new ArrayList<TemplateDim>(10);
            TemplateDim lv1RowDimTemplate = new TemplateDim();
            lv1RowDimTemplate.setId(rowDimEntry.getLong("id"));
            lv1RowDimTemplate.setDimensionId(DimLayoutHelper.getDimessionId(DimLocation.ROW, 1, template));
            lv1RowDimTemplate.setIncludeSum(false);
            lv1RowDimTemplate.setVisible(true);
            lv1RowDimTemplate.setLocation(DimLocation.ROW);
            lv1RowDimTemplate.setExpand(false);
            DynamicObjectCollection lv1membersofrow = rowDimEntry.getDynamicObjectCollection("lv1rowdimmember");
            List lv1MemberIdLstOfRow = Optional.ofNullable(lv1membersofrow).map(members -> members.stream().map(o -> o.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(o -> o.getLong("id")).collect(Collectors.toList())).orElseGet(ArrayList::new);
            lv1RowDimTemplate.setMemberScope(lv1MemberIdLstOfRow);
            lv1RowDimTemplate.setLevel(1);
            lv1RowDimTemplate.setDimType(DimensionType.getDimsionByNumber(DimLayoutHelper.getDimessionMemberType(DimLocation.ROW, 1, template)));
            lv1RowDimTemplate.setDimensionName(DimLayoutHelper.getDimessionName(DimLocation.ROW, 1, template));
            rowDimList.add(lv1RowDimTemplate);
            TemplateDim lv2RowDimTemplate = new TemplateDim();
            Long lv2RowDim = DimLayoutHelper.getDimessionId(DimLocation.ROW, 2, template);
            if (null != lv2RowDim && 0 != lv2RowDim.compareTo(0L)) {
                lv2RowDimTemplate.setId(rowDimEntry.getLong("id"));
                lv2RowDimTemplate.setDimensionId(lv2RowDim);
                lv2RowDimTemplate.setIncludeSum(rowDimEntry.getBoolean("lv2rowsubtotal"));
                lv2RowDimTemplate.setVisible(true);
                lv2RowDimTemplate.setLocation(DimLocation.ROW);
                lv2RowDimTemplate.setExpand(false);
                DynamicObjectCollection lv2membersofrow = rowDimEntry.getDynamicObjectCollection("lv2rowdimmember");
                List lv2MemberIdLstOfRow = Optional.ofNullable(lv2membersofrow).map(members -> members.stream().map(o -> o.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(o -> o.getLong("id")).collect(Collectors.toList())).orElseGet(ArrayList::new);
                lv2RowDimTemplate.setMemberScope(lv2MemberIdLstOfRow);
                lv2RowDimTemplate.setLevel(2);
                lv2RowDimTemplate.setDimType(DimensionType.getDimsionByNumber(DimLayoutHelper.getDimessionMemberType(DimLocation.ROW, 2, template)));
                lv2RowDimTemplate.setDimensionName(DimLayoutHelper.getDimessionName(DimLocation.ROW, 2, template));
                rowDimList.add(lv2RowDimTemplate);
            }
            reportTemplate.setRowDimList(rowDimList);
        }
        TemplateVOConverter.fillMetricDimAndMemberScopeIfNeed(template, reportTemplate);
        TemplateVOConverter.fillMemberScopeAndFilterDimToTemplateDim(reportTemplate);
    }

    private static void fillMetricDimAndMemberScopeIfNeed(DynamicObject template, ReportTemplate reportTemplate) {
        if (Objects.nonNull(reportTemplate.getMetricTplDim())) {
            return;
        }
        if (reportTemplate.getTemplateType() == TemplateType.DETAIL) {
            return;
        }
        ArrayList<String> metricNumber = new ArrayList<String>(3);
        metricNumber.add(TemplateMetricType.PLANAMT.getNumber());
        if (reportTemplate.getTemplateUse() == TemplateUseType.SUMMARY) {
            metricNumber.add(TemplateMetricType.REPORTPLANAMT.getNumber());
            metricNumber.add(TemplateMetricType.ORIGINALPLANAMT.getNumber());
        }
        String selectFields = String.join((CharSequence)",", "id", "metricpresettype", "dimension");
        Object[] load = TmcDataServiceHelper.load((String)"fpm_member", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("metricpresettype", "in", metricNumber).and("bodysystem", "=", (Object)reportTemplate.getSystemId()).and("preset", "=", (Object)Boolean.TRUE).and("dimtype", "=", (Object)DimensionType.METRIC.getNumber())});
        if (EmptyUtil.isEmpty((Object[])load)) {
            return;
        }
        Object metricMember = load[0];
        TemplateDim metricDim = new TemplateDim();
        metricDim.setDimensionId(metricMember.getLong("dimension.id"));
        metricDim.setDimensionName(metricMember.getString("dimension.name"));
        metricDim.setDetailDim(false);
        metricDim.setIncludeSum(false);
        metricDim.setVisible(true);
        metricDim.setExpand(false);
        metricDim.setScopeType(TemplateDimMemScopeType.FIXED_MEMBER);
        metricDim.setLocation(DimLocation.COL);
        metricDim.setDimType(DimensionType.METRIC);
        metricDim.setMemberScope(Collections.singletonList((Long)metricMember.getPkValue()));
        reportTemplate.setMetricTplDim(metricDim);
    }

    private static void fillMemberScopeAndFilterDimToTemplateDim(ReportTemplate reportTemplate) {
        TemplateLayout dimLayout = reportTemplate.getDimLayout();
        Map layoutInfoMap = dimLayout.getDimLayoutInfoList().stream().collect(Collectors.toMap(TemplateLayout.LayoutInfo::getDimensionId, Function.identity()));
        List<TemplateDim> allTemplateDim = reportTemplate.getAllTemplateDim();
        for (TemplateDim templateDim : allTemplateDim) {
            Long dimensionId;
            TemplateLayout.LayoutInfo layoutInfo;
            if (templateDim.getDimType() == DimensionType.DETAILDIM || EmptyUtil.isEmpty((Object)(layoutInfo = (TemplateLayout.LayoutInfo)layoutInfoMap.get(dimensionId = templateDim.getDimensionId())))) continue;
            templateDim.setScopeType(layoutInfo.getScopeType());
            templateDim.setFilterDim(layoutInfo.isFilterDim());
        }
    }

    private static void initSubjectSetting(DynamicObject template, ReportTemplate reportTemplate) {
        List<TemplateAccountSetting> accountSettings = TemplateVOConverter.convertSetting(template);
        reportTemplate.setAccountSettings(accountSettings);
    }

    public static List<TemplateAccountSetting> convertSetting(DynamicObject template) {
        ArrayList<TemplateAccountSetting> accountSettings = new ArrayList<TemplateAccountSetting>(10);
        DynamicObjectCollection accountSettingEntrys = template.getDynamicObjectCollection("subjectsetentry");
        for (DynamicObject accountSettingEntry : accountSettingEntrys) {
            TemplateAccountSetting templateAccountSetting = new TemplateAccountSetting();
            templateAccountSetting.setId(accountSettingEntry.getLong("id"));
            templateAccountSetting.setFormula(accountSettingEntry.getString("formula"));
            ReportInputType inputType = ReportInputType.getByNumber(accountSettingEntry.getString("reportways"));
            templateAccountSetting.setInputType(inputType);
            DynamicObject member = accountSettingEntry.getDynamicObject("subject");
            if (Objects.isNull(member)) continue;
            templateAccountSetting.setAccountMemId(member.getLong("id"));
            DynamicObject subTemplateObj = accountSettingEntry.getDynamicObject("subtemplate");
            if (!EmptyUtil.isEmpty((DynamicObject)subTemplateObj)) {
                templateAccountSetting.setChildTemplateId(subTemplateObj.getLong("id"));
            } else {
                templateAccountSetting.setChildTemplateId(null);
            }
            templateAccountSetting.setLeaf(accountSettingEntry.getBoolean("isleaf"));
            templateAccountSetting.setHideInReport(accountSettingEntry.getBoolean("hideinreport"));
            accountSettings.add(templateAccountSetting);
        }
        return accountSettings;
    }

    public static TemplateLayout convertToDimLayoutModel(DynamicObject template) {
        TemplateType templateType = TemplateType.getByNumber(template.getString("templatetype"));
        DynamicObjectCollection layoutColl = template.getDynamicObjectCollection("layoutentry");
        TemplateLayout templateLayout = new TemplateLayout();
        templateLayout.setTemplateType(templateType);
        ArrayList<TemplateLayout.LayoutInfo> layoutInfoLst = new ArrayList<TemplateLayout.LayoutInfo>(5);
        for (DynamicObject entry : layoutColl) {
            TemplateLayout.LayoutInfo layoutInfo = new TemplateLayout.LayoutInfo();
            layoutInfo.setDimensionId(entry.getLong("layoutdim.id"));
            layoutInfo.setDimLocation(DimLocation.getByNumber(entry.getString("dimtype")));
            layoutInfo.setLevel(entry.getInt("dimlevel"));
            layoutInfo.setExpand(entry.getBoolean("isopen"));
            layoutInfo.setIncludeSum(entry.getBoolean("iscontaintotal"));
            DynamicObjectCollection memberList = entry.getDynamicObjectCollection("expandmember");
            List<Long> userIdList = memberList.stream().map(o -> o.getDynamicObject("fbasedataid")).map(o -> o.getLong("id")).collect(Collectors.toList());
            layoutInfo.setExpandMembers(userIdList);
            layoutInfo.setVisible(!entry.getBoolean("dimhide"));
            layoutInfo.setScopeType(ITypeEnum.getByNumber(entry.getString("memberscope"), TemplateDimMemScopeType.class));
            layoutInfo.setFilterDim(entry.getBoolean("filterdim"));
            layoutInfoLst.add(layoutInfo);
        }
        templateLayout.setDimLayoutInfoList(layoutInfoLst);
        return templateLayout;
    }

    public static TemplateBaseInfo convertToBaseInfoModel(DynamicObject template) {
        TemplateBaseInfo templateBaseInfo = new TemplateBaseInfo();
        TemplateType templateType = TemplateType.getByNumber(template.getString("templatetype"));
        FpmAssertUtil.isNotNull((Object)((Object)templateType), (String)"templateType is null");
        templateBaseInfo.setTemplateType(templateType);
        templateBaseInfo.setSystemId(template.getLong("model.id"));
        templateBaseInfo.setName(template.get("name"));
        templateBaseInfo.setNumber(template.getString("number"));
        boolean mainTable = template.getBoolean("ismaintable");
        templateBaseInfo.setMainTable(mainTable);
        templateBaseInfo.setStartLocation(template.getString("startcell"));
        String templateUses = template.getString("templateuses");
        templateBaseInfo.setTemplateUses(ITypeEnum.getByNumber(templateUses, TemplateUseType.class));
        templateBaseInfo.setEffectiveDate(template.getDate("effectivedate"));
        DynamicObjectCollection dynamicObjectCollection = template.getDynamicObjectCollection("statanalysistemplate");
        List<Object> statReportTemplateList = Lists.newArrayListWithCapacity((int)0);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)dynamicObjectCollection)) {
            List statTemplateIds = dynamicObjectCollection.stream().map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(statTemplateIds)) {
                Map load = TmcDataServiceHelper.loadFromCache((Object[])statTemplateIds.toArray(), (String)"fpm_template");
                statReportTemplateList = load.values().stream().map(TemplatePOConverter::convertToTemplate).collect(Collectors.toList());
            }
        }
        templateBaseInfo.setStatAnalysisTemplateList(statReportTemplateList);
        int maxLines = 0;
        if (templateType.getNumber().equals(TemplateType.DETAIL.getNumber())) {
            maxLines = template.getInt("maxnum");
        }
        templateBaseInfo.setMaxLineCount(maxLines);
        templateBaseInfo.setDescription(template.getString("comment"));
        templateBaseInfo.setEnable(template.getBoolean("enable"));
        AmountUnit amount = AmountUnit.getByNumber(template.getString("amountunit"));
        templateBaseInfo.setDetailIncludeSum(template.getBoolean("isincludesum"));
        templateBaseInfo.setAmountUnit(amount);
        Map<Object, MetricMember> metricMap = TemplateVOConverter.getMetricMap(templateBaseInfo.getSystemId());
        DynamicObjectCollection reportTypeColl = template.getDynamicObjectCollection("reporttypeentry");
        ArrayList<TemplateReportType> reportTypeList = new ArrayList<TemplateReportType>(reportTypeColl.size());
        for (DynamicObject dynamicObject : reportTypeColl) {
            TemplateReportType templateReportType = new TemplateReportType();
            templateReportType.setReportTypeId(dynamicObject.getLong("e_reporttype.id"));
            templateReportType.setReferenceReportTypeId(dynamicObject.getLong("e_refrenceorg.id"));
            if (StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("refrencepos"))) {
                String[] referencePosArr = dynamicObject.getString("refrencepos").split(",");
                ArrayList<TemplateReferencePosType> referencePosTypeArr = new ArrayList<TemplateReferencePosType>(referencePosArr.length);
                for (String referencePos : referencePosArr) {
                    if (!StringUtils.isNotEmpty((CharSequence)referencePos)) continue;
                    referencePosTypeArr.add(TemplateReferencePosType.getByNumber(referencePos));
                }
                templateReportType.setReferencePosTypeS(referencePosTypeArr);
            }
            templateReportType.setReferencePosIds(dynamicObject.getDynamicObjectCollection("newreferencepos").stream().map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toList()));
            templateReportType.setReferencePosList(templateReportType.getReferencePosIds().stream().map(metricMap::get).filter(Objects::nonNull).collect(Collectors.toList()));
            templateReportType.setAuxiliaryFieldIds(dynamicObject.getDynamicObjectCollection("auxiliaryfield").stream().map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toList()));
            if (EmptyUtil.isNoEmpty(templateReportType.getAuxiliaryFieldIds()) && EmptyUtil.isEmpty(templateReportType.getAuxiliaryFieldList())) {
                templateReportType.setAuxiliaryFieldList(AuxiliaryFieldsRepository.getAuxiliaryField(templateReportType.getAuxiliaryFieldIds()));
            }
            templateReportType.setConsultSeatType(ITypeEnum.getByNumber(dynamicObject.getString("consultseat"), TemplateConsultSeatType.class));
            templateReportType.setPeriodNum(dynamicObject.getInt("periodnum"));
            reportTypeList.add(templateReportType);
        }
        templateBaseInfo.setReportTypeList(reportTypeList);
        if (CollectionUtils.isEmpty(reportTypeList)) {
            DynamicObjectCollection periodList = template.getDynamicObjectCollection("reporttype");
            List<Long> periodIdList = periodList.stream().map(o -> o.getDynamicObject("fbasedataid")).map(o -> o.getLong("id")).collect(Collectors.toList());
            templateBaseInfo.setReportPeriods(periodIdList);
        } else {
            List<Long> periodIdList = reportTypeList.stream().map(TemplateReportType::getReportTypeId).collect(Collectors.toList());
            templateBaseInfo.setReportPeriods(periodIdList);
        }
        String smartGetSetStr = template.getString("smartgetvalset");
        if (StringUtils.isNotEmpty((CharSequence)smartGetSetStr)) {
            templateBaseInfo.setSmartGetValSetType(TemplateSmartGetValSetType.getByNumber(smartGetSetStr));
        }
        return templateBaseInfo;
    }

    private static Map<Object, MetricMember> getMetricMap(Long bodySysId) {
        DynamicObject[] metricMembers = new DimMemberRepository().loadMetricDimMembers(Collections.singletonList(bodySysId));
        MetricMemberConverter memberConverter = (MetricMemberConverter)MemberConverterFactory.createMemberConverterByDimType(DimensionType.METRIC);
        return Arrays.stream(metricMembers).collect(Collectors.toMap(d -> d.getLong("id"), dy -> (MetricMember)memberConverter.convertToMember((DynamicObject)dy)));
    }

    private static void initCurrencyMember(DynamicObject template, ReportTemplate reportTemplate) {
        DynamicObjectCollection layoutEntry = template.getDynamicObjectCollection("layoutentry");
        Optional<DynamicObject> firstLayoutOptional = layoutEntry.stream().filter(e -> {
            DynamicObject dynamicObject = e.getDynamicObject("layoutdim");
            if (Objects.isNull(dynamicObject)) {
                return false;
            }
            return DimsionEnums.CURRENCY.getNumber().equals(dynamicObject.getString("basedata"));
        }).findFirst();
        if (firstLayoutOptional.isPresent()) {
            DynamicObject currencyLayout = firstLayoutOptional.get();
            Object pkValue = currencyLayout.getDynamicObject("layoutdim").getPkValue();
            List<TemplateDim> allTemplateDim = reportTemplate.getAllTemplateDim();
            List currencyDimList = allTemplateDim.stream().filter(e -> pkValue.equals(e.getDimensionId())).collect(Collectors.toList());
            if (currencyDimList.size() > 0) {
                Set currencyMemberIdSet = currencyDimList.stream().map(TemplateDim::getMemberScope).filter(o -> !CollectionUtils.isEmpty((Collection)o)).flatMap(Collection::stream).collect(Collectors.toSet());
                reportTemplate.setCurrencyMemberIdList(new ArrayList<Long>(currencyMemberIdSet));
            }
        }
    }

    public static TemplateLayout convertDimLayoutInfo(DynamicObject dataEntity) {
        TemplateLayout templateLayout = new TemplateLayout();
        templateLayout.setTemplateType(TemplateType.FIXED);
        ArrayList<TemplateLayout.LayoutInfo> layoutInfoLst = new ArrayList<TemplateLayout.LayoutInfo>(5);
        DynamicObjectCollection dimEntryCol = dataEntity.getDynamicObjectCollection("layoutentry");
        for (DynamicObject dimEntry : dimEntryCol) {
            TemplateLayout.LayoutInfo layoutInfo = new TemplateLayout.LayoutInfo();
            layoutInfo.setDimensionId(dimEntry.getLong("layoutdim.id"));
            layoutInfo.setDimLocation(DimLocation.getByNumber(dimEntry.getString("dimtype")));
            layoutInfo.setLevel(dimEntry.getInt("dimlevel"));
            layoutInfo.setExpand(dimEntry.getBoolean("isopen"));
            DynamicObjectCollection memberList = dimEntry.getDynamicObjectCollection("expandmember");
            List userIdList = Optional.ofNullable(memberList).map(members -> members.stream().map(o -> o.getDynamicObject("fbasedataid")).map(o -> o.getLong("id")).collect(Collectors.toList())).orElseGet(ArrayList::new);
            layoutInfo.setExpandMembers(userIdList);
            layoutInfo.setVisible(!dimEntry.getBoolean("dimhide"));
            layoutInfoLst.add(layoutInfo);
        }
        templateLayout.setDimLayoutInfoList(layoutInfoLst);
        return templateLayout;
    }
}

