/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter.control;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.tmc.fpm.business.domain.model.control.ControlPreTime;
import kd.tmc.fpm.business.mvc.converter.control.Converter;

public class ControlPreTimeConverter
implements Converter<ControlPreTime> {
    @Override
    public ControlPreTime convert(DynamicObject dynamicObject) {
        ControlPreTime controlPreTime = new ControlPreTime();
        controlPreTime.setId((Long)dynamicObject.getPkValue());
        DynamicObject preBusinessBill = dynamicObject.getDynamicObject("entry_businessbill");
        controlPreTime.setBizBill(preBusinessBill.getPkValue().toString());
        controlPreTime.setAppName(preBusinessBill.getDynamicObject("bizappid").getString("name"));
        controlPreTime.setPreTime(this.getValue(dynamicObject.getString("entry_preemptedtimecode")));
        controlPreTime.setCancelPreTime(this.getValue(dynamicObject.getString("entry_unpreemptedcode")));
        controlPreTime.setReleasePreTime(this.getValue(dynamicObject.getString("entry_releasecode")));
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entry_actualbusinessbill");
        controlPreTime.setReactAclBizBills(Objects.isNull(dynamicObjectCollection) ? Collections.emptyList() : dynamicObjectCollection.stream().map(DataEntityBase::getPkValue).map(Object::toString).collect(Collectors.toList()));
        return controlPreTime;
    }

    private List<String> getValue(String strVal) {
        if (StringUtils.isEmpty((CharSequence)strVal)) {
            return Collections.emptyList();
        }
        String[] split = strVal.split(",");
        return Arrays.stream(split).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
    }
}

