/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter.control;

import java.util.ArrayList;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.tmc.fpm.business.domain.enums.ControlIntensityType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.SubjectFlowType;
import kd.tmc.fpm.business.domain.model.control.ControlStrategyDetail;
import kd.tmc.fpm.business.mvc.converter.control.Converter;

public class ControlStrategyDetailConverter
implements Converter<ControlStrategyDetail> {
    @Override
    public ControlStrategyDetail convert(DynamicObject dynamicObject) {
        ControlStrategyDetail controlStrategyDetail = new ControlStrategyDetail();
        DynamicObject subjectDy = dynamicObject.getDynamicObject("entry_subjectnumber");
        controlStrategyDetail.setId((Long)dynamicObject.getPkValue());
        DynamicObject parentDy = subjectDy.getDynamicObject("parent");
        controlStrategyDetail.setParentId(Objects.isNull(parentDy) ? 0L : (Long)parentDy.getPkValue());
        controlStrategyDetail.setSubjectId((Long)subjectDy.getPkValue());
        controlStrategyDetail.setSubjectName(subjectDy.getString("name"));
        controlStrategyDetail.setSubjectNumber(subjectDy.getString("number"));
        controlStrategyDetail.setSubjectLevel(subjectDy.getInt("level"));
        controlStrategyDetail.setSubjectFlow(ITypeEnum.getByNumber(subjectDy.getString("flow"), SubjectFlowType.class));
        controlStrategyDetail.setControlIntensity(ITypeEnum.getByNumber(dynamicObject.getString("entry_controlintensity"), ControlIntensityType.class));
        controlStrategyDetail.setControlCoefficient(dynamicObject.getBigDecimal("entry_controlcoefficient"));
        controlStrategyDetail.setDetailControl(dynamicObject.getBoolean("entry_detailcontrol"));
        String detailControlBasis = dynamicObject.getString("entry_detailcontrolbasis");
        this.setDetailControlBasisList(controlStrategyDetail, detailControlBasis);
        return controlStrategyDetail;
    }

    private void setDetailControlBasisList(ControlStrategyDetail controlStrategyDetail, String detailControlBasisStr) {
        String[] split;
        ArrayList<ControlStrategyDetail.DetailControlBasis> list = new ArrayList<ControlStrategyDetail.DetailControlBasis>(8);
        controlStrategyDetail.setDetailControlBasisList(list);
        if (StringUtils.isEmpty((CharSequence)detailControlBasisStr)) {
            return;
        }
        for (String detail : split = detailControlBasisStr.split(",")) {
            String[] values;
            if (StringUtils.isEmpty((CharSequence)detail) || (values = detail.split("#")).length != 2) continue;
            DimensionType dimensionByNumber = DimensionType.getDimsionByNumber(values[0]);
            if (Objects.isNull((Object)dimensionByNumber)) {
                dimensionByNumber = DimensionType.DETAILDIM;
            }
            ControlStrategyDetail.DetailControlBasis detailControlBasis = new ControlStrategyDetail.DetailControlBasis(dimensionByNumber, Long.valueOf(values[1]));
            list.add(detailControlBasis);
        }
    }
}

