/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter.control;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.ControlActTime;
import kd.tmc.fpm.business.domain.model.control.ControlPreTime;
import kd.tmc.fpm.business.domain.model.control.ControlTime;
import kd.tmc.fpm.business.mvc.converter.control.Converter;
import kd.tmc.fpm.business.mvc.converter.utils.ConverterUtils;

public class ControlTimeConverter
implements Converter<ControlTime> {
    @Override
    public ControlTime convert(DynamicObject dynamicObject) {
        ControlTime controlTime = new ControlTime();
        controlTime.setId((Long)dynamicObject.getPkValue());
        controlTime.setNumber(dynamicObject.getString("number"));
        controlTime.setEnable(dynamicObject.getBoolean("enable"));
        controlTime.setSystemId((Long)dynamicObject.getDynamicObject("bodysys").getPkValue());
        controlTime.setAllowSkip(dynamicObject.getBoolean("allowskip"));
        controlTime.setControlPreTimeList((List<ControlPreTime>)((Object)ConverterUtils.convert(ControlPreTime.class, dynamicObject.getDynamicObjectCollection("entryentity"))));
        controlTime.setControlActTimeList((List<ControlActTime>)((Object)ConverterUtils.convert(ControlActTime.class, dynamicObject.getDynamicObjectCollection("entryentity_actual"))));
        DynamicObjectCollection controlReportTypes = dynamicObject.getDynamicObjectCollection("controlledreporttype");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)controlReportTypes)) {
            List<Long> reportTypeIds = controlReportTypes.stream().filter(Objects::nonNull).map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toList());
            controlTime.setControledReportTypeIds(reportTypeIds);
        }
        return controlTime;
    }
}

