/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter.inspection;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.InspectionExecResult;
import kd.tmc.fpm.business.domain.enums.InspectionExecStatus;
import kd.tmc.fpm.business.domain.enums.InspectionRepairResult;
import kd.tmc.fpm.business.domain.enums.InspectionScope;
import kd.tmc.fpm.business.domain.enums.InspectionTargetType;
import kd.tmc.fpm.business.domain.enums.InspectionType;
import kd.tmc.fpm.business.domain.model.inspection.log.BillInspectionDetail;
import kd.tmc.fpm.business.domain.model.inspection.log.BillInspectionLog;
import kd.tmc.fpm.business.mvc.converter.control.IConverter;

public class BillInspectionLogPOConverter
implements IConverter<BillInspectionLog, DynamicObject> {
    @Override
    public BillInspectionLog convert(DynamicObject dynamicObject) {
        DynamicObjectCollection orgScopeIds;
        BillInspectionLog baseLog = new BillInspectionLog();
        baseLog.setId((Long)dynamicObject.getPkValue());
        baseLog.setBillNo(dynamicObject.getString("billno"));
        DynamicObject bodySys = dynamicObject.getDynamicObject("bodysys");
        if (Objects.nonNull(bodySys)) {
            baseLog.setSystemId((Long)bodySys.getPkValue());
        }
        baseLog.setInspectionType(ITypeEnum.getByNumber(dynamicObject.getString("inspectiontype"), InspectionType.class));
        DynamicObject config = dynamicObject.getDynamicObject("inspection_config");
        if (Objects.nonNull(config)) {
            baseLog.setInspectionConfigId((Long)config.getPkValue());
        }
        baseLog.setInspectionScope(ITypeEnum.getByNumber(dynamicObject.getString("inspectionscope"), InspectionScope.class));
        baseLog.setInspectionStartDate(dynamicObject.getDate("startdate"));
        baseLog.setInspectionEndDate(dynamicObject.getDate("enddate"));
        DynamicObjectCollection periodScopeIds = dynamicObject.getDynamicObjectCollection("exec_period_scope");
        if (!CollectionUtils.isEmpty((Collection)periodScopeIds)) {
            List<Long> inspectionPeriodScope = periodScopeIds.stream().map(item -> (Long)item.getPkValue()).collect(Collectors.toList());
            baseLog.setInspectionPeriodScope(inspectionPeriodScope);
        }
        if (!CollectionUtils.isEmpty((Collection)(orgScopeIds = dynamicObject.getDynamicObjectCollection("exec_org_scope")))) {
            List<Long> orgScopeIdList = orgScopeIds.stream().map(item -> (Long)item.getPkValue()).collect(Collectors.toList());
            baseLog.setInspectionOrgScope(orgScopeIdList);
        }
        baseLog.setExecDate(dynamicObject.getDate("execdate"));
        baseLog.setFinishDate(dynamicObject.getDate("finishdate"));
        baseLog.setExecStatus(ITypeEnum.getByNumber(dynamicObject.getString("execstatus"), InspectionExecStatus.class));
        baseLog.setExecResult(ITypeEnum.getByNumber(dynamicObject.getString("execresult"), InspectionExecResult.class));
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entry_result_detail");
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return baseLog;
        }
        for (DynamicObject object : dynamicObjectCollection) {
            String errorExecRecordStr;
            BillInspectionDetail detail = new BillInspectionDetail();
            DynamicObject matchRuleObj = object.getDynamicObject("e_detail_matchrule");
            if (Objects.nonNull(matchRuleObj)) {
                detail.setMatchRuleId((Long)matchRuleObj.getPkValue());
                detail.setBizBill(matchRuleObj.getString("businessbill.number"));
            }
            detail.setInspectTarget(ITypeEnum.getByNumber(object.getString("e_detail_inspecttarget"), InspectionTargetType.class));
            detail.setInspectRange(object.getString("e_detail_inspectrange"));
            detail.setExecResult(ITypeEnum.getByNumber(object.getString("e_detail_inspectresult"), InspectionExecResult.class));
            String billNoStr = object.getString("entry_error_bizinfo");
            if (!StringUtils.isEmpty((Object)billNoStr)) {
                String[] split;
                for (String billNo : split = billNoStr.split(",")) {
                    detail.addErrorBizBill(new BillInspectionDetail.BillObject(null, billNo, null));
                }
            }
            if (!StringUtils.isEmpty((Object)(errorExecRecordStr = object.getString("e_detail_errorexecrecord")))) {
                String[] split;
                for (String errorRecord : split = errorExecRecordStr.split(",")) {
                    detail.addErrorExecRecordList(new BillInspectionDetail.BillObject(null, errorRecord, null));
                }
            }
            detail.setRepairMethod(object.getString("e_detail_repairmethod"));
            detail.setRepairResult(ITypeEnum.getByNumber(object.getString("e_detail_repairreuslt"), InspectionRepairResult.class));
            baseLog.addBillInspectionDetail(detail);
        }
        return baseLog;
    }
}

