/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter.inspection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.InspectionHandleType;
import kd.tmc.fpm.business.domain.enums.InspectionScope;
import kd.tmc.fpm.business.domain.enums.InspectionType;
import kd.tmc.fpm.business.domain.model.inspection.InspectionActualOccupyRule;
import kd.tmc.fpm.business.domain.model.inspection.InspectionConfig;
import kd.tmc.fpm.business.domain.model.inspection.InspectionPreOccupyRule;
import kd.tmc.fpm.business.mvc.converter.control.Converter;
import org.apache.commons.collections.CollectionUtils;

public class InspectionConfigConverter
implements Converter<InspectionConfig> {
    @Override
    public InspectionConfig convert(DynamicObject dynamicObject) {
        InspectionConfig inspectionConfig = new InspectionConfig();
        inspectionConfig.setId(dynamicObject.getLong("id"));
        inspectionConfig.setInspectionScope(ITypeEnum.getByNumber(dynamicObject.getString("inspectionscope"), InspectionScope.class));
        inspectionConfig.setInspectionType(ITypeEnum.getByNumber(dynamicObject.getString("inspectiontype"), InspectionType.class));
        inspectionConfig.setHandleType(ITypeEnum.getByNumber(dynamicObject.getString("handletype"), InspectionHandleType.class));
        inspectionConfig.setNumber(dynamicObject.getString("number"));
        inspectionConfig.setName(dynamicObject.getString("name"));
        inspectionConfig.setSystemId(dynamicObject.getDynamicObject("bodysys").getLong("id"));
        DynamicObjectCollection notifyStaffsColl = dynamicObject.getDynamicObjectCollection("notifiedstaffs");
        if (CollectionUtils.isNotEmpty((Collection)notifyStaffsColl)) {
            List<Long> notifyStaffIdList = notifyStaffsColl.stream().map(item -> item.getDynamicObject("fbasedataid")).map(item -> (Long)item.getPkValue()).collect(Collectors.toList());
            inspectionConfig.setNotifyObjIdList(notifyStaffIdList);
        }
        inspectionConfig.setPreset(dynamicObject.getBoolean("systempreset"));
        DynamicObjectCollection preOccupyColl = dynamicObject.getDynamicObjectCollection("entry_preoccupation");
        DynamicObjectCollection actualOccupyColl = dynamicObject.getDynamicObjectCollection("entry_actualoccupation");
        if (CollectionUtils.isNotEmpty((Collection)preOccupyColl)) {
            ArrayList<InspectionPreOccupyRule> preOccupyRuleList = new ArrayList<InspectionPreOccupyRule>(preOccupyColl.size());
            for (DynamicObject preRuleDO : preOccupyColl) {
                InspectionPreOccupyRule preOccupyRule = new InspectionPreOccupyRule();
                preOccupyRule.setBizBill(preRuleDO.getString("entry_preocp_obj"));
                preOccupyRule.setMatchRuleId(preRuleDO.getDynamicObject("entry_preocp_matchrule").getLong("id"));
                preOccupyRule.setPreOccupyCondition(preRuleDO.getString("e_pocinspectprereal_tag"));
                preOccupyRule.setCancelPreOccupyCondition(preRuleDO.getString("e_pocispcnclprereal_tag"));
                preOccupyRule.setReleasePreOccupyCondition(preRuleDO.getString("e_pocisprlsprereal_tag"));
                preOccupyRuleList.add(preOccupyRule);
            }
            inspectionConfig.setPreOccupyRuleList(preOccupyRuleList);
        }
        if (CollectionUtils.isNotEmpty((Collection)actualOccupyColl)) {
            ArrayList<InspectionActualOccupyRule> actualOccupyRuleList = new ArrayList<InspectionActualOccupyRule>(preOccupyColl.size());
            for (DynamicObject preRuleDO : actualOccupyColl) {
                InspectionActualOccupyRule actualOccupyRule = new InspectionActualOccupyRule();
                actualOccupyRule.setBizBill(preRuleDO.getString("entry_actocp_obj"));
                actualOccupyRule.setMatchRuleId(preRuleDO.getDynamicObject("entry_actocp_matchrule").getLong("id"));
                actualOccupyRule.setActualOccupyCondition(preRuleDO.getString("e_aocinspectactreal_tag"));
                actualOccupyRule.setCancelActualOccupyCondition(preRuleDO.getString("e_aocispcnclactreal_tag"));
                actualOccupyRule.setReleaseActualOccupyCondition(preRuleDO.getString("e_aocpisprlsactreal_tag"));
                actualOccupyRuleList.add(actualOccupyRule);
            }
            inspectionConfig.setActualOccupyRuleList(actualOccupyRuleList);
        }
        return inspectionConfig;
    }
}

