/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter.member;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.MemberType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.mvc.converter.member.IMemberConverter;

public abstract class AbstractMemberConverter
implements IMemberConverter {
    @Override
    public DimMember convertToMember(DynamicObject memberPO) {
        DimMember member = this.createMember();
        member.setId(memberPO.getLong("id"));
        member.setParentId(memberPO.getLong("parent.id"));
        member.setName(memberPO.getString("name"));
        member.setNumber(memberPO.getString("number"));
        member.setLongNumber(memberPO.getString("longnumber"));
        String sortCode = memberPO.getString("sortcode");
        member.setSortCode(EmptyUtil.isNoEmpty((String)sortCode) ? sortCode : memberPO.getString("longnumber"));
        member.setMemberType(MemberType.DIM_MEMBER);
        member.setEnable(memberPO.getBoolean("enable"));
        member.setLevel(memberPO.getInt("level"));
        member.setLeaf(memberPO.getBoolean("isleaf"));
        member.setSourceId(memberPO.getLong("sourceid"));
        member.setDimensionId(memberPO.getLong("dimension.id"));
        member.setShrekKey(memberPO.getString("shrekdatakey"));
        member.setSumType(memberPO.getString("sumtype"));
        return member;
    }

    @Override
    public List<DimMember> convertToMemberTree(List<DynamicObject> memberPOList) {
        ArrayList<DimMember> memberList = new ArrayList<DimMember>(memberPOList.size());
        for (DynamicObject memberPO : memberPOList) {
            DimMember memberInfo = this.convertToMember(memberPO);
            memberList.add(memberInfo);
        }
        List<DimMember> firstLevelMemberList = memberList.stream().filter(o -> o.getLevel() == 1).collect(Collectors.toList());
        for (DimMember firstLevelMem : firstLevelMemberList) {
            this.generateMemTree(firstLevelMem, memberList);
        }
        return firstLevelMemberList;
    }

    private void generateMemTree(DimMember parent, List<DimMember> memList) {
        if (parent.isLeaf()) {
            return;
        }
        Long parentId = parent.getId();
        for (DimMember member : memList) {
            if (!parentId.equals(member.getParentId())) continue;
            member.setParent(parent);
            parent.getChildren().add(member);
            if (member.isLeaf()) continue;
            this.generateMemTree(member, memList);
        }
    }

    protected abstract DimMember createMember();
}

