/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.mvc.converter.control.Converter;
import kd.tmc.fpm.business.mvc.converter.control.IConverter;
import kd.tmc.fpm.business.mvc.converter.control.factory.ConverterFactory;

public class ConverterUtils {
    public static <T> T convert(Class<T> clazz, DynamicObject dynamicObject) {
        return ConverterUtils.convertSingle(clazz, dynamicObject);
    }

    public static <T> T convertSingle(Class<T> clazz, DynamicObject dynamicObject) {
        if (Objects.isNull(dynamicObject)) {
            return null;
        }
        Converter<T> converter = ConverterFactory.getConverter(clazz);
        return converter.convert(dynamicObject);
    }

    public static <T> List<T> convert(Class<T> clazz, Collection<DynamicObject> dynamicObjectCollection) {
        return ConverterUtils.convert(clazz, dynamicObjectCollection, false);
    }

    public static <T> List<T> convert(Class<T> clazz, Collection<DynamicObject> colls, boolean needQuery) {
        if (Objects.isNull(colls) || colls.isEmpty()) {
            return Collections.emptyList();
        }
        if (needQuery) {
            DynamicObject next = colls.iterator().next();
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])colls.stream().map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)next.getDataEntityType().getName()));
            colls = Arrays.asList(dynamicObjects);
        }
        Converter<T> converter = ConverterFactory.getConverter(clazz);
        return colls.stream().map(converter::convert).collect(Collectors.toList());
    }

    public static <T> List<T> convert(Class<T> clazz, Collection<DynamicObject> colls, boolean needQuery, String entityNumber) {
        if (Objects.isNull(colls) || colls.isEmpty()) {
            return Collections.emptyList();
        }
        if (needQuery) {
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])colls.stream().map(d -> d.get("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityNumber));
            colls = Arrays.asList(dynamicObjects);
        }
        Converter<T> converter = ConverterFactory.getConverter(clazz);
        return colls.stream().map(converter::convert).collect(Collectors.toList());
    }

    public static <T, S> T convert(Class<T> clazz, S source) {
        if (Objects.isNull(source)) {
            return null;
        }
        IConverter<T, ?> converter = ConverterFactory.getIConverter(clazz, source.getClass());
        return converter.convert(source);
    }

    public static <T, S> List<T> convertList(Class<T> clazz, List<S> source) {
        if (EmptyUtil.isEmpty(source)) {
            return Collections.emptyList();
        }
        S s = source.get(0);
        IConverter<T, ?> converter = ConverterFactory.getIConverter(clazz, s.getClass());
        return source.stream().map(converter::convert).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T, S> T convertWithArgs(Class<T> clazz, S source, Object ... args) {
        if (Objects.isNull(source)) {
            return null;
        }
        if (Objects.isNull(args) || args.length == 0) {
            return ConverterUtils.convert(clazz, source);
        }
        IConverter<T, ?> converter = ConverterFactory.getIConverterWithArgs(clazz, source.getClass(), args);
        return converter.convert(source);
    }

    public static <T, S> List<T> convertListWithArgs(Class<T> clazz, List<S> source, Object ... args) {
        if (EmptyUtil.isEmpty(source)) {
            return Collections.emptyList();
        }
        if (Objects.isNull(args) || args.length == 0) {
            return ConverterUtils.convertList(clazz, source);
        }
        S s = source.get(0);
        IConverter<T, ?> converter = ConverterFactory.getIConverterWithArgs(clazz, s.getClass(), args);
        return source.stream().map(converter::convert).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

