/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.exception.match;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.match.MatchInfo;

public class MatchException
extends KDBizException {
    private MatchInfo matchInfo;
    private List<Dimension> matchedDimension;
    private Dimension notMatchedDimension;
    private String errorMsg;
    private MatchErrorType matchErrorType;
    private boolean abort;

    public MatchException(MatchInfo matchInfo, String message) {
        this(matchInfo, message, MatchErrorType.MATCH_ERROR);
    }

    public MatchException(String message, MatchErrorType matchErrorType) {
        super(message);
        this.errorMsg = message;
        this.abort = true;
        this.matchErrorType = matchErrorType;
    }

    public MatchException(MatchInfo matchInfo, String message, MatchErrorType matchErrorType) {
        super(message);
        this.errorMsg = message;
        this.abort = true;
        this.matchErrorType = matchErrorType;
        this.matchInfo = matchInfo;
    }

    public MatchException(MatchInfo matchInfo, Dimension notMatchedDimension) {
        this(matchInfo, new ArrayList<Dimension>(4), notMatchedDimension, false);
    }

    public MatchException(MatchInfo matchInfo, Dimension notMatchedDimension, boolean abort) {
        this(matchInfo, new ArrayList<Dimension>(4), notMatchedDimension, abort);
    }

    public MatchException(MatchInfo matchInfo, List<Dimension> matchedDimension, Dimension notMatchedDimension, boolean abort) {
        super("");
        this.matchInfo = matchInfo;
        this.matchedDimension = matchedDimension;
        this.notMatchedDimension = notMatchedDimension;
        this.errorMsg = this.assembleErrorMsg();
        this.abort = abort;
        this.matchErrorType = MatchErrorType.MATCH_ERROR;
    }

    public MatchInfo getMatchInfo() {
        return this.matchInfo;
    }

    public void setMatchInfo(MatchInfo matchInfo) {
        this.matchInfo = matchInfo;
    }

    public List<Dimension> getMatchedDimension() {
        return this.matchedDimension;
    }

    public void setMatchedDimension(List<Dimension> matchedDimension) {
        this.matchedDimension = matchedDimension;
    }

    public Dimension getNotMatchedDimension() {
        return this.notMatchedDimension;
    }

    public void setNotMatchedDimension(Dimension notMatchedDimension) {
        this.notMatchedDimension = notMatchedDimension;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public KDBizException getKDBizException() {
        return new KDBizException(this.errorMsg);
    }

    public boolean isAbort() {
        return this.abort;
    }

    public void setAbort(boolean abort) {
        this.abort = abort;
    }

    public MatchErrorType getMatchErrorType() {
        return this.matchErrorType;
    }

    public void setMatchErrorType(MatchErrorType matchErrorType) {
        this.matchErrorType = matchErrorType;
    }

    private String assembleErrorMsg() {
        if (Objects.isNull(this.matchInfo)) {
            return "";
        }
        if (Objects.isNull(this.notMatchedDimension)) {
            return "";
        }
        FundPlanSystem fundPlanSystem = this.matchInfo.getFundPlanSystem();
        StringBuilder stringBuilder = new StringBuilder();
        BillBizInfo billBizInfo = this.matchInfo.getBillBizInfo();
        stringBuilder.append(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u3010%1$s\u3011\u4f7f\u7528\u4f53\u7cfb\u3010%2$s\u3011\u4e1a\u52a1\u53d6\u6570\u89c4\u5219\u3010%3$s\u3011\u5339\u914d\u4e0d\u5230\u7ef4\u5ea6\u3010%4$s\u3011", (String)"MatchException_0", (String)"tmc-fpm-business", (Object[])new Object[0]), billBizInfo.getBillNo(), fundPlanSystem.getName(), this.matchInfo.getMatchRule().getNumber(), this.notMatchedDimension.getName()));
        if (EmptyUtil.isNoEmpty(this.matchedDimension)) {
            stringBuilder.append(String.format(ResManager.loadKDString((String)"\u5df2\u5339\u914d\u5230\u7ef4\u5ea6\uff1a\u3010%1$s\u3011", (String)"MatchException_1", (String)"tmc-fpm-business", (Object[])new Object[0]), this.matchedDimension.stream().map(Dimension::getName).collect(Collectors.joining("/"))));
        }
        return stringBuilder.toString();
    }

    public static enum MatchErrorType {
        MATCH_ERROR,
        MATCH_NO_DATA,
        MATCH_MATCH_RULE,
        MATCH_OTIONAL_CONTROL,
        MATCH_DETAIL_CONTROL;


        public boolean isMatchError() {
            return this == MATCH_ERROR;
        }

        public boolean isMathNoData() {
            return this == MATCH_NO_DATA;
        }
    }
}

