/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.repository.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.service.IUpdateEntity;
import kd.tmc.fpm.business.mvc.converter.utils.ConverterUtils;
import kd.tmc.fpm.business.mvc.repository.impl.IBaseRepository;
import kd.tmc.fpm.business.utils.CommonUtils;

public class BaseRepository<T>
implements IBaseRepository<T> {
    protected static final Log logger = LogFactory.getLog(BaseRepository.class);

    @Override
    public void save(T t) {
        this.checkAndProcess(t, () -> {
            logger.info("\u4fdd\u5b58\u5bf9\u8c61\uff1a{}", t);
            DynamicObject dynamicObject = ConverterUtils.convert(DynamicObject.class, t);
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)dynamicObject.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess()) {
                throw new KDBizException(operationResult.getMessage());
            }
            return null;
        });
    }

    @Override
    public void saveAll(List<T> entities) {
        this.checkAndProcess(entities, () -> {
            logger.info("\u6279\u91cf\u4fdd\u5b58\u5bf9\u8c61\uff1a{}", CommonUtils.getSubListForSize(entities, 10));
            List<DynamicObject> dynamicObjectList = ConverterUtils.convertList(DynamicObject.class, entities);
            DynamicObject dynamicObject = dynamicObjectList.get(0);
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)dynamicObject.getDataEntityType().getName(), (DynamicObject[])dynamicObjectList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess()) {
                throw new KDBizException(operationResult.getMessage());
            }
            return null;
        });
    }

    @Override
    public void update(T t) {
        this.checkAndProcess(t, () -> {
            if (!(t instanceof IUpdateEntity)) {
                logger.info("\u5f85\u66f4\u65b0\u5bf9\u8c61\uff1a{}\u6ca1\u6709\u5b9e\u73b0IUpdateEntity\u63a5\u53e3", t);
                return null;
            }
            logger.info("\u66f4\u65b0\u5bf9\u8c61\uff1a{}", t);
            DynamicObject convert = ConverterUtils.convert(DynamicObject.class, t);
            DynamicObject dbObj = BusinessDataServiceHelper.loadSingle((Object)convert.getPkValue(), (String)convert.getDataEntityType().getName());
            Object dbT = ConverterUtils.convert(t.getClass(), dbObj);
            IUpdateEntity updateEntity = (IUpdateEntity)dbT;
            updateEntity.update(t);
            convert = ConverterUtils.convert(DynamicObject.class, dbT);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{convert});
            return null;
        });
    }

    @Override
    public void updateAll(List<T> entities) {
        this.checkAndProcess(entities, () -> {
            if (!(entities.get(0) instanceof IUpdateEntity)) {
                logger.info("\u6279\u91cf\u66f4\u65b0\u5f85\u66f4\u65b0\u7684\u5bf9\u8c61\uff1a{}\u6ca1\u6709\u5b9e\u73b0IUpdateEntity\u63a5\u53e3", entities.get(0).getClass());
                return null;
            }
            List<DynamicObject> dynamicObjectList = ConverterUtils.convertList(DynamicObject.class, entities);
            Object[] load = BusinessDataServiceHelper.load((Object[])dynamicObjectList.stream().map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)dynamicObjectList.get(0).getDataEntityType().getName()));
            if (EmptyUtil.isEmpty((Object[])load)) {
                return null;
            }
            Map dynamicObjectMap = Arrays.stream(load).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity(), (a, b) -> a));
            ArrayList<DynamicObject> dyList = new ArrayList<DynamicObject>(dynamicObjectMap.size());
            for (int i = 0; i < entities.size(); ++i) {
                DynamicObject dbObj = (DynamicObject)dynamicObjectMap.get(dynamicObjectList.get(i).getPkValue());
                Object t = entities.get(i);
                Object dbT = ConverterUtils.convert(t.getClass(), dbObj);
                IUpdateEntity updateEntity = (IUpdateEntity)dbT;
                updateEntity.update(t);
                dyList.add(ConverterUtils.convert(DynamicObject.class, dbT));
            }
            SaveServiceHelper.save((DynamicObject[])dyList.toArray(new DynamicObject[0]));
            return null;
        });
    }

    @Override
    public void delete(Long id, String entityName) {
        CommonUtils.inTransaction(() -> {
            logger.info("\u5220\u9664\uff1a{}\uff0cid\uff1a{}", (Object)entityName, (Object)id);
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityName), (Object[])new Object[]{id});
            return null;
        });
    }

    @Override
    public void deleteAll(Collection<Long> ids, String entityName) {
        CommonUtils.inTransaction(() -> {
            logger.info("\u6279\u91cf\u5220\u9664\uff1a{}\uff0cid\uff1a{}", (Object)entityName, (Object)ids);
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityName), (Object[])ids.toArray());
            return null;
        });
    }

    @Override
    public T loadSingle(Long id, String entityName, Class<T> clazz) {
        logger.info("\u67e5\u8be2\u5bf9\u8c61\uff1a{}\uff0cid:{}", (Object)entityName, (Object)id);
        return ConverterUtils.convert(clazz, BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName));
    }

    @Override
    public List<T> load(Collection<Long> ids, String entityName, Class<T> clazz) {
        logger.info("\u67e5\u8be2\u5bf9\u8c61\uff1a{}\uff0cids:{}", (Object)entityName, ids);
        return ConverterUtils.convertList(clazz, Arrays.stream(BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName))).collect(Collectors.toList()));
    }

    protected T checkAndProcess(Object o, Supplier<T> supplier) {
        if (EmptyUtil.isEmpty((Object)o)) {
            return null;
        }
        return CommonUtils.inTransaction(supplier);
    }
}

