/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.repository.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.ApplyReportOrg;
import kd.tmc.fpm.business.domain.model.control.BillControlTraceIdInfo;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.control.ControlExecTimeRule;
import kd.tmc.fpm.business.domain.model.control.ControlStrategy;
import kd.tmc.fpm.business.domain.model.control.ControlTime;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.control.ReportType;
import kd.tmc.fpm.business.domain.model.dimension.DimMemberMapping;
import kd.tmc.fpm.business.mvc.converter.BillMatchRuleConverter;
import kd.tmc.fpm.business.mvc.converter.ControlExecTimeConverter;
import kd.tmc.fpm.business.mvc.converter.PlanExecuteRecordConverter;
import kd.tmc.fpm.business.mvc.converter.utils.ConverterUtils;
import kd.tmc.fpm.business.mvc.repository.IControlRepository;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.utils.DataSetUtil;
import kd.tmc.fpm.business.utils.DynamicObjectUtils;
import kd.tmc.fpm.common.enums.MatchRuleFetchPurposeEnum;
import kd.tmc.fpm.common.property.ExecuteTimeProp;

public class ControlRepository
implements IControlRepository {
    private IDimensionRepository dimRepo = new DimensionRepository();
    private static Log logger = LogFactory.getLog(ControlRepository.class);

    @Override
    public BillMatchRule loadBillMatchRule(long id) {
        List<BillMatchRule> billMatchRules = this.loadBillMatchRule(Collections.singletonList(id));
        return EmptyUtil.isNoEmpty(billMatchRules) ? billMatchRules.get(0) : null;
    }

    @Override
    public List<BillMatchRule> loadControlMatchRule(String entityType) {
        return this.loadControlMatchRule(entityType, new Long[0]);
    }

    @Override
    public List<BillMatchRule> loadControlMatchRule(String entityType, boolean filterEnableSystem, Long ... systemIds) {
        Map matchRuleMap;
        QFilter qFilter = new QFilter("businessbill", "=", (Object)entityType).and("fetchpurpose", "=", (Object)MatchRuleFetchPurposeEnum.EXECUTE_CONTROL.getCode()).and("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
        if (filterEnableSystem) {
            qFilter.and("bodysys.enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
        }
        if (EmptyUtil.isNoEmpty((Object[])systemIds)) {
            qFilter.and("bodysys", "in", Arrays.asList(systemIds));
        }
        if ((matchRuleMap = TmcDataServiceHelper.loadFromCache((String)"fpm_matchrule", (QFilter[])qFilter.toArray())) == null || matchRuleMap.isEmpty()) {
            return Collections.emptyList();
        }
        return this.converterMatchRule(matchRuleMap.values().toArray(new DynamicObject[0]));
    }

    @Override
    public List<BillMatchRule> loadControlMatchRule(String entityType, Long ... systemIds) {
        return this.loadControlMatchRule(entityType, Boolean.FALSE, systemIds);
    }

    @Override
    public BillMatchRule loadPlanMatchRule(String entityType, Long systemId) {
        List<BillMatchRule> billMatchRules = this.loadPlanMatchRules(entityType, Collections.singletonList(systemId));
        return EmptyUtil.isNoEmpty(billMatchRules) ? billMatchRules.get(0) : null;
    }

    @Override
    public Set<Long> existPlanMatchRule(String entityType, Collection<Long> systemIds) {
        DynamicObjectCollection matchRuleDyColl = QueryServiceHelper.query((String)"fpm_matchrule", (String)"id,bodysys.id", (QFilter[])this.getPlanReportFilters(entityType, systemIds));
        return matchRuleDyColl.stream().map(dy -> dy.getLong("bodysys.id")).collect(Collectors.toSet());
    }

    @Override
    public List<BillMatchRule> loadPlanMatchRules(String entityType, Collection<Long> systemIds) {
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"fpm_matchrule", (QFilter[])this.getPlanReportFilters(entityType, systemIds), null, (int)-1);
        if (EmptyUtil.isEmpty((Collection)ids)) {
            return null;
        }
        DynamicObject[] dbDataArray = TmcDataServiceHelper.loadFromCache((Object[])ids.toArray(), (String)"fpm_matchrule").values().toArray(new DynamicObject[0]);
        return this.converterMatchRule(dbDataArray);
    }

    private QFilter[] getPlanReportFilters(String entityType, Collection<Long> systemIds) {
        return new QFilter("businessbill", "=", (Object)entityType).and("fetchpurpose", "=", (Object)MatchRuleFetchPurposeEnum.PLAN_REPORT.getCode()).and("bodysys", "in", systemIds).and("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue()).toArray();
    }

    @Override
    public List<BillMatchRule> loadBillMatchRule(List<Long> idList) {
        DynamicObject[] matchRules = TmcDataServiceHelper.loadFromCache((Object[])idList.toArray(), (String)"fpm_matchrule").values().toArray(new DynamicObject[0]);
        return this.converterMatchRule(matchRules);
    }

    private List<BillMatchRule> converterMatchRule(DynamicObject[] matchRules) {
        ArrayList<Long> memberIds = new ArrayList<Long>(10);
        for (DynamicObject matchRule : matchRules) {
            DynamicObjectCollection matchRuleMappingEntrys = matchRule.getDynamicObjectCollection("entryentity");
            for (DynamicObject matchRuleMappingEntry : matchRuleMappingEntrys) {
                Long memberId = matchRuleMappingEntry.getLong(String.join((CharSequence)".", "entry_dimensionmembermap", "id"));
                if (EmptyUtil.isEmpty((Long)memberId)) continue;
                memberIds.add(memberId);
            }
        }
        List<DimMemberMapping> memberMappings = this.dimRepo.loadDimMemberMapping(memberIds);
        Map<Long, List<DimMemberMapping>> memberMappingInfoMaps = memberMappings.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(o -> o.getId()));
        return BillMatchRuleConverter.batchConvertToBillMatchRule(matchRules, memberMappingInfoMaps);
    }

    @Override
    public PlanExecuteRecord loadPlanExecuteRecord(Long id) {
        DynamicObject executeRecordDO = TmcDataServiceHelper.loadSingle((Object)id, (String)"fpm_executeplan");
        return PlanExecuteRecordConverter.converterToExecuteRecord(executeRecordDO);
    }

    @Override
    public List<PlanExecuteRecord> loadPlanExecuteRecords(Collection<Long> ids) {
        Object[] load = TmcDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_executeplan"));
        if (EmptyUtil.isEmpty((Object[])load)) {
            return Collections.emptyList();
        }
        return Arrays.stream(load).map(PlanExecuteRecordConverter::converterToExecuteRecord).collect(Collectors.toList());
    }

    @Override
    public Set<Long> loadControlTraceIdsByRecordIds(List<Long> recordIds) {
        String selectFields = String.join((CharSequence)"id", "controltraceid");
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"fpm_executeplan", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", recordIds)});
        return dynamicObjectCollection.stream().map(dy -> dy.getLong("controltraceid")).collect(Collectors.toSet());
    }

    @Override
    public List<PlanExecuteRecord> loadPlanExecuteRecord(List<Long> entityIds, String entityType) {
        return this.loadPlanExecuteRecord(entityIds, entityType, null);
    }

    @Override
    public List<PlanExecuteRecord> loadPlanExecuteRecord(List<Long> entityIds, String entityType, String version) {
        List idColl;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(4);
        qFilterList.add(new QFilter("bizbillid", "in", entityIds));
        qFilterList.add(new QFilter("billbizetype", "=", (Object)entityType));
        qFilterList.add(new QFilter("deleteflag", "=", (Object)"0"));
        if (version != null) {
            qFilterList.add(new QFilter("version", "=", (Object)version));
        }
        if (EmptyUtil.isEmpty((Collection)(idColl = QueryServiceHelper.queryPrimaryKeys((String)"fpm_executeplan", (QFilter[])qFilterList.toArray(new QFilter[0]), null, (int)-1)))) {
            return null;
        }
        List idList = idColl.stream().map(item -> (Long)item).collect(Collectors.toList());
        DynamicObject[] executeRecordDOArr = TmcDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_executeplan"));
        return PlanExecuteRecordConverter.converterToExecuteRecord(Arrays.asList(executeRecordDOArr));
    }

    @Override
    public List<PlanExecuteRecord> loadPlanExecuteRecordBySystem(List<Long> entityIds, String entityType, Set<Long> systemIdS) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(4);
        qFilterList.add(new QFilter("bizbillid", "in", entityIds));
        qFilterList.add(new QFilter("billbizetype", "=", (Object)entityType));
        qFilterList.add(new QFilter("deleteflag", "=", (Object)"0"));
        qFilterList.add(new QFilter("bodysys.id", "in", systemIdS));
        List idColl = QueryServiceHelper.queryPrimaryKeys((String)"fpm_executeplan", (QFilter[])qFilterList.toArray(new QFilter[0]), null, (int)-1);
        if (EmptyUtil.isEmpty((Collection)idColl)) {
            return null;
        }
        List idList = idColl.stream().map(item -> (Long)item).collect(Collectors.toList());
        DynamicObject[] executeRecordDOArr = TmcDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_executeplan"));
        return PlanExecuteRecordConverter.converterToExecuteRecord(Arrays.asList(executeRecordDOArr));
    }

    @Override
    public List<PlanExecuteRecord> loadPlanExecuteRecordBySystem(Collection<Long> entityIds, Collection<String> entityTypes, Set<Long> systemIdS) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(4);
        qFilterList.add(new QFilter("bizbillid", "in", entityIds));
        qFilterList.add(new QFilter("billbizetype", "in", entityTypes));
        qFilterList.add(new QFilter("deleteflag", "=", (Object)"0"));
        qFilterList.add(new QFilter("bodysys.id", "in", systemIdS));
        List idColl = QueryServiceHelper.queryPrimaryKeys((String)"fpm_executeplan", (QFilter[])qFilterList.toArray(new QFilter[0]), null, (int)-1);
        if (idColl.isEmpty()) {
            return Collections.emptyList();
        }
        List idList = idColl.stream().map(item -> (Long)item).collect(Collectors.toList());
        DynamicObject[] executeRecordDOArr = TmcDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_executeplan"));
        return PlanExecuteRecordConverter.converterToExecuteRecord(Arrays.asList(executeRecordDOArr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BillControlTraceIdInfo> loadControlTraceIdByBillInfo(Collection<Long> entityIds, Collection<String> entityTypes) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(4);
        qFilterList.add(new QFilter("bizbillid", "in", entityIds));
        qFilterList.add(new QFilter("billbizetype", "in", entityTypes));
        qFilterList.add(new QFilter("deleteflag", "=", (Object)false));
        String selectFields = String.join((CharSequence)",", "controltraceid", "bizbillid", "billbizetype");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"loadControlTraceIdByBillInfo", (String)"fpm_executeplan", (String)selectFields, (QFilter[])qFilterList.toArray(new QFilter[0]), null);
        HashMap<String, BillControlTraceIdInfo> billControlTraceIdInfoMap = new HashMap<String, BillControlTraceIdInfo>(4);
        HashSet<Long> billIds = new HashSet<Long>(8);
        try {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                long billId = row.getLong("bizbillid");
                if (!billIds.add(billId)) continue;
                String entityType = row.getString("billbizetype");
                long controlTraceId = row.getLong("controltraceid");
                String key = String.join((CharSequence)"#", entityType, String.valueOf(billId));
                billControlTraceIdInfoMap.computeIfAbsent(key, k -> new BillControlTraceIdInfo(0L, billId, entityType, controlTraceId));
            }
        }
        catch (Throwable throwable) {
            DataSetUtil.closeDataSet(dataSet);
            throw throwable;
        }
        DataSetUtil.closeDataSet(dataSet);
        return new ArrayList<BillControlTraceIdInfo>(billControlTraceIdInfoMap.values());
    }

    @Override
    public int[] deletePlanExecuteRecord(List<Long> ids) {
        DynamicObject[] executeRecordDOArr;
        for (DynamicObject dynamicObject : executeRecordDOArr = TmcDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_executeplan"))) {
            dynamicObject.set("deleteflag", (Object)"1");
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])executeRecordDOArr);
            }
            catch (Exception e) {
                h.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        return new int[0];
    }

    @Override
    public List<Long> savePlanExecuteRecord(List<PlanExecuteRecord> planExecuteRecords) {
        List<DynamicObject> dynamicObjectList = PlanExecuteRecordConverter.converterToDO(planExecuteRecords);
        List<Long> idList = null;
        try (TXHandle h = TX.required();){
            try {
                Object[] save = SaveServiceHelper.save((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[0]));
                idList = Arrays.stream(save).map(item -> ((DynamicObject)item).getLong("id")).collect(Collectors.toList());
            }
            catch (Exception e) {
                h.markRollback();
                logger.error("\u4fdd\u5b58\u6267\u884c\u8bb0\u5f55\u5f02\u5e38", (Throwable)e);
                throw e;
            }
        }
        return idList;
    }

    @Override
    public List<ControlStrategy> loadStrategy(Long systemId, boolean filterDisabled) {
        return this.loadStrategy(Collections.singleton(systemId), true);
    }

    @Override
    public List<ControlStrategy> loadStrategy(Set<Long> systemIds, boolean filterDisabled) {
        QFilter qFilter = new QFilter("bodysys", "in", systemIds);
        if (filterDisabled) {
            qFilter.and("enable", "=", (Object)"1");
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"fpm_controlwayconfig", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return ConverterUtils.convert(ControlStrategy.class, (Collection<DynamicObject>)dynamicObjects, true, "fpm_controlwayconfig");
    }

    @Override
    public ControlStrategy loadStrategy(Long systemId, Long reportTypeId, Long reportOrgId, boolean filterDisabled) {
        logger.info("\u4f53\u7cfbid\uff1a{}\uff0c\u7f16\u62a5\u7c7b\u578bid\uff1a{}\uff0c\u7f16\u62a5\u4e3b\u4f53id\uff1a{}", new Object[]{systemId, reportTypeId, reportOrgId});
        List<ControlStrategy> controlStrategies = this.loadStrategy(systemId, filterDisabled);
        if (CollectionUtils.isEmpty(controlStrategies)) {
            return null;
        }
        ControlStrategy defaultControlStrategy = controlStrategies.stream().filter(controlStrategy -> CollectionUtils.isEmpty(controlStrategy.getApplyReportOrgs())).filter(controlStrategy -> Objects.nonNull(controlStrategy.getReportType())).filter(controlStrategy -> controlStrategy.getReportType().stream().map(ReportType::getId).collect(Collectors.toSet()).contains(reportTypeId)).findFirst().orElse(null);
        return controlStrategies.stream().filter(controlStrategy -> Objects.nonNull(controlStrategy.getReportType())).filter(controlStrategy -> controlStrategy.getReportType().stream().map(ReportType::getId).collect(Collectors.toSet()).contains(reportTypeId)).filter(controlStrategy -> Objects.nonNull(controlStrategy.getApplyReportOrgs())).filter(controlStrategy -> controlStrategy.getApplyReportOrgs().stream().map(ApplyReportOrg::getReportOrgId).collect(Collectors.toSet()).contains(reportOrgId)).findFirst().orElse(defaultControlStrategy);
    }

    @Override
    public List<ControlTime> loadControlTime(Long systemId, boolean filterDisabled) {
        return this.loadControlTimes(Collections.singletonList(systemId), filterDisabled);
    }

    @Override
    public List<ControlTime> loadControlTimes(Collection<Long> systemIds, boolean filterDisabled) {
        QFilter qFilter = new QFilter("bodysys", "in", systemIds);
        if (filterDisabled) {
            qFilter.and("enable", "=", (Object)"1");
        }
        Map executeTimeMap = TmcDataServiceHelper.loadFromCache((String)"fpm_executetime", (QFilter[])qFilter.toArray());
        return ConverterUtils.convert(ControlTime.class, executeTimeMap.values(), Boolean.FALSE, "fpm_executetime");
    }

    @Override
    public List<PlanExecuteRecord> loadRelatePlanExecuteRecord(List<Long> ids) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(4);
        qFilterList.add(new QFilter("relaterecordid", "in", ids));
        qFilterList.add(new QFilter("deleteflag", "=", (Object)"0"));
        List idColl = QueryServiceHelper.queryPrimaryKeys((String)"fpm_executeplan", (QFilter[])qFilterList.toArray(new QFilter[0]), null, (int)-1);
        if (idColl.isEmpty()) {
            return Collections.emptyList();
        }
        List idList = idColl.stream().map(item -> (Long)item).collect(Collectors.toList());
        DynamicObject[] executeRecordDOArr = TmcDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_executeplan"));
        return PlanExecuteRecordConverter.converterToExecuteRecord(Arrays.asList(executeRecordDOArr));
    }

    @Override
    public List<PlanExecuteRecord> loadPlanExecuteRecords(List<Long> ids) {
        DynamicObject[] executeRecordDOArr = TmcDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_executeplan"));
        if (Objects.isNull(executeRecordDOArr) || executeRecordDOArr.length == 0) {
            return Collections.emptyList();
        }
        return PlanExecuteRecordConverter.converterToExecuteRecord(Arrays.asList(executeRecordDOArr));
    }

    @Override
    public List<ControlExecTimeRule> queryControlExecTimeRule() {
        return this.queryControlExecTimeRule(Collections.emptyList());
    }

    @Override
    public List<ControlExecTimeRule> queryControlExecTimeRule(Collection<Long> excludeSystemIds) {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        List queryPrimaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"fpm_bodysysmanage", (QFilter[])new QFilter[]{qFilter}, null, (int)-1);
        queryPrimaryKeys.removeAll(excludeSystemIds);
        QFilter qFilter1 = new QFilter("bodysys", "in", (Object)queryPrimaryKeys);
        ArrayList<String> queryRuleProps = new ArrayList<String>(ExecuteTimeProp.QUERY_RULE_PROPS);
        queryRuleProps.add(String.format("%s.%s.%s", "entryentity_actual", "entry_aclbusinessbill", "number"));
        queryRuleProps.add(String.format("%s.%s.%s", "entryentity_actual", "entry_aclbusinessbill", "name"));
        String selectFields = String.join((CharSequence)",", queryRuleProps);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"fpm_executetime", (String)selectFields, (QFilter[])new QFilter[]{qFilter1});
        List<DynamicObject> list = DynamicObjectUtils.reStoreDynamicObject((List<DynamicObject>)dynamicObjectCollection, "fpm_executetime");
        return ControlExecTimeConverter.batchConverterControlExecTimeRule(list.toArray(new DynamicObject[0]));
    }

    @Override
    public List<Long> writeControlExecTimeService(List<ControlExecTimeRule> controlExecTimeRules) {
        List<DynamicObject> bizRuleDyLst = ControlExecTimeConverter.converterToDO(controlExecTimeRules);
        List<Long> idList = null;
        try (TXHandle h = TX.requiresNew();){
            try {
                OperationResult saveResult = TmcOperateServiceHelper.execOperate((String)"save", (String)"bos_opbizruleset", (DynamicObject[])bizRuleDyLst.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                List successPkIds = saveResult.getSuccessPkIds();
                idList = successPkIds.stream().map(item -> (Long)item).collect(Collectors.toList());
            }
            catch (Exception e) {
                h.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        return idList;
    }
}

