/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.repository.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.mvc.converter.DimensionPOConverter;
import kd.tmc.fpm.business.mvc.repository.IDetailPlanFieldsRepository;
import kd.tmc.fpm.business.utils.FpmDataServiceHelper;
import kd.tmc.fpm.common.property.DetailPlanFieldsProp;

public class DetailPlanFieldsRepository
implements IDetailPlanFieldsRepository {
    @Override
    public List<Dimension> queryDetailDimenBySystemId(Set<Long> systemIds) {
        if (EmptyUtil.isEmpty(systemIds)) {
            return Collections.emptyList();
        }
        QFilter[] filters = new QFilter("bodysys", "in", systemIds).toArray();
        Map detailDimMap = TmcDataServiceHelper.loadFromCache((String)"fpm_detailplanfields", (String)DetailPlanFieldsProp.CONVERT_FIELDS, (QFilter[])filters);
        if (detailDimMap != null && !detailDimMap.isEmpty()) {
            return DimensionPOConverter.convertToDetailDimension(detailDimMap.values().toArray(new DynamicObject[0]));
        }
        return Collections.emptyList();
    }

    @Override
    public Map<Long, List<Dimension>> getDetailDimensionGroupBySystemId(Set<Long> systemIds) {
        List<Dimension> dimensions = this.queryDetailDimenBySystemId(systemIds);
        return dimensions.stream().collect(Collectors.groupingBy(Dimension::getSystemId));
    }

    @Override
    public Map<Object, DynamicObject> loadFromCache(String selectProps, QFilter[] filters) {
        return FpmDataServiceHelper.loadFromCache("fpm_detailplanfields", selectProps, filters);
    }
}

