/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.repository.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.mvc.converter.MemberConverterFactory;
import kd.tmc.fpm.business.mvc.converter.member.IMemberConverter;
import kd.tmc.fpm.business.mvc.repository.IDimMemberRepository;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.MetricMemberTypeEnum;
import kd.tmc.fpm.common.property.MetricMemberProp;
import kd.tmc.fpm.common.property.OrgMemProp;
import kd.tmc.fpm.common.property.PeriodMemberProp;

public class DimMemberRepository
implements IDimMemberRepository {
    @Override
    public Map<Long, List<DimMember>> getPeriodDimMembers(List<Long> systemIds) {
        HashMap<Long, List<DimMember>> map = new HashMap<Long, List<DimMember>>(systemIds.size());
        if (EmptyUtil.isEmpty(systemIds)) {
            return map;
        }
        QFilter qFilter = new QFilter("bodysystem", "in", systemIds).and("dimtype", "=", (Object)DimsionEnums.PERIOD.getNumber());
        DynamicObjectCollection dimMembers = QueryServiceHelper.query((String)DimsionEnums.PERIOD.getMetadata(), (String)PeriodMemberProp.CONVERT_FILEDS, (QFilter[])qFilter.toArray());
        Map<Long, List<DynamicObject>> dimMemberMap = dimMembers.stream().collect(Collectors.groupingBy(d -> d.getLong("bodysystem.id")));
        IMemberConverter memberConverter = MemberConverterFactory.createMemberConverterByDimType(DimensionType.PERIOD);
        for (Map.Entry<Long, List<DynamicObject>> entry : dimMemberMap.entrySet()) {
            map.put(entry.getKey(), memberConverter.convertToMemberTree(entry.getValue()));
        }
        systemIds.forEach(d -> map.putIfAbsent((Long)d, Collections.emptyList()));
        return map;
    }

    @Override
    public Map<Long, DimMember> getOrgDimMembers(List<Long> reportOrgIds) {
        HashMap<Long, DimMember> map = new HashMap<Long, DimMember>(8);
        if (EmptyUtil.isEmpty(reportOrgIds)) {
            return map;
        }
        Map dimMembersMap = TmcDataServiceHelper.loadFromCache((String)"fpm_member", (String)OrgMemProp.CONVERT_FILEDS, (QFilter[])new QFilter("id", "in", reportOrgIds).toArray());
        IMemberConverter orgMemberConverter = MemberConverterFactory.createMemberConverterByDimType(DimensionType.ORG);
        for (DynamicObject dimMember : dimMembersMap.values()) {
            map.put(dimMember.getLong("id"), orgMemberConverter.convertToMember(dimMember));
        }
        return map;
    }

    @Override
    public DynamicObject[] loadMetricDimMembers(List<Long> systemIds) {
        if (EmptyUtil.isEmpty(systemIds)) {
            return new DynamicObject[0];
        }
        Map memberMap = TmcDataServiceHelper.loadFromCache((String)"fpm_member", (QFilter[])this.getMetricDimFilter(systemIds));
        return memberMap.values().toArray(new DynamicObject[0]);
    }

    @Override
    public DynamicObjectCollection queryMetricDimMembers(List<Long> systemIds) {
        return QueryServiceHelper.query((String)"fpm_member", (String)MetricMemberProp.CONVERT_FILEDS, (QFilter[])this.getMetricDimFilter(systemIds));
    }

    private QFilter[] getMetricDimFilter(List<Long> systemIds) {
        Set metricCodeSet = Arrays.stream(TemplateMetricType.values()).filter(tm -> tm != TemplateMetricType.CUSTOM).map(TemplateMetricType::getCode).collect(Collectors.toSet());
        return new QFilter("metricpresettype", "in", metricCodeSet).and("bodysystem", "in", systemIds).and("preset", "=", (Object)Boolean.TRUE).and("dimtype", "=", (Object)DimensionType.METRIC.getNumber()).toArray();
    }

    @Override
    public DynamicObjectCollection queryMetricDimMembers(Collection<Long> memberIds, Collection<Long> systemIds) {
        QFilter qFilter = null;
        if (!EmptyUtil.isEmpty(memberIds)) {
            qFilter = new QFilter("id", "in", memberIds);
        } else if (!EmptyUtil.isEmpty(systemIds)) {
            qFilter = new QFilter("dimtype", "=", (Object)DimensionType.METRIC.getNumber()).and("bodysystem", "in", systemIds).and("metrictype", "=", (Object)MetricMemberTypeEnum.BASE.getValue());
        } else {
            return null;
        }
        return QueryServiceHelper.query((String)"fpm_member", (String)MetricMemberProp.CONVERT_FILEDS, (QFilter[])qFilter.toArray());
    }

    @Override
    public Map<Long, List<DynamicObject>> queryDimMemberByDimesion(List<Long> dimensionIds) {
        if (EmptyUtil.isEmpty(dimensionIds)) {
            return new HashMap<Long, List<DynamicObject>>(0);
        }
        QFilter qFilter = new QFilter("dimension", "in", dimensionIds);
        Map memberArrMap = TmcDataServiceHelper.loadFromCache((String)"fpm_member", (QFilter[])qFilter.toArray());
        Map<Long, List<DynamicObject>> map = memberArrMap.values().stream().collect(Collectors.groupingBy(item -> item.getLong("dimension.id")));
        dimensionIds.forEach(d -> map.putIfAbsent((Long)d, Collections.emptyList()));
        return map;
    }
}

