/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.repository.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.DimMemberMapping;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.template.AuxiliaryField;
import kd.tmc.fpm.business.mvc.converter.DimensionPOConverter;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.AuxiliaryFieldsRepository;
import kd.tmc.fpm.business.mvc.repository.impl.BodySystemRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DetailPlanFieldsRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimMemberRepository;
import kd.tmc.fpm.business.utils.FpmDataServiceHelper;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.property.DimensionProp;

public class DimensionRepository
implements IDimensionRepository {
    @Override
    public FundPlanSystem loadSystem(long systemId) {
        List<FundPlanSystem> systemList = this.loadSystems(Collections.singleton(systemId));
        return !systemList.isEmpty() ? systemList.get(0) : null;
    }

    @Override
    public List<FundPlanSystem> loadSystems(Set<Long> systemIds) {
        ArrayList<FundPlanSystem> systemList = new ArrayList<FundPlanSystem>(systemIds.size());
        Map<Object, DynamicObject> fundSystemsMap = new BodySystemRepository().loadBodySystems(systemIds);
        ArrayList<Dimension> dimList = new ArrayList<Dimension>();
        dimList.addAll(this.loadMainDimensionBySystem(systemIds));
        dimList.addAll(new DetailPlanFieldsRepository().queryDetailDimenBySystemId(systemIds));
        List<AuxiliaryField> auxiliaryFields = AuxiliaryFieldsRepository.getAuxiliaryFieldBySystemId(systemIds);
        for (Map.Entry<Object, DynamicObject> entry : fundSystemsMap.entrySet()) {
            long systemId = (Long)entry.getKey();
            DynamicObject fundSystem = entry.getValue();
            List<Dimension> dimensions = dimList.stream().filter(d -> d.getSystemId().equals(systemId)).collect(Collectors.toList());
            FundPlanSystem system = DimensionPOConverter.convertToSystem(fundSystem, dimensions);
            system.setAuxiliaryFieldList(auxiliaryFields.stream().filter(a -> a.getSystemId().equals(systemId)).collect(Collectors.toList()));
            systemList.add(system);
        }
        return systemList;
    }

    private List<Dimension> loadMainDimensionBySystem(Set<Long> systemIds) {
        return this.loadDimensions(new QFilter("bodysystem", "in", systemIds));
    }

    @Override
    public Dimension loadDimension(long dimensionId, DimensionType dimType) {
        Dimension dimension;
        if (dimType == DimensionType.DETAILDIM) {
            DynamicObject detailPlanFields = FpmDataServiceHelper.loadSingleFromCache("fpm_detailplanfields", "id, entryentity", new QFilter("entryentity", "=", (Object)dimensionId).toArray());
            dimension = DimensionPOConverter.convertToDetailDimension(detailPlanFields, dimensionId);
        } else {
            DynamicObject mainDimension = FpmDataServiceHelper.loadSingleFromCache(dimensionId, "fpm_dimension");
            String dimensionType = mainDimension.getString("basedata");
            DimsionEnums dimensionEnum = DimsionEnums.getDimsionByNumber((String)dimensionType);
            QFilter qFilter = new QFilter("dimension", "=", mainDimension.getPkValue()).and("bodysystem", "=", (Object)mainDimension.getLong("bodysystem.id"));
            Map<Object, DynamicObject> memberArrMap = FpmDataServiceHelper.loadFromCache(dimensionEnum.getMetadata(), qFilter.toArray());
            dimension = DimensionPOConverter.convertToMainDimension(mainDimension, new ArrayList<DynamicObject>(memberArrMap.values()));
        }
        return dimension;
    }

    @Override
    public List<Dimension> loadMainDimensionBySystemId(long systemId, DimensionType dimType) {
        QFilter qFilter = new QFilter("bodysystem", "=", (Object)systemId);
        qFilter.and(new QFilter("basedata", "=", (Object)dimType.getNumber()));
        return this.loadDimensions(qFilter);
    }

    @Override
    public List<Dimension> loadDimensions(long systemId) {
        return this.loadDimensionsBySystemId(Collections.singleton(systemId));
    }

    @Override
    public List<Dimension> loadDimensionsBySystemId(Set<Long> systemIds) {
        return this.loadMainDimensionBySystem(systemIds);
    }

    @Override
    public List<Dimension> loadMainDimension(List<Long> dimensionIdS) {
        return this.loadDimensions(new QFilter("id", "in", dimensionIdS));
    }

    private List<Dimension> loadDimensions(QFilter qFilter) {
        Map<Object, DynamicObject> dimensionMap = FpmDataServiceHelper.loadFromCache("fpm_dimension", DimensionProp.allSelectProp, qFilter.toArray());
        if (dimensionMap == null || dimensionMap.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Dimension> result = new ArrayList<Dimension>(dimensionMap.size());
        List<Long> dimensionIds = dimensionMap.keySet().stream().map(item -> (Long)item).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> memberArrMap = new DimMemberRepository().queryDimMemberByDimesion(dimensionIds);
        for (DynamicObject mainDim : dimensionMap.values()) {
            List<DynamicObject> memberList = memberArrMap.get(mainDim.getLong("id"));
            result.add(DimensionPOConverter.convertToMainDimension(mainDim, memberList));
        }
        return result;
    }

    @Override
    public Dimension saveDimension(Dimension dimension) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<DimMemberMapping> loadDimMemberMapping(List<Long> ids) {
        DynamicObject[] dbDataArr = TmcDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_dimensionmember"));
        List dynamicObjectList = Arrays.stream(dbDataArr).filter(dy -> dy.getBoolean("enable")).collect(Collectors.toList());
        ArrayList<DimMemberMapping> result = new ArrayList<DimMemberMapping>(dbDataArr.length);
        for (DynamicObject dbData : dynamicObjectList) {
            result.add(DimensionPOConverter.convertToDimMemberMapping(dbData));
        }
        return result;
    }

    @Override
    public Map<Object, DynamicObject> loadFromCache(String selectProps, QFilter[] filters) {
        return FpmDataServiceHelper.loadFromCache("fpm_dimension", selectProps, filters);
    }
}

