/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.repository.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.mvc.repository.IReportPlanRepository;
import kd.tmc.fpm.business.spread.formula.FormulaManagerFactory;
import kd.tmc.fpm.business.spread.formula.IFormulaManager;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;

public class ReportPlanRepository
implements IReportPlanRepository,
Serializable {
    private Long reportId;
    private String pageId;
    private Integer currIndex;
    private Map<String, Integer> pageDimAndIndexMap;
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ReportPlanRepository");
    private Set<String> allRedisKeys = new HashSet<String>(10);
    private static final Log logger = LogFactory.getLog(ReportPlanRepository.class);

    public ReportPlanRepository() {
    }

    public ReportPlanRepository(Long reportId, String pageId) {
        this.reportId = reportId;
        this.currIndex = -1;
        this.pageId = pageId;
        this.pageDimAndIndexMap = new HashMap<String, Integer>();
    }

    @Override
    public ReportCalcModel getReportCalcModelByPageDim(List<Long> pageDimS) {
        String key = this.getDimCompStr(pageDimS);
        Integer index = this.pageDimAndIndexMap.get(key);
        if (index == null) {
            return null;
        }
        this.currIndex = index;
        ReportCalcModel reportCalcModel = this.buildCurrReportCalcModel(index);
        return reportCalcModel;
    }

    @Override
    public List<ReportCalcModel> getAllCalcModel() {
        List indexs = this.pageDimAndIndexMap.entrySet().stream().filter(Objects::nonNull).map(o -> (Integer)o.getValue()).sorted().collect(Collectors.toList());
        if (EmptyUtil.isEmpty(indexs)) {
            return null;
        }
        ArrayList<ReportCalcModel> reportCalcModelList = new ArrayList<ReportCalcModel>(indexs.size());
        for (Integer index : indexs) {
            ReportCalcModel reportCalcModel = this.buildCurrReportCalcModel(index);
            reportCalcModelList.add(reportCalcModel);
        }
        return reportCalcModelList;
    }

    @Override
    public List<ReportCalcVal> getCurrRowData(int row) {
        String redisKeyOfCurrRow = this.getRedisKey(String.format("datadim.%srow", row), this.currIndex, false);
        return this.getDimDataFormCache(redisKeyOfCurrRow);
    }

    @Override
    public ReportCalcVal getCurrRowColData(int row, int col) {
        List<ReportCalcVal> currRowDataLst = this.getCurrRowData(row);
        ReportCalcVal reportCalcVal = currRowDataLst.stream().filter(Objects::nonNull).filter(calcVal -> calcVal.getCol() == col).findFirst().map(o -> o).orElseGet(() -> null);
        return reportCalcVal;
    }

    @Override
    public IFormulaManager getFormulaManager() {
        String formulaManagerRedisKey = this.getRedisKey("formula.manager", this.currIndex, false);
        String formulaManagerJson = (String)cache.get(formulaManagerRedisKey);
        IFormulaManager iFormulaManager = FormulaManagerFactory.fromSerializeString(formulaManagerJson);
        return iFormulaManager;
    }

    @Override
    public ReportTemplate getReportTemplate() {
        String reportTempRedisKey = this.getRedisKey("report.template", null, true);
        String reportTempJson = (String)cache.get(reportTempRedisKey);
        return (ReportTemplate)FpmSerializeUtil.deserialize((String)reportTempJson, ReportTemplate.class);
    }

    @Override
    public FundPlanSystem getSystem() {
        String systemRedisKey = this.getRedisKey("fundplansystem", null, true);
        String fundSystemJson = (String)cache.get(systemRedisKey);
        return (FundPlanSystem)FpmSerializeUtil.deserialize((String)fundSystemJson, FundPlanSystem.class);
    }

    @Override
    public void saveReportCalcModel(ReportCalcModel reportCalcModel) {
        List<Long> dimValList = reportCalcModel.getPageDimValList().stream().filter(Objects::nonNull).map(o -> Long.valueOf(o.getValue().toString())).collect(Collectors.toList());
        String key = this.getDimCompStr(dimValList);
        Integer index = this.pageDimAndIndexMap.get(key);
        this.currIndex = index == null ? Integer.valueOf(this.currIndex + 1) : index;
        String pageRedisKey = this.getRedisKey("pagedim", this.currIndex, false);
        List<String> pageDimJsons = reportCalcModel.getPageDimValList().stream().filter(Objects::nonNull).map(val -> FpmSerializeUtil.serialize((Object)val)).collect(Collectors.toList());
        cache.remove(pageRedisKey);
        this.setRedisCacheOfList(pageRedisKey, "saveReportCalcModel-pageDim", pageDimJsons.toArray(new String[0]));
        String rowRedisKey = this.getRedisKey("rowdim", this.currIndex, false);
        List<String> rowDimJsons = reportCalcModel.getRowDimValList().stream().filter(Objects::nonNull).map(val -> FpmSerializeUtil.serialize((Object)val)).collect(Collectors.toList());
        cache.remove(rowRedisKey);
        this.setRedisCacheOfList(rowRedisKey, "saveReportCalcModel-rowDim", rowDimJsons.toArray(new String[0]));
        String colRedisKey = this.getRedisKey("coldim", this.currIndex, false);
        List<String> colDimJsons = reportCalcModel.getColDimValList().stream().filter(Objects::nonNull).map(val -> FpmSerializeUtil.serialize((Object)val)).collect(Collectors.toList());
        cache.remove(colRedisKey);
        this.setRedisCacheOfList(colRedisKey, "saveReportCalcModel-colDim", colDimJsons.toArray(new String[0]));
        List<ReportCalcVal> dataCalcValLst = reportCalcModel.getDataValList();
        Map<Integer, List<ReportCalcVal>> reportCalcValsByRow = dataCalcValLst.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(o -> o.getRow()));
        Set<Map.Entry<Integer, List<ReportCalcVal>>> reportCalcValsByRowSet = reportCalcValsByRow.entrySet();
        ArrayList<String> cacheOfRowDataCacheKeys = new ArrayList<String>(reportCalcValsByRowSet.size());
        for (Map.Entry<Integer, List<ReportCalcVal>> reportCalcValsEntry : reportCalcValsByRowSet) {
            Integer row = reportCalcValsEntry.getKey();
            List<ReportCalcVal> reportCalcValsOfRow = reportCalcValsEntry.getValue();
            String redisKeyOfCurrRow = this.getRedisKey(String.format("datadim.%srow", row), this.currIndex, false);
            cacheOfRowDataCacheKeys.add(redisKeyOfCurrRow);
            List<String> cacheDatas = reportCalcValsOfRow.stream().filter(Objects::nonNull).map(val -> FpmSerializeUtil.serialize((Object)val)).collect(Collectors.toList());
            cache.remove(redisKeyOfCurrRow);
            this.setRedisCacheOfList(redisKeyOfCurrRow, "saveReportCalcModel", cacheDatas.toArray(new String[0]));
        }
        String allRowKey = this.getRedisKey("allrowkey", this.currIndex, false);
        cache.remove(allRowKey);
        this.setRedisCacheOfList(allRowKey, "saveReportCalcModel", cacheOfRowDataCacheKeys.toArray(new String[0]));
        String dimCompStr = this.getDimCompStr(dimValList);
        this.pageDimAndIndexMap.put(dimCompStr, this.currIndex);
    }

    @Override
    public void updateReportCalcVal(List<ReportCalcVal> reportCalcValList) {
        if (EmptyUtil.isEmpty(reportCalcValList)) {
            return;
        }
        Map<Integer, List<ReportCalcVal>> calcValByRow = reportCalcValList.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(o -> o.getRow()));
        Set<Map.Entry<Integer, List<ReportCalcVal>>> calcValByRowEntries = calcValByRow.entrySet();
        for (Map.Entry<Integer, List<ReportCalcVal>> entry : calcValByRowEntries) {
            int row = entry.getKey();
            List<ReportCalcVal> needUpdateCalcVal = entry.getValue();
            String redisKey = this.getRedisKey(String.format("datadim.%srow", row), this.currIndex, false);
            HashSet<ReportCalcVal> clacValsForCache = new HashSet<ReportCalcVal>(this.getDimDataFormCache(redisKey));
            for (ReportCalcVal calcVal : needUpdateCalcVal) {
                if (clacValsForCache.add(calcVal)) continue;
                clacValsForCache.remove(calcVal);
            }
            clacValsForCache.addAll(needUpdateCalcVal);
            List<String> datas = clacValsForCache.stream().filter(Objects::nonNull).map(val -> FpmSerializeUtil.serialize((Object)val)).collect(Collectors.toList());
            this.removeCacheField(redisKey);
            this.setRedisCacheOfList(redisKey, "updateReportCalcVal", datas.toArray(new String[0]));
        }
    }

    private void removeCacheField(String redisKey) {
        cache.remove(redisKey);
    }

    @Override
    public void saveFormulaManger(IFormulaManager manager) {
        String formulaManagerRedisKey = this.getRedisKey("formula.manager", this.currIndex, false);
        cache.remove(formulaManagerRedisKey);
        this.setRedisCache(formulaManagerRedisKey, manager.serialize(), "updateFormulaManger");
    }

    @Override
    public void saveReportTemplate(ReportTemplate template) {
        String reportTempRedisKey = this.getRedisKey("report.template", null, true);
        cache.remove(reportTempRedisKey);
        this.setRedisCache(reportTempRedisKey, FpmSerializeUtil.serialize((Object)template), "saveReportTemplate");
    }

    @Override
    public void saveSystem(FundPlanSystem system) {
        String sysRedisKey = this.getRedisKey("fundplansystem", null, true);
        cache.remove(sysRedisKey);
        this.setRedisCache(sysRedisKey, FpmSerializeUtil.serialize((Object)system), "saveSystem");
    }

    @Override
    public String serialize() {
        return FpmSerializeUtil.serialize((Object)this);
    }

    @Override
    public IReportPlanRepository deserialize(String jsonStr) {
        return (IReportPlanRepository)FpmSerializeUtil.deserialize((String)jsonStr, ReportPlanRepository.class);
    }

    @Override
    public void releaseCache() {
        for (int i = this.pageDimAndIndexMap.size() - 1; i >= 0; --i) {
            IFormulaManager formulaManagerByIndex = this.getFormulaManagerByIndex(i);
            formulaManagerByIndex.destroy();
        }
        cache.remove(this.allRedisKeys.toArray(new String[0]));
    }

    @Override
    public List<ReportCalcVal> getCurrColDimData() {
        return this.getDimDataFormCache(this.getRedisKey("coldim", this.currIndex, false));
    }

    @Override
    public List<ReportCalcVal> getCurrPageDimData() {
        return this.getDimDataFormCache(this.getRedisKey("pagedim", this.currIndex, false));
    }

    @Override
    public List<ReportCalcVal> getCurrRowDimData() {
        return this.getDimDataFormCache(this.getRedisKey("rowdim", this.currIndex, false));
    }

    private ReportCalcModel buildCurrReportCalcModel(Integer index) {
        ReportCalcModel reportCalcModel = new ReportCalcModel();
        String pageDimRedisKey = this.getRedisKey("pagedim", index, false);
        reportCalcModel.setPageDimValList(this.getDimDataFormCache(pageDimRedisKey));
        String rowDimRedisKey = this.getRedisKey("rowdim", index, false);
        reportCalcModel.setRowDimValList(this.getDimDataFormCache(rowDimRedisKey));
        String colDimRedisKey = this.getRedisKey("coldim", index, false);
        reportCalcModel.setColDimValList(this.getDimDataFormCache(colDimRedisKey));
        String allDataDimsRedisKey = this.getRedisKey("allrowkey", index, false);
        String[] allDataDimsRedisKeys = cache.getList(allDataDimsRedisKey);
        ArrayList<ReportCalcVal> dataDimLst = new ArrayList<ReportCalcVal>(10);
        for (String dataDimRedisKeyOfRow : allDataDimsRedisKeys) {
            dataDimLst.addAll(this.getDimDataFormCache(dataDimRedisKeyOfRow));
        }
        reportCalcModel.setDataValList(dataDimLst);
        return reportCalcModel;
    }

    private List<ReportCalcVal> getDimDataFormCache(String redisKey) {
        Object[] dimDataJSONs = cache.getList(redisKey);
        if (EmptyUtil.isEmpty((Object[])dimDataJSONs)) {
            return new ArrayList<ReportCalcVal>(0);
        }
        List<ReportCalcVal> reportCalcVals = Arrays.stream(dimDataJSONs).filter(Objects::nonNull).map(s -> (ReportCalcVal)FpmSerializeUtil.deserialize((String)s, ReportCalcVal.class)).collect(Collectors.toList());
        return reportCalcVals;
    }

    private String getDimCompStr(List<Long> dimValList) {
        dimValList = dimValList.stream().sorted().collect(Collectors.toList());
        return dimValList.stream().map(o -> o.toString()).collect(Collectors.joining("_"));
    }

    private String getRedisKey(String signMark, Integer index, boolean isIndependCalcModel) {
        String redisKey = String.format("%s.%s.cache", this.pageId, signMark);
        if (!isIndependCalcModel) {
            redisKey = String.format("%s.%s.%s.cache", this.pageId, index.toString(), signMark);
        }
        this.allRedisKeys.add(redisKey);
        return redisKey;
    }

    private void setRedisCache(String redisKey, String json, String opName) {
        cache.put(redisKey, (Object)json, CacheKeyUtil.getPageCacheKeyTimeout());
    }

    private void setRedisCacheOfList(String redisKey, String opName, String ... datas) {
        if (EmptyUtil.isNoEmpty((Object[])datas)) {
            cache.addList(redisKey, datas, CacheKeyUtil.getPageCacheKeyTimeout());
        }
    }

    public Long getReportId() {
        return this.reportId;
    }

    public void setReportId(Long reportId) {
        this.reportId = reportId;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public Integer getCurrIndex() {
        return this.currIndex;
    }

    public void setCurrIndex(Integer currIndex) {
        this.currIndex = currIndex;
    }

    public Map<String, Integer> getPageDimAndIndexMap() {
        return this.pageDimAndIndexMap;
    }

    public void setPageDimAndIndexMap(Map<String, Integer> pageDimAndIndexMap) {
        this.pageDimAndIndexMap = pageDimAndIndexMap;
    }

    public Set<String> getAllRedisKeys() {
        return this.allRedisKeys;
    }

    public void setAllRedisKeys(Set<String> allRedisKeys) {
        this.allRedisKeys = allRedisKeys;
    }

    private IFormulaManager getFormulaManagerByIndex(int index) {
        String formulaManagerRedisKey = this.getRedisKey("formula.manager", index, false);
        String formulaManagerJson = (String)cache.get(formulaManagerRedisKey);
        IFormulaManager iFormulaManager = FormulaManagerFactory.fromSerializeString(formulaManagerJson);
        return iFormulaManager;
    }
}

