/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.repository.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fpm.business.domain.model.report.ReportVerifyRule;
import kd.tmc.fpm.business.mvc.converter.utils.ConverterUtils;
import kd.tmc.fpm.business.mvc.repository.IReportVerifyRuleRepository;

public class ReportVerifyRuleRepository
implements IReportVerifyRuleRepository {
    @Override
    public List<ReportVerifyRule> load(Long systemId, List<Long> reportTypeId) {
        QFilter qFilter = new QFilter("bodysysmanage.id", "=", (Object)systemId).and("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue()).and("reporttype.fbasedataid.id", "in", reportTypeId);
        Map cacheRuleMap = BusinessDataServiceHelper.loadFromCache((String)"fpm_reportcheckrule", (String)this.getSelectFields(), (QFilter[])new QFilter[]{qFilter});
        if (CollectionUtils.isEmpty((Map)cacheRuleMap)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ArrayList<ReportVerifyRule> result = new ArrayList<ReportVerifyRule>(cacheRuleMap.size());
        cacheRuleMap.forEach((k, v) -> result.add(ConverterUtils.convert(ReportVerifyRule.class, v)));
        return result;
    }

    private String getSelectFields() {
        return String.join((CharSequence)",", "id", "number", "name", "status", "bodysysmanage", "reporttype.fbasedataid.*", "checktype", "templatecheck", "templaterange.fbasedataid.*", "checkeffect", "tolerance", "checkreporttype", "checkdimension", "checkdimensionvalue_tag", "valueformula", "valueformulavalue_tag", "checkedreporttype", "checkeddimension", "checkeddimensionvalue_tag", "valuedformula", "valuedformulavalue_tag", "duringdeviation", "dataverifyrel", "expression", "entryentity.dimension", "entryentity.mulmembers");
    }
}

