/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.repository.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.TaskStatus;
import kd.tmc.fpm.business.domain.model.task.TaskRecord;
import kd.tmc.fpm.business.mvc.converter.TaskRecordConverter;
import kd.tmc.fpm.business.mvc.repository.ITaskRecordRepository;
import kd.tmc.fpm.business.mvc.service.dto.TaskRecordQueryParamsDTO;
import kd.tmc.fpm.business.utils.ListHelper;
import kd.tmc.fpm.common.property.TaskRecordProp;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import kd.tmc.fpm.common.utils.NumberUtils;

public class TaskRecordRepository
implements ITaskRecordRepository {
    @Override
    public TaskRecord loadSingleById(Long taskId) {
        FpmAssertUtil.isNotNull((Object)taskId, (String)"taskId is null");
        DynamicObject taskRecordObj = QueryServiceHelper.queryOne((String)"fpm_taskrecord", (String)TaskRecordProp.SELECT_PROP, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskId)});
        if (Objects.isNull(taskRecordObj)) {
            return null;
        }
        return TaskRecordConverter.convert(taskRecordObj);
    }

    @Override
    public List<TaskRecord> loadTaskByParam(Long taskId, String status, String taskType, String groupId, Integer maxSize, String orderBy) {
        DynamicObjectCollection queryResult;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        if (Objects.nonNull(taskId) && NumberUtils.greaterThan((Long)taskId, (Long)0L)) {
            qFilters.add(new QFilter("id", "=", (Object)taskId));
        }
        if (EmptyUtil.isNoEmpty((String)status)) {
            qFilters.add(new QFilter("status", "=", (Object)status));
        }
        if (EmptyUtil.isNoEmpty((String)taskType)) {
            qFilters.add(new QFilter("tasktype", "=", (Object)taskType));
        }
        if (EmptyUtil.isNoEmpty((String)groupId)) {
            qFilters.add(new QFilter("groupid", "=", (Object)groupId));
        }
        if (CollectionUtils.isEmpty(qFilters)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        if (EmptyUtil.isEmpty((Integer)maxSize)) {
            maxSize = 10;
        }
        if (CollectionUtils.isEmpty((Collection)(queryResult = QueryServiceHelper.query((String)"fpm_taskrecord", (String)TaskRecordProp.SELECT_PROP, (QFilter[])qFilters.toArray(new QFilter[0]), (String)orderBy, (int)maxSize)))) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        return queryResult.stream().map(TaskRecordConverter::convert).collect(Collectors.toList());
    }

    @Override
    public boolean existByParam(Long taskId, String status, String taskType, String groupId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        if (Objects.nonNull(taskId) && NumberUtils.greaterThan((Long)taskId, (Long)0L)) {
            qFilters.add(new QFilter("id", "=", (Object)taskId));
        }
        if (EmptyUtil.isNoEmpty((String)status)) {
            qFilters.add(new QFilter("status", "=", (Object)status));
        }
        if (EmptyUtil.isNoEmpty((String)taskType)) {
            qFilters.add(new QFilter("tasktype", "=", (Object)taskType));
        }
        if (EmptyUtil.isNoEmpty((String)groupId)) {
            qFilters.add(new QFilter("groupid", "=", (Object)groupId));
        }
        if (CollectionUtils.isEmpty(qFilters)) {
            return false;
        }
        return QueryServiceHelper.exists((String)"fpm_taskrecord", (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    @Override
    public void saveTask(TaskRecord task) {
        FpmAssertUtil.isNotNull((Object)task, (String)"task is null");
        FpmAssertUtil.isNotNull((Object)task.getId(), (String)"task id is null");
        DynamicObject dynamicObject = TaskRecordConverter.convert(task);
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    @Override
    public void updateTask(TaskRecord task) {
        FpmAssertUtil.isNotNull((Object)task, (String)"task is null");
        FpmAssertUtil.isNotNull((Object)task.getId(), (String)"task id is null");
        DynamicObject dynamicObject = TaskRecordConverter.convert(task);
        dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    @Override
    public void batchUpdateTask(List<TaskRecord> recordList) {
        FpmAssertUtil.isNotEmpty(recordList, (String)"recordList is null");
        long currUserId = RequestContext.get().getCurrUserId();
        List<DynamicObject> tasks = recordList.stream().map(item -> {
            DynamicObject convert = TaskRecordConverter.convert(item);
            convert.set("modifier", (Object)currUserId);
            return convert;
        }).collect(Collectors.toList());
        SaveServiceHelper.update((DynamicObject[])tasks.toArray(new DynamicObject[0]));
    }

    @Override
    public void batchDeleteTaskByIds(List<Long> taskIdList) {
        FpmAssertUtil.isNotEmpty(taskIdList, (String)"taskIdList is empty");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"fpm_taskrecord");
        DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])taskIdList.toArray());
    }

    @Override
    public List<TaskRecord> load(List<Long> taskIds) {
        if (EmptyUtil.isEmpty(taskIds)) {
            return new ArrayList<TaskRecord>(1);
        }
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"fpm_taskrecord", (String)TaskRecordProp.SELECT_PROP, (QFilter[])new QFilter[]{new QFilter("id", "in", taskIds)});
        if (Objects.isNull(dynamicObjectCollection)) {
            return new ArrayList<TaskRecord>(1);
        }
        return dynamicObjectCollection.stream().map(TaskRecordConverter::convert).collect(Collectors.toList());
    }

    @Override
    public boolean isRepeat(Long objectId, String objectTypeNumber) {
        if (EmptyUtil.isEmpty((Long)objectId)) {
            return false;
        }
        List<String> status = ListHelper.asList(TaskStatus.WAITING.name(), TaskStatus.HANDLING.name(), TaskStatus.RETRYING.name());
        QFilter qFilter = new QFilter("objectid", "=", (Object)objectId).and("objectentitynumber", "=", (Object)objectTypeNumber).and("status", "in", status);
        return QueryServiceHelper.exists((String)"fpm_taskrecord", (QFilter[])new QFilter[]{qFilter});
    }

    @Override
    public List<TaskRecord> loadTaskByParamsCompatible(TaskRecordQueryParamsDTO queryParamsDTO) {
        FpmAssertUtil.isNotNull((Object)queryParamsDTO, (String)"query param is null");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        if (EmptyUtil.isNoEmpty((Long)queryParamsDTO.getTaskId())) {
            qFilters.add(new QFilter("id", "=", (Object)queryParamsDTO.getTaskId()));
        }
        if (EmptyUtil.isNoEmpty((Object)((Object)queryParamsDTO.getStatus()))) {
            qFilters.add(new QFilter("status", "=", (Object)queryParamsDTO.getStatus().name()));
        }
        if (EmptyUtil.isNoEmpty((Object)((Object)queryParamsDTO.getTaskType()))) {
            qFilters.add(new QFilter("tasktype", "=", (Object)queryParamsDTO.getTaskType().name()));
        }
        if (EmptyUtil.isNoEmpty((String)queryParamsDTO.getGroupId())) {
            qFilters.add(new QFilter("groupid", "=", (Object)queryParamsDTO.getGroupId()));
        }
        if (EmptyUtil.isNoEmpty(queryParamsDTO.getTaskStatusList())) {
            List statusList = queryParamsDTO.getTaskStatusList().stream().filter(Objects::nonNull).map(Enum::name).collect(Collectors.toList());
            qFilters.add(new QFilter("status", "in", statusList));
        }
        if (CollectionUtils.isEmpty(qFilters)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        int retry = EmptyUtil.isEmpty((Integer)queryParamsDTO.getRetry()) ? 8 : queryParamsDTO.getRetry();
        qFilters.add(new QFilter("retry", "<=", (Object)(retry - 1)));
        int maxSize = EmptyUtil.isEmpty((Integer)queryParamsDTO.getMaxSize()) ? 10 : queryParamsDTO.getMaxSize();
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"fpm_taskrecord", (String)TaskRecordProp.SELECT_PROP, (QFilter[])qFilters.toArray(new QFilter[0]), (String)queryParamsDTO.getOrderBy(), (int)maxSize);
        if (CollectionUtils.isEmpty((Collection)queryResult)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        return queryResult.stream().map(TaskRecordConverter::convert).collect(Collectors.toList());
    }
}

