/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.repository.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.mvc.converter.TemplatePOConverter;
import kd.tmc.fpm.business.mvc.repository.ITemplateRepository;

public class TemplateRepository
implements ITemplateRepository {
    @Override
    public ReportTemplate loadTemplate(long templateId) {
        DynamicObject template = TmcDataServiceHelper.loadSingleFromCache((Object)templateId, (String)"fpm_template");
        return TemplatePOConverter.convertToTemplate(template);
    }

    @Override
    public List<ReportTemplate> backupTemplateList(List<Long> templateIdList) {
        List<ReportTemplate> reportTemplates = this.loadTemplate(templateIdList);
        ArrayList<ReportTemplate> unBakTemplates = new ArrayList<ReportTemplate>(10);
        HashMap<Long, Long> subTemplateIdMap = new HashMap<Long, Long>();
        ArrayList<DynamicObject> needSaveDataList = new ArrayList<DynamicObject>(reportTemplates.size());
        for (ReportTemplate reportTemplate : reportTemplates) {
            if (!reportTemplate.isMainTable()) {
                DynamicObject templateDO = TmcDataServiceHelper.newDynamicObject((String)"fpm_template_bak");
                long id = DB.genLongId((String)"fpm_template_bak");
                subTemplateIdMap.put(reportTemplate.getId(), id);
                reportTemplate.setCopyId(reportTemplate.getId());
                reportTemplate.setId(id);
                TemplatePOConverter.convertIntoTemplatePO(templateDO, reportTemplate);
                needSaveDataList.add(templateDO);
                continue;
            }
            unBakTemplates.add(reportTemplate);
        }
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            DynamicObject[] bakDataArr = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])needSaveDataList.toArray(new DynamicObject[0]));
            ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(Arrays.asList(bakDataArr));
            needSaveDataList = new ArrayList(unBakTemplates.size());
            for (ReportTemplate reportTemplate : unBakTemplates) {
                List<TemplateAccountSetting> accountSettings = reportTemplate.getAccountSettings();
                for (TemplateAccountSetting templateAccountSetting : accountSettings) {
                    Long childTemplateId = templateAccountSetting.getChildTemplateId();
                    templateAccountSetting.setChildTemplateId((Long)subTemplateIdMap.get(childTemplateId));
                }
                DynamicObject templateDO = TmcDataServiceHelper.newDynamicObject((String)"fpm_template_bak");
                long l = DB.genLongId((String)"fpm_template_bak");
                reportTemplate.setCopyId(reportTemplate.getId());
                reportTemplate.setId(l);
                TemplatePOConverter.convertIntoTemplatePO(templateDO, reportTemplate);
                needSaveDataList.add(templateDO);
            }
            DynamicObject[] bakMainDataArr = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])needSaveDataList.toArray(new DynamicObject[0]));
            resultList.addAll(new ArrayList<DynamicObject>(Arrays.asList(bakMainDataArr)));
            List idList = resultList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            DynamicObject[] dbDataArr = TmcDataServiceHelper.loadFromCache((Object[])idList.toArray(), (String)"fpm_template_bak").values().toArray(new DynamicObject[0]);
            ArrayList<ReportTemplate> result = new ArrayList<ReportTemplate>(resultList.size());
            for (DynamicObject bakData : dbDataArr) {
                ReportTemplate reportTemplate = TemplatePOConverter.convertToTemplate(bakData);
                result.add(reportTemplate);
            }
            h.commit();
            ArrayList<ReportTemplate> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            try {
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public ReportTemplate saveTemplate(ReportTemplate template) {
        long templateId = template.getId();
        boolean templateExists = TmcDataServiceHelper.exists((String)"fpm_template", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)});
        DynamicObject templatePO = templateExists ? TmcDataServiceHelper.loadSingle((Object)templateId, (String)"fpm_template") : TmcDataServiceHelper.newDynamicObject((String)"fpm_template");
        TemplatePOConverter.convertIntoTemplatePO(templatePO, template);
        OperationResult saveResult = TmcOperateServiceHelper.execOperate((String)"save", (String)"fpm_template", (DynamicObject[])new DynamicObject[]{templatePO}, (OperateOption)OperateOption.create());
        templateId = (Long)saveResult.getSuccessPkIds().get(0);
        templatePO = TmcDataServiceHelper.loadSingle((Object)templateId, (String)"fpm_template");
        return TemplatePOConverter.convertToTemplate(templatePO);
    }

    @Override
    public List<ReportTemplate> loadTemplateByPeriodType(long systemId, long periodTypeId) {
        ArrayList<ReportTemplate> result = new ArrayList<ReportTemplate>(10);
        QFilter qFilter = new QFilter("model", "=", (Object)systemId);
        QFilter qFilter1 = new QFilter(String.join((CharSequence)".", "reporttype", "fbasedataid", "id"), "in", (Object)periodTypeId).or(new QFilter(String.join((CharSequence)".", "reporttypeentry", "e_reporttype.id"), "in", (Object)periodTypeId));
        Map templateMap = TmcDataServiceHelper.loadFromCache((String)"fpm_template", (QFilter[])new QFilter[]{qFilter, qFilter1});
        for (DynamicObject templateObj : templateMap.values()) {
            result.add(TemplatePOConverter.convertToTemplate(templateObj));
        }
        return result;
    }

    @Override
    public List<ReportTemplate> loadTemplate(List<Long> templateIdList) {
        DynamicObject[] templateArr;
        ArrayList<ReportTemplate> result = new ArrayList<ReportTemplate>(templateIdList.size());
        for (DynamicObject template : templateArr = TmcDataServiceHelper.loadFromCache((Object[])templateIdList.toArray(), (String)"fpm_template").values().toArray(new DynamicObject[0])) {
            result.add(TemplatePOConverter.convertToTemplate(template));
        }
        return result;
    }

    @Override
    public Map<Long, ReportTemplate> loadTemplateBakMap(Collection<Long> templateBakIds) {
        HashMap<Long, ReportTemplate> map = new HashMap<Long, ReportTemplate>(templateBakIds.size());
        Map templateMap = TmcDataServiceHelper.loadFromCache((Object[])templateBakIds.toArray(), (String)"fpm_template_bak");
        for (Map.Entry entry : templateMap.entrySet()) {
            map.put((Long)entry.getKey(), TemplatePOConverter.convertToTemplate((DynamicObject)entry.getValue()));
        }
        return map;
    }

    @Override
    public List<ReportTemplate> loadTemplateBak(Collection<Long> templateBakIdList) {
        Object[] templateArr = TmcDataServiceHelper.loadFromCache((Object[])templateBakIdList.toArray(), (String)"fpm_template_bak").values().toArray(new DynamicObject[0]);
        if (EmptyUtil.isEmpty((Object[])templateArr)) {
            return Collections.emptyList();
        }
        return Arrays.stream(templateArr).map(TemplatePOConverter::convertToTemplate).collect(Collectors.toList());
    }

    @Override
    public ReportTemplate loadTemplateBak(Long templateBakId) {
        DynamicObject templateBak = TmcDataServiceHelper.loadSingleFromCache((Object)templateBakId, (String)"fpm_template_bak");
        return TemplatePOConverter.convertToTemplate(templateBak);
    }

    @Override
    public ReportTemplate loadTemplate(String templateName) {
        QFilter qFilter = new QFilter("name", "=", (Object)templateName);
        DynamicObject templateBak = TmcDataServiceHelper.loadSingleFromCache((String)"fpm_template_bak", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isNoEmpty((DynamicObject)templateBak)) {
            return TemplatePOConverter.convertToTemplate(templateBak);
        }
        DynamicObject template = TmcDataServiceHelper.loadSingleFromCache((String)"fpm_template", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isNoEmpty((DynamicObject)template)) {
            return TemplatePOConverter.convertToTemplate(template);
        }
        return null;
    }

    @Override
    public Map<Long, ReportTemplate> loadTemplateBakByReportIds(Collection<Long> reportIds) {
        String templateBakId = String.join((CharSequence)".", "templatebak", "id");
        String selectFields = String.join((CharSequence)",", "id", "templatebak", templateBakId);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"fpm_report", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", reportIds)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObjectCollection)) {
            return Collections.emptyMap();
        }
        Map templateBakIdReportIdMap = dynamicObjectCollection.stream().collect(Collectors.groupingBy(dy -> dy.getLong(templateBakId), Collectors.mapping(dy -> dy.getLong(templateBakId), Collectors.toList())));
        Set<Long> templateBakIds = templateBakIdReportIdMap.keySet();
        Object[] dynamicObjects = TmcDataServiceHelper.loadFromCache((Object[])templateBakIds.toArray(), (String)"fpm_template_bak").values().toArray(new DynamicObject[0]);
        if (EmptyUtil.isEmpty((Object[])dynamicObjects)) {
            return Collections.emptyMap();
        }
        HashMap<Long, ReportTemplate> reportTemplateMap = new HashMap<Long, ReportTemplate>(reportIds.size());
        for (Object dynamicObject : dynamicObjects) {
            Object templateId = dynamicObject.getPkValue();
            List reportIdList = templateBakIdReportIdMap.get(templateId);
            if (EmptyUtil.isEmpty(reportIdList)) continue;
            ReportTemplate reportTemplate = TemplatePOConverter.convertToTemplate((DynamicObject)dynamicObject);
            for (Long reportId : reportIdList) {
                reportTemplateMap.put(reportId, reportTemplate);
            }
        }
        return reportTemplateMap;
    }
}

