/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.calculate.strategy;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.model.calculate.ReportDataFormula;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.helper.FormulaHelper;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.mvc.enums.BizFormulaTypeEnum;
import kd.tmc.fpm.business.mvc.service.calculate.FormulaGenerateStrategy;
import kd.tmc.fpm.business.mvc.service.dto.ReportCalculateDTO;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.spread.formula.FormulaOperationVal;
import kd.tmc.fpm.business.spread.formula.FormulaOperationValUp;
import kd.tmc.fpm.business.spread.formula.IFormulaOperator;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CompletionSubjectFormulaGenerateStrategy
implements FormulaGenerateStrategy {
    @Override
    public List<ReportDataFormula> generateFormula(ReportCalculateDTO calculateDTO) {
        DimensionIndexTree customIndexTree = calculateDTO.getCustomIndexTree();
        ReportDataSource report = calculateDTO.getReport();
        FundPlanSystem system = calculateDTO.getSystem();
        if (!(report instanceof Report)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        Report reportPlan = (Report)report;
        ReportTemplate template = reportPlan.getTemplate();
        Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        List<TemplateAccountSetting> accountSettings = template.getAccountSettings();
        List<TemplateDim> allTemplateDimOutSubject = template.getAllTemplateDim().stream().filter(item -> item.getDimType() != DimensionType.SUBJECTS).collect(Collectors.toList());
        TemplateDim subjectTemplateDim = template.getAllTemplateDim().stream().filter(item -> item.getDimType() == DimensionType.SUBJECTS).findFirst().orElse(null);
        if (subjectTemplateDim == null) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        List tplDimScopeListS = allTemplateDimOutSubject.stream().map(item -> {
            if (item.getDimType() == DimensionType.PERIOD) {
                return reportPlan.getDetailPeriodMemberScope();
            }
            return item.getMemberScope();
        }).collect(Collectors.toList());
        List descartes = Lists.cartesianProduct(tplDimScopeListS);
        List<Long> dimIdList = allTemplateDimOutSubject.stream().map(TemplateDim::getDimensionId).collect(Collectors.toList());
        dimIdList.add(subjectTemplateDim.getDimensionId());
        ArrayList<ReportDataFormula> result = new ArrayList<ReportDataFormula>(descartes.size());
        for (TemplateAccountSetting targetAcctSetting : accountSettings) {
            List<ReportDataFormula> reportDataFormulas;
            Formula formulaInfo = FormulaHelper.completeSettingFormulaBySystem(targetAcctSetting, subjectDim);
            if (formulaInfo == null || !CollectionUtils.isNotEmpty(reportDataFormulas = this.buildFormulaByDescartesDimension(customIndexTree, descartes, dimIdList, targetAcctSetting, formulaInfo))) continue;
            result.addAll(reportDataFormulas);
        }
        allTemplateDimOutSubject.add(subjectTemplateDim);
        this.findBeginOfTermFormula(allTemplateDimOutSubject, result, descartes, reportPlan, system, customIndexTree);
        return result;
    }

    public List<ReportDataFormula> buildFormulaByDescartesDimension(DimensionIndexTree indexTree, List<List<Long>> descartes, List<Long> dimIdList, TemplateAccountSetting targetAcctSetting, Formula formulaInfo) {
        ReportInputType inputType = targetAcctSetting.getInputType();
        BizFormulaTypeEnum bizFormulaTypeEnum = this.convertBizType(inputType);
        ArrayList<ReportDataFormula> formulaList = new ArrayList<ReportDataFormula>(descartes.size());
        Deque<IFormulaOperator> operator = formulaInfo.getOperator();
        for (List<Long> dimMemberS : descartes) {
            ArrayList<Long> targetMemberS = new ArrayList<Long>(dimMemberS);
            targetMemberS.add(targetAcctSetting.getAccountMemId());
            LinkedList<IFormulaOperator> finalOperator = new LinkedList<IFormulaOperator>();
            TreeNode leftTreeNode = indexTree.find(new DimensionInfoBean(dimIdList, targetMemberS));
            if (Objects.isNull(leftTreeNode) || CollectionUtils.isEmpty(leftTreeNode.getDataList())) continue;
            List<Object> dataList = leftTreeNode.getDataList();
            ReportData reportData = (ReportData)dataList.get(0);
            ReportDataFormula reportDataFormula = new ReportDataFormula();
            reportDataFormula.setReportData(reportData);
            Formula finalFormula = new Formula();
            FormulaOperationValUp<TreeNode> leftVal = new FormulaOperationValUp<TreeNode>();
            leftVal.setName(leftTreeNode);
            finalFormula.setLeftValUp(leftVal);
            for (IFormulaOperator currOperator : operator) {
                if (currOperator instanceof FormulaOperationVal) {
                    FormulaOperationVal operationVal = (FormulaOperationVal)currOperator;
                    Long childAcctMemId = Long.valueOf(operationVal.getName());
                    targetMemberS.remove(targetMemberS.size() - 1);
                    targetMemberS.add(childAcctMemId);
                    TreeNode childrenTreeNode = indexTree.find(new DimensionInfoBean(dimIdList, targetMemberS));
                    if (Objects.isNull(childrenTreeNode)) continue;
                    FormulaOperationValUp<TreeNode> val = new FormulaOperationValUp<TreeNode>();
                    val.setName(childrenTreeNode);
                    finalOperator.add(val);
                } else {
                    finalOperator.add(currOperator);
                }
                finalFormula.setOperator(finalOperator);
            }
            reportDataFormula.setFormula(finalFormula);
            reportDataFormula.setFormulaType(bizFormulaTypeEnum);
            formulaList.add(reportDataFormula);
        }
        return formulaList;
    }

    public void findBeginOfTermFormula(List<TemplateDim> dimList, List<ReportDataFormula> formulaList, List<List<Long>> descartes, Report report, FundPlanSystem system, DimensionIndexTree indexTree) {
        ReportTemplate template = report.getTemplate();
        List<TemplateAccountSetting> accountSettings = template.getAccountSettings();
        Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        List<DimMember> memberList = subjectDim.getAllDimMemberList();
        Map<Long, Long> beginEndPeriodMap = memberList.stream().map(AccountMember.class::cast).filter(accountMember -> Objects.nonNull(accountMember.getPeriodDirection()) && Objects.nonNull(accountMember.getAssociateAccount())).collect(Collectors.toMap(accountMember -> accountMember.getAssociateAccount().getId(), DimMember::getId, (k1, k2) -> k1));
        if (beginEndPeriodMap.isEmpty()) {
            return;
        }
        List sortedPeriodList = ReportHelper.getAllPeriodMember(report).stream().sorted(Comparator.comparing(PeriodMember::getStartDate)).collect(Collectors.toList());
        Map<Integer, List<PeriodMember>> levelMap = sortedPeriodList.stream().collect(Collectors.groupingBy(DimMember::getLevel));
        HashMap<Long, Long> previousPeriodMap = new HashMap<Long, Long>(levelMap.size());
        for (Map.Entry<Integer, List<PeriodMember>> period : levelMap.entrySet()) {
            List<PeriodMember> sameLevelSortedPeriodList = period.getValue();
            Map<Long, Long> sameLevelPreviousPeriodMap = IntStream.range(0, sameLevelSortedPeriodList.size()).boxed().collect(Collectors.toMap(i -> ((PeriodMember)sameLevelSortedPeriodList.get((int)i)).getId(), i -> i > 0 ? ((PeriodMember)sameLevelSortedPeriodList.get(i - 1)).getId() : 0L));
            if (!MapUtils.isNotEmpty(sameLevelPreviousPeriodMap)) continue;
            previousPeriodMap.putAll(sameLevelPreviousPeriodMap);
        }
        List beginTermSettings = accountSettings.stream().filter(Objects::nonNull).filter(item -> beginEndPeriodMap.containsKey(item.getAccountMemId())).collect(Collectors.toList());
        List dimIdList = dimList.stream().map(TemplateDim::getDimensionId).collect(Collectors.toList());
        for (TemplateAccountSetting accountSetting : beginTermSettings) {
            if (accountSetting.getInputType() != ReportInputType.MANUAL_INPUT) continue;
            for (List<Long> dimMemberS : descartes) {
                ArrayList<Long> beginMemberIds = new ArrayList<Long>(dimMemberS);
                beginMemberIds.add(accountSetting.getAccountMemId());
                TreeNode leftTreeNode = indexTree.find(new DimensionInfoBean(dimIdList, beginMemberIds));
                if (Objects.isNull(leftTreeNode) || CollectionUtils.isEmpty(leftTreeNode.getDataList())) continue;
                List<Object> dataList = leftTreeNode.getDataList();
                ReportData reportData = (ReportData)dataList.get(0);
                ArrayList<Long> endMemberIds = new ArrayList<Long>(dimMemberS);
                endMemberIds.add(beginEndPeriodMap.get(accountSetting.getAccountMemId()));
                int periodIndex = dimList.indexOf(dimList.stream().filter(item -> item.getDimType() == DimensionType.PERIOD).findFirst().get());
                Long removePeriodId = (Long)endMemberIds.remove(periodIndex);
                if (!previousPeriodMap.containsKey(removePeriodId) || !EmptyUtil.isNoEmpty((Long)((Long)previousPeriodMap.get(removePeriodId)))) continue;
                endMemberIds.add(periodIndex, (Long)previousPeriodMap.get(removePeriodId));
                TreeNode rightTreeNode = indexTree.find(new DimensionInfoBean(dimIdList, endMemberIds));
                if (Objects.isNull(rightTreeNode)) continue;
                Formula finalFormula = new Formula();
                FormulaOperationValUp<TreeNode> leftVal = new FormulaOperationValUp<TreeNode>();
                leftVal.setName(leftTreeNode);
                finalFormula.setLeftValUp(leftVal);
                LinkedList<IFormulaOperator> finalOperator = new LinkedList<IFormulaOperator>();
                FormulaOperationValUp<TreeNode> rightVal = new FormulaOperationValUp<TreeNode>();
                rightVal.setName(rightTreeNode);
                finalOperator.add(rightVal);
                finalFormula.setOperator(finalOperator);
                ReportDataFormula reportDataFormula = new ReportDataFormula();
                reportDataFormula.setFormulaType(BizFormulaTypeEnum.SUBJECT_BEGIN_END);
                reportDataFormula.setFormula(finalFormula);
                reportDataFormula.setReportData(reportData);
                formulaList.add(reportDataFormula);
            }
        }
    }

    public BizFormulaTypeEnum convertBizType(ReportInputType inputType) {
        if (inputType == null) {
            return BizFormulaTypeEnum.SUBJECT_SUM;
        }
        if (ReportInputType.FORMULA == inputType) {
            return BizFormulaTypeEnum.SUBJECT_CUSTOM;
        }
        return BizFormulaTypeEnum.SUBJECT_SUM;
    }
}

