/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.calculate.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.model.calculate.ReportDataFormula;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.helper.FormulaHelper;
import kd.tmc.fpm.business.mvc.enums.BizFormulaTypeEnum;
import kd.tmc.fpm.business.mvc.service.calculate.FormulaGenerateStrategy;
import kd.tmc.fpm.business.mvc.service.dto.ReportCalculateDTO;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;

public class CustomFormulaGenerateStrategy
implements FormulaGenerateStrategy {
    private static final Log LOGGER = LogFactory.getLog(CustomFormulaGenerateStrategy.class);

    @Override
    public List<ReportDataFormula> generateFormula(ReportCalculateDTO calculateDTO) {
        ReportDataSource report = calculateDTO.getReport();
        FundPlanSystem system = calculateDTO.getSystem();
        ReportTemplate template = report.getTemplate();
        List summaryAcctSettings = template.getAccountSettings().stream().filter(Objects::nonNull).filter(item -> ReportInputType.FORMULA == item.getInputType()).collect(Collectors.toList());
        Map accountSettingMap = summaryAcctSettings.stream().collect(Collectors.toMap(TemplateAccountSetting::getAccountMemId, Function.identity()));
        Set<Long> accountSettingsId = accountSettingMap.keySet();
        DimensionIndexTree indexTree = report.getIndexTree(system);
        List<ReportData> reportDataList = report.getReportDataList();
        ArrayList<ReportDataFormula> result = new ArrayList<ReportDataFormula>(reportDataList.size());
        for (ReportData reportData : reportDataList) {
            String excelFunc;
            String formulaStr;
            Object accountId;
            if (reportData.isAuxiliaryInfo() || Objects.isNull(accountId = reportData.getDimValByDimType(DimensionType.SUBJECTS, null)) || !accountSettingsId.contains((Long)accountId) || StringUtils.isEmpty((CharSequence)(formulaStr = ((TemplateAccountSetting)accountSettingMap.get((Long)accountId)).getFormula())) || StringUtils.isEmpty((CharSequence)(excelFunc = this.convertToExcelFunc(indexTree, formulaStr, reportData, reportDataList)))) continue;
            Formula formula = FormulaHelper.getFormula(excelFunc, reportData);
            ReportDataFormula reportDataFormula = new ReportDataFormula();
            reportDataFormula.setFormulaType(BizFormulaTypeEnum.SUBJECT_CUSTOM);
            reportDataFormula.setReportData(reportData);
            reportDataFormula.setFormula(formula);
            result.add(reportDataFormula);
        }
        return result;
    }

    private String convertToExcelFunc(DimensionIndexTree indexTree, String formula, ReportData reportData, List<ReportData> reportDataList) {
        formula = formula.replaceAll("\\(", "").replaceAll("\\)", "");
        String regEx = "\\+|\\-";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(formula);
        String[] excelPostArr = p.split(formula);
        ArrayList<String> symbolArr = new ArrayList<String>(excelPostArr.length - 1);
        for (int count = 0; count < excelPostArr.length; ++count) {
            if (!m.find()) continue;
            symbolArr.add(m.group());
        }
        for (int i = 0; i < excelPostArr.length; ++i) {
            String formulaItem = excelPostArr[i];
            if (!formulaItem.matches("^(\\[)[0-9]+(])$")) continue;
            String symbol = "+";
            if (i < symbolArr.size()) {
                symbol = (String)symbolArr.get(i);
            }
            Long subjectId = Long.valueOf(formulaItem.replace("[", "").replace("]", ""));
            DimensionInfoBean dimensionInfoBean = this.getDimensionInfoBean(reportData, subjectId);
            List<Object> result = Lists.newArrayList();
            try {
                result = this.findAcctReportData(indexTree, reportData, dimensionInfoBean);
            }
            catch (Exception e) {
                LOGGER.warn("reportData:{}\uff0cchildSubjectId:{}", new Object[]{reportData.getId(), subjectId, e});
            }
            StringBuilder ids = new StringBuilder();
            if (CollectionUtils.isEmpty((Collection)result)) {
                ids.append("(0)");
            } else {
                ids.append("(");
                for (ReportData reportData2 : result) {
                    ids.append(reportData2.getId().toString()).append("+");
                }
                ids.deleteCharAt(ids.length() - 1);
                ids.append(")");
            }
            formula = formula.replace(formulaItem, String.format("%s", ids));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("convertToExcelFunc formula:{}", (Object)formula);
        }
        return formula;
    }

    private List<ReportData> findAcctReportData(DimensionIndexTree indexTree, ReportData reportData, DimensionInfoBean dimensionInfoBean) {
        List<Object> result = Lists.newArrayList();
        TreeNode treeNode = indexTree.find(dimensionInfoBean);
        if (treeNode != null) {
            List<Object> dataList = treeNode.getDataList();
            if (CollectionUtils.isNotEmpty(dataList)) {
                result = dataList.stream().map(item -> (ReportData)item).collect(Collectors.toList());
            }
        } else {
            LOGGER.warn("ReportService findAcctReportData tree node is null, reportData:{},dimId:{},targetDimValList:{}", new Object[]{reportData.getId(), dimensionInfoBean.getDimensionIdList(), dimensionInfoBean.getMemberIdList()});
        }
        return result;
    }

    private DimensionInfoBean getDimensionInfoBean(ReportData reportData, Long childAcctMemId) {
        List<TemplateDim> dimList = reportData.getDimList();
        TemplateDim templateDim = dimList.stream().filter(item -> item.getDimType() == DimensionType.SUBJECTS).findFirst().get();
        DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBean(reportData);
        DimensionInfoHelper.replaceDimValue(dimensionInfoBean, templateDim.getDimensionId(), childAcctMemId);
        return dimensionInfoBean;
    }
}

