/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.model.control.ApplyReportOrg;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.control.ControlAmountCache;
import kd.tmc.fpm.business.domain.model.control.ControlStrategy;
import kd.tmc.fpm.business.domain.model.control.ControlStrategyDetailControlInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTime;
import kd.tmc.fpm.business.domain.model.control.ControlTraceInfo;
import kd.tmc.fpm.business.domain.model.control.DimValueListInfo;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.control.ReportType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.index.generate.QueryIndexInfoMapGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.service.IControlExecuteParamPostProcessor;
import kd.tmc.fpm.business.mvc.service.IRelateReportDataManager;
import kd.tmc.fpm.business.mvc.service.control.factory.RelateReportDataManagerFactory;
import kd.tmc.fpm.business.mvc.service.impl.ControlRequestUpdateRecordManager;
import kd.tmc.fpm.business.mvc.service.impl.ControlTraceManager;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import org.apache.commons.collections4.MapUtils;

public class ControlContext {
    private static final Log logger = LogFactory.getLog(ControlContext.class);
    private PlanExecuteOpType planExecuteOpType;
    private List<ControlExecuteParam> controlExecuteParamList;
    private List<ControlExecuteParam> failedControlExecuteParamList;
    private Map<String, List<ControlTraceInfo>> controlTraceInfoMap;
    private ControlAmountCache controlAmountCache;
    private Map<Long, SystemControlInfo> systemControlInfoMap = new HashMap<Long, SystemControlInfo>(16);
    private String dbRouteKey;
    private String opName;
    private String opCode;
    private String entityType;
    private Map<String, ControlExecuteParam> controlExecuteParamMergeMap;
    private Long requestId;
    private Long currentMinRequestId;
    private ControlTraceManager controlTraceManager;
    private IRelateReportDataManager relateReportDataManager;
    private ControlRequestUpdateRecordManager controlRequestUpdateRecordManager;
    private List<IControlExecuteParamPostProcessor> controlExecuteParamPostProcessorList = new ArrayList<IControlExecuteParamPostProcessor>(8);
    private ControlStrategyDetailControlInfo controlStrategyDetailControlInfo;
    private Map<Long, Boolean> billMultiSourceMap = new HashMap<Long, Boolean>(128);
    private boolean checkDetailControl;

    public ControlContext() {
        this.failedControlExecuteParamList = new ArrayList<ControlExecuteParam>(64);
    }

    public void addControlExecuteParamPostProcessor(IControlExecuteParamPostProcessor controlExecuteParamPostProcessor) {
        if (!this.controlExecuteParamPostProcessorList.contains(controlExecuteParamPostProcessor)) {
            this.controlExecuteParamPostProcessorList.add(controlExecuteParamPostProcessor);
        }
    }

    public List<IControlExecuteParamPostProcessor> getControlExecuteParamPostProcessorList() {
        return this.controlExecuteParamPostProcessorList;
    }

    public PlanExecuteOpType getPlanExecuteOpType() {
        return this.planExecuteOpType;
    }

    public FundPlanSystem getSystem(Long systemId) {
        return this.systemControlInfoMap.getOrDefault(systemId, new SystemControlInfo(0L)).getSystem();
    }

    public ControlStrategy getControlStrategy(Long systemId, Long reportTypeId, Long reportOrgId) {
        return this.systemControlInfoMap.get(systemId).getControlStrategy(reportTypeId, reportOrgId);
    }

    public Map<Long, SystemControlInfo> getSystemControlInfoMap() {
        return this.systemControlInfoMap;
    }

    public ControlTime getControlTime(Long systemId) {
        SystemControlInfo systemControlInfo = this.systemControlInfoMap.get(systemId);
        if (Objects.isNull(systemControlInfo)) {
            return null;
        }
        return systemControlInfo.getControlTime();
    }

    public BillMatchRule getBillMatchRule(Long systemId, Long matchRuleId) {
        return this.systemControlInfoMap.get(systemId).getBillMatchRule(matchRuleId);
    }

    public void setPlanExecuteOpType(PlanExecuteOpType planExecuteOpType) {
        this.planExecuteOpType = planExecuteOpType;
    }

    public Set<Long> getSystemIds() {
        return this.systemControlInfoMap.values().stream().map(SystemControlInfo::getBillMatchRules).flatMap(Collection::stream).map(BillMatchRule::getSystemId).collect(Collectors.toSet());
    }

    public String getDbRouteKey() {
        return this.dbRouteKey;
    }

    public void setDbRouteKey(String dbRouteKey) {
        this.dbRouteKey = dbRouteKey;
    }

    public String getOpName() {
        return this.opName;
    }

    public void setOpName(String opName) {
        this.opName = opName;
    }

    public String getOpCode() {
        return this.opCode;
    }

    public void setOpCode(String opCode) {
        this.opCode = opCode;
    }

    public ControlStrategyDetailControlInfo getControlStrategyDetailControlInfo() {
        if (Objects.isNull(this.controlStrategyDetailControlInfo)) {
            this.controlStrategyDetailControlInfo = new ControlStrategyDetailControlInfo(this);
        }
        return this.controlStrategyDetailControlInfo;
    }

    public void addControlTimes(List<ControlTime> controlTimeList) {
        for (ControlTime controlTime : controlTimeList) {
            Long systemId = controlTime.getSystemId();
            SystemControlInfo systemControlInfo = this.systemControlInfoMap.computeIfAbsent(systemId, key -> new SystemControlInfo(systemId));
            systemControlInfo.setControlTime(controlTime);
        }
    }

    public void addBillMatchRule(List<BillMatchRule> billMatchRuleList) {
        if (EmptyUtil.isEmpty(billMatchRuleList)) {
            return;
        }
        for (BillMatchRule billMatchRule : billMatchRuleList) {
            Long systemId = billMatchRule.getSystemId();
            SystemControlInfo systemControlInfo = this.systemControlInfoMap.computeIfAbsent(systemId, key -> new SystemControlInfo(systemId));
            systemControlInfo.addBillMatchRule(billMatchRule);
        }
    }

    public void addSystem(FundPlanSystem system) {
        if (Objects.isNull(system)) {
            return;
        }
        Long systemId = system.getId();
        SystemControlInfo systemControlInfo = this.systemControlInfoMap.computeIfAbsent(systemId, key -> new SystemControlInfo(systemId));
        systemControlInfo.setSystem(system);
    }

    public void addControlStrategy(List<ControlStrategy> controlStrategyList) {
        if (EmptyUtil.isEmpty(controlStrategyList)) {
            return;
        }
        for (ControlStrategy controlStrategy : controlStrategyList) {
            Long systemId = controlStrategy.getSystemId();
            SystemControlInfo systemControlInfo = this.systemControlInfoMap.computeIfAbsent(systemId, key -> new SystemControlInfo(systemId));
            systemControlInfo.addControlStrategy(controlStrategy);
        }
    }

    public void addFailedControlExecuteParam(ControlExecuteParam controlExecuteParam) {
        this.failedControlExecuteParamList.add(controlExecuteParam);
    }

    public List<ControlExecuteParam> getFailedControlExecuteParamList() {
        return this.failedControlExecuteParamList;
    }

    public void registerMultiSource(Long billId) {
        this.billMultiSourceMap.put(billId, Boolean.TRUE);
    }

    public boolean isMultiSource(Long billId) {
        Boolean aBoolean = this.billMultiSourceMap.get(billId);
        return Objects.nonNull(aBoolean) && aBoolean != false;
    }

    public List<FundPlanSystem> getAllFundPlanSystem() {
        return this.systemControlInfoMap.values().stream().map(SystemControlInfo::getSystem).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<ControlExecuteParam> getControlExecuteParamList() {
        return this.controlExecuteParamList;
    }

    public void setControlExecuteParamList(List<ControlExecuteParam> controlExecuteParamList) {
        this.controlExecuteParamList = controlExecuteParamList;
    }

    public Map<String, List<ControlTraceInfo>> getControlTraceInfoMap() {
        return Objects.isNull(this.controlTraceInfoMap) ? new HashMap(16) : this.controlTraceInfoMap;
    }

    public void setControlTraceInfoMap(Map<String, List<ControlTraceInfo>> controlTraceInfoMap) {
        this.controlTraceInfoMap = controlTraceInfoMap;
    }

    public ControlAmountCache getControlAmountCache() {
        return this.controlAmountCache;
    }

    public void setControlAmountCache(ControlAmountCache controlAmountCache) {
        this.controlAmountCache = controlAmountCache;
    }

    public Long getControlTraceId(Long bizBillId) {
        return this.controlTraceManager.getControlTraceId(bizBillId);
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public Map<String, ControlExecuteParam> getControlExecuteParamMergeMap() {
        return this.controlExecuteParamMergeMap;
    }

    public void setControlExecuteParamMergeMap(Map<String, ControlExecuteParam> controlExecuteParamMergeMap) {
        this.controlExecuteParamMergeMap = controlExecuteParamMergeMap;
    }

    public ControlExecuteParam getOriginalControlExecuteParam(String mergeKey) {
        if (Objects.isNull(mergeKey)) {
            mergeKey = "";
        }
        return this.controlExecuteParamMergeMap.get(mergeKey);
    }

    public Long getRequestId() {
        return this.requestId;
    }

    public void setRequestId(Long requestId) {
        this.requestId = requestId;
    }

    public Long getCurrentMinRequestId() {
        return this.currentMinRequestId;
    }

    public void setCurrentMinRequestId(Long currentMinRequestId) {
        this.currentMinRequestId = currentMinRequestId;
    }

    public ControlTraceManager getControlTraceManager() {
        return this.controlTraceManager;
    }

    public void setControlTraceManager(ControlTraceManager controlTraceManager) {
        this.controlTraceManager = controlTraceManager;
    }

    public ControlRequestUpdateRecordManager getControlRequestUpdateRecordManager() {
        return this.controlRequestUpdateRecordManager;
    }

    public void setControlRequestUpdateRecordManager(ControlRequestUpdateRecordManager controlRequestUpdateRecordManager) {
        this.controlRequestUpdateRecordManager = controlRequestUpdateRecordManager;
    }

    public IRelateReportDataManager getRelateReportDataManager() {
        if (Objects.nonNull(this.relateReportDataManager)) {
            return this.relateReportDataManager;
        }
        this.initRelateReportDataManager();
        return this.relateReportDataManager;
    }

    public List<ControlTraceInfo> getControlTraceInfo(Long systemId, Long billId) {
        if (EmptyUtil.isEmpty((Long)systemId) || EmptyUtil.isEmpty((Long)billId)) {
            return Collections.emptyList();
        }
        String key = String.join((CharSequence)"#", billId.toString(), systemId.toString());
        return this.controlTraceInfoMap.getOrDefault(key, Collections.emptyList());
    }

    public boolean isCheckDetailControl() {
        return this.checkDetailControl;
    }

    public void setCheckDetailControl(boolean checkDetailControl) {
        this.checkDetailControl = checkDetailControl;
    }

    public boolean isEmpty() {
        return EmptyUtil.isEmpty(this.controlExecuteParamList) && EmptyUtil.isEmpty(this.failedControlExecuteParamList);
    }

    private void initRelateReportDataManager() {
        List<ControlExecuteParam> controlExecuteParamList = this.getControlExecuteParamList();
        if (EmptyUtil.isEmpty(controlExecuteParamList)) {
            return;
        }
        HashMap<Long, ReportData> sourceReportDataMap = new HashMap<Long, ReportData>(64);
        for (ControlExecuteParam controlExecuteParam : controlExecuteParamList) {
            List<PlanExecuteRecord> relatePlanExecuteRecordList;
            if (EmptyUtil.isNoEmpty((String)controlExecuteParam.getMergeKey())) continue;
            this.fillSourceReportDataMap(sourceReportDataMap, controlExecuteParam.getMatchedReportDataList());
            PlanExecuteRecord originalPlanExecuteRecord = controlExecuteParam.getOriginalPlanExecuteRecord();
            if (Objects.nonNull(originalPlanExecuteRecord)) {
                this.fillSourceReportDataMap(sourceReportDataMap, originalPlanExecuteRecord.getMatchedReportDataList());
            }
            if (EmptyUtil.isEmpty(relatePlanExecuteRecordList = controlExecuteParam.getRelatePlanExecuteRecordList())) continue;
            for (PlanExecuteRecord relatePlanExecuteRecord : relatePlanExecuteRecordList) {
                this.fillSourceReportDataMap(sourceReportDataMap, relatePlanExecuteRecord.getMatchedReportDataList());
            }
        }
        this.addOptionalDimMaybeDataIfNeed(sourceReportDataMap);
        if (MapUtils.isEmpty(sourceReportDataMap)) {
            return;
        }
        this.relateReportDataManager = RelateReportDataManagerFactory.getRelateReportDataManager(new ArrayList<ReportData>(sourceReportDataMap.values()), this);
    }

    private void addOptionalDimMaybeDataIfNeed(Map<Long, ReportData> sourceReportDataMap) {
        if (!this.planExecuteOpType.isOccupy() && this.planExecuteOpType != PlanExecuteOpType.PRE_OCCUPY_DELETE) {
            return;
        }
        if (MapUtils.isEmpty(sourceReportDataMap)) {
            return;
        }
        HashMap dimensionMap = new HashMap(32);
        DimValueListInfo dimValueListInfo = new DimValueListInfo();
        ArrayList<ControlExecuteParam> needBackFillList = new ArrayList<ControlExecuteParam>(this.controlExecuteParamList.size());
        for (ControlExecuteParam controlExecuteParam : this.controlExecuteParamList) {
            if (EmptyUtil.isNoEmpty(controlExecuteParam.getOptionalMaybeNeedReportDataList())) {
                controlExecuteParam.getOptionalMaybeNeedReportDataList().forEach(rd -> sourceReportDataMap.putIfAbsent(rd.getId(), (ReportData)rd));
                continue;
            }
            ReportData reportData = controlExecuteParam.getReportData();
            if (Objects.isNull(reportData)) continue;
            FundPlanSystem system = this.getSystem(controlExecuteParam.getSystemId());
            List<Dimension> mainDimList = system.getMainDimList();
            List<TemplateDim> dimList = reportData.getDimList();
            Optional<TemplateDim> any = dimList.stream().filter(d -> !d.getDimType().isDetailDim()).filter(dimension -> !dimension.getDimType().isSystemDim()).findAny();
            if (!any.isPresent()) continue;
            needBackFillList.add(controlExecuteParam);
            TemplateDim td = any.get();
            if (!dimensionMap.containsKey(td.getId())) {
                dimensionMap.putAll(mainDimList.stream().collect(Collectors.toMap(Dimension::getId, Function.identity(), (a, b) -> a)));
            }
            List<Object> dataDimValList = reportData.getDimValList();
            for (int i = 0; i < dimList.size(); ++i) {
                TemplateDim templateDim = dimList.get(i);
                if (templateDim.getDimType().isDetailDim()) continue;
                Dimension dimension2 = (Dimension)dimensionMap.get(templateDim.getDimensionId());
                if (!templateDim.getDimType().isSystemDim()) continue;
                dimValueListInfo.addDimensionValue(dimension2, dataDimValList.get(i));
                if (!dimension2.getDimType().isPeriodDim()) continue;
                dimValueListInfo.addDimensionValue(dimension2, reportData.getReportPeriodId());
            }
        }
        if (dimValueListInfo.isEmpty()) {
            return;
        }
        List reportIds = sourceReportDataMap.values().stream().map(ReportData::getReportId).distinct().collect(Collectors.toList());
        IReportDataQueryService dataQueryService = FpmServiceFactory.getBizService(IReportDataQueryService.class);
        List<ReportData> reportDataList = dataQueryService.queryReportDataForAllSystem(t -> {
            t.setReportIdS(reportIds);
            t.setReportPlanType(ReportPlanType.REPORTPLAN);
            t.setNeedDimIfValueIsNotEmpty(true);
            t.setDimIdList(dimValueListInfo.getDimensionList());
            t.setDimValList(dimValueListInfo.getDimValueList());
            t.setEffectFlag(true);
        });
        logger.info("\u67e5\u8be2\u6761\u4ef6:{},{}", dimValueListInfo.getDimensionList().stream().map(Dimension::getName).collect(Collectors.toList()), dimValueListInfo.getDimValueList());
        if (EmptyUtil.isEmpty(reportDataList)) {
            return;
        }
        reportDataList.forEach(rd -> sourceReportDataMap.putIfAbsent(rd.getId(), (ReportData)rd));
        this.backFillControlExecuteParam(reportDataList, needBackFillList);
    }

    private void backFillControlExecuteParam(List<ReportData> reportDataList, List<ControlExecuteParam> needBackFillList) {
        Map<Long, QueryIndexInfo> queryIndexInfoMap = reportDataList.stream().collect(Collectors.groupingBy(ReportData::getSystemId)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> QueryIndexInfoMapGenerator.buildReportDataIndex((List)entry.getValue(), this.getSystem((Long)entry.getKey()))));
        HashMap<String, List<Object>> mergeKeyReportDataListMap = new HashMap<String, List<Object>>(16);
        for (ControlExecuteParam controlExecuteParam : needBackFillList) {
            List cacheReportDataList;
            String mergeKey = EmptyUtil.isEmpty((String)controlExecuteParam.getMergeKey()) ? controlExecuteParam.getUniqueId() : controlExecuteParam.getMergeKey();
            String cacheKey = String.join((CharSequence)"#", mergeKey, controlExecuteParam.getReportTypeId().toString());
            if (EmptyUtil.isNoEmpty((String)cacheKey) && EmptyUtil.isNoEmpty(cacheReportDataList = mergeKeyReportDataListMap.getOrDefault(cacheKey, Collections.emptyList()))) {
                controlExecuteParam.setOptionalMaybeNeedReportDataList(new ArrayList<ReportData>(cacheReportDataList));
                continue;
            }
            QueryIndexInfo queryIndexInfo = queryIndexInfoMap.get(controlExecuteParam.getSystemId());
            if (Objects.isNull(queryIndexInfo)) continue;
            ReportData reportData = controlExecuteParam.getReportData();
            DimensionInfoBean dimensionInfoBeanByFilter = DimensionInfoHelper.getDimensionInfoBeanByFilter(reportData, td -> td.getDimType().isSystemDim());
            List<ReportData> list = queryIndexInfo.findList(dimensionInfoBeanByFilter);
            Dimension periodDim = this.getSystem(controlExecuteParam.getSystemId()).getMainDimensionByDimType(DimensionType.PERIOD);
            dimensionInfoBeanByFilter.replaceValueIfContains(periodDim.getId(), (Object)controlExecuteParam.getReportData().getReportPeriodId());
            list.addAll(queryIndexInfo.findList(dimensionInfoBeanByFilter));
            controlExecuteParam.setOptionalMaybeNeedReportDataList(list);
            mergeKeyReportDataListMap.put(cacheKey, list);
        }
    }

    private void fillSourceReportDataMap(Map<Long, ReportData> sourceReportDataMap, List<ReportData> matchedReportDataList) {
        if (EmptyUtil.isEmpty(matchedReportDataList)) {
            return;
        }
        matchedReportDataList.stream().forEach(rd -> sourceReportDataMap.putIfAbsent(rd.getId(), (ReportData)rd));
    }

    public static class SystemControlInfo {
        private Long systemId;
        private FundPlanSystem system;
        private ControlTime controlTime;
        private Map<String, ControlStrategy> controlStrategyMap;
        private Map<Long, BillMatchRule> billMatchRuleMap;

        public SystemControlInfo(Long systemId) {
            this.systemId = systemId;
            this.billMatchRuleMap = new HashMap<Long, BillMatchRule>(16);
            this.controlStrategyMap = new HashMap<String, ControlStrategy>(16);
        }

        public Long getSystemId() {
            return this.systemId;
        }

        public void setSystemId(Long systemId) {
            this.systemId = systemId;
        }

        public FundPlanSystem getSystem() {
            return this.system;
        }

        public void setSystem(FundPlanSystem system) {
            this.system = system;
        }

        public ControlTime getControlTime() {
            return this.controlTime;
        }

        public void setControlTime(ControlTime controlTime) {
            this.controlTime = controlTime;
        }

        public Map<String, ControlStrategy> getControlStrategyMap() {
            return this.controlStrategyMap;
        }

        public void setControlStrategyMap(Map<String, ControlStrategy> controlStrategyMap) {
            this.controlStrategyMap = controlStrategyMap;
        }

        public ControlStrategy getControlStrategy(Long reportTypeId, Long reportOrgId) {
            String strategyMapKey = String.join((CharSequence)"_", reportTypeId.toString(), reportOrgId.toString());
            ControlStrategy controlStrategy = this.controlStrategyMap.get(strategyMapKey);
            if (Objects.nonNull(controlStrategy)) {
                return controlStrategy;
            }
            return this.controlStrategyMap.get(reportTypeId.toString());
        }

        public void addControlStrategy(ControlStrategy controlStrategy) {
            List<ReportType> reportTypeList = controlStrategy.getReportType();
            List<ApplyReportOrg> applyReportOrgList = controlStrategy.getApplyReportOrgs();
            for (ReportType reportType : reportTypeList) {
                if (EmptyUtil.isNoEmpty(applyReportOrgList)) {
                    for (ApplyReportOrg applyReportOrg : applyReportOrgList) {
                        String uniqueKey = String.join((CharSequence)"_", reportType.getId().toString(), applyReportOrg.getReportOrgId().toString());
                        this.controlStrategyMap.put(uniqueKey, controlStrategy);
                    }
                    continue;
                }
                this.controlStrategyMap.putIfAbsent(reportType.getId().toString(), controlStrategy);
            }
        }

        public BillMatchRule getBillMatchRule(Long matchRuleId) {
            return this.billMatchRuleMap.get(matchRuleId);
        }

        public void addBillMatchRule(BillMatchRule billMatchRule) {
            this.billMatchRuleMap.putIfAbsent(billMatchRule.getId(), billMatchRule);
        }

        public Collection<BillMatchRule> getBillMatchRules() {
            return new ArrayList<BillMatchRule>(this.billMatchRuleMap.values());
        }
    }
}

