/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.control.executetime.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.BizRuleBindOperation;
import kd.tmc.fpm.business.domain.model.control.ControlExecTimeRule;
import kd.tmc.fpm.business.mvc.service.control.executetime.IExecuteTimeAutoReverseWriteOpRuleService;
import kd.tmc.fpm.business.utils.CommonUtils;

public class ExecuteTimeAutoReverseWriteOpRuleServiceImpl
implements IExecuteTimeAutoReverseWriteOpRuleService {
    @Override
    public void reverseWrite(List<ControlExecTimeRule> controlExecTimeRuleList) {
        Collection waitDeleteList;
        if (EmptyUtil.isEmpty(controlExecTimeRuleList)) {
            return;
        }
        Map<GroupKey, ControlExecTimeRule> groupMap = this.group(controlExecTimeRuleList);
        Set opRules = groupMap.keySet().stream().map(GroupKey::getOpBizRule).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("opbizrule", "in", opRules);
        List queryPrimaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"bos_opbizruleset", (QFilter[])new QFilter[]{qFilter}, null, (int)-1);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])queryPrimaryKeys.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_opbizruleset"));
        Map dynamicObjectMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> new GroupKey(dy.getDynamicObject("objecttype").getPkValue().toString(), dy.getString("opbizrule")), Function.identity(), (a, b) -> a));
        HashMap currentDynamicObjectMap = new HashMap(dynamicObjectMap);
        ArrayList<DynamicObject> waitSaveList = new ArrayList<DynamicObject>(16);
        long count = groupMap.keySet().stream().filter(groupKey -> !dynamicObjectMap.containsKey(groupKey)).count();
        Deque<Long> deque = CommonUtils.batchGenerateIds((int)count);
        for (Map.Entry<GroupKey, ControlExecTimeRule> entry : groupMap.entrySet()) {
            GroupKey groupKey2 = entry.getKey();
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectMap.remove(groupKey2);
            ControlExecTimeRule controlExecTimeRule = entry.getValue();
            if (Objects.isNull(dynamicObject)) {
                controlExecTimeRule.setId(deque.poll());
                dynamicObject = this.newDynamicObject(controlExecTimeRule);
                waitSaveList.add(dynamicObject);
                dynamicObjectMap.put(groupKey2, dynamicObject);
                continue;
            }
            currentDynamicObjectMap.remove(groupKey2);
            if (this.populateEntry(dynamicObject, CommonUtils.getDistinctList(controlExecTimeRule.getBizRuleBindOperations(), BizRuleBindOperation::getOpKey))) {
                waitSaveList.add(dynamicObject);
                continue;
            }
            if (dynamicObject.getBoolean("enabled")) continue;
            dynamicObject.set("enabled", (Object)"1");
            waitSaveList.add(dynamicObject);
        }
        if (EmptyUtil.isNoEmpty(waitSaveList)) {
            TmcOperateServiceHelper.execOperate((String)"save", (String)"bos_opbizruleset", (DynamicObject[])waitSaveList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        }
        if (EmptyUtil.isNoEmpty(waitDeleteList = currentDynamicObjectMap.values())) {
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"bos_opbizruleset", (DynamicObject[])waitDeleteList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        }
    }

    private DynamicObject newDynamicObject(ControlExecTimeRule controlExecTimeRule) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_opbizruleset");
        dynamicObject.set("id", (Object)controlExecTimeRule.getId());
        dynamicObject.set("objecttype", (Object)controlExecTimeRule.getBindBizBill());
        dynamicObject.set("opbizrule", (Object)controlExecTimeRule.getOpBizRule());
        dynamicObject.set("enabled", (Object)"1");
        this.populateEntry(dynamicObject, controlExecTimeRule.getBizRuleBindOperations());
        return dynamicObject;
    }

    private boolean populateEntry(DynamicObject dynamicObject, List<BizRuleBindOperation> bizRuleBindOperations) {
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
        dynamicObjectCollection.clear();
        for (BizRuleBindOperation bizRuleBindOperation : bizRuleBindOperations) {
            DynamicObject entry = dynamicObjectCollection.addNew();
            entry.set("operationkey", (Object)bizRuleBindOperation.getOpKey());
        }
        return true;
    }

    private Map<GroupKey, ControlExecTimeRule> group(List<ControlExecTimeRule> controlExecTimeRuleList) {
        HashMap<GroupKey, ControlExecTimeRule> groupMap = new HashMap<GroupKey, ControlExecTimeRule>(16);
        for (ControlExecTimeRule controlExecTimeRule : controlExecTimeRuleList) {
            GroupKey groupKey = new GroupKey(controlExecTimeRule.getBindBizBill(), controlExecTimeRule.getOpBizRule());
            ControlExecTimeRule execTimeRule = groupMap.computeIfAbsent(groupKey, k -> controlExecTimeRule);
            if (execTimeRule == controlExecTimeRule) continue;
            execTimeRule.getBizRuleBindOperations().addAll(controlExecTimeRule.getBizRuleBindOperations());
        }
        return groupMap;
    }

    static class GroupKey {
        private final String bizBill;
        private final String opBizRule;

        public GroupKey(String bizBill, String opBizRule) {
            this.bizBill = bizBill;
            this.opBizRule = opBizRule;
        }

        public String getBizBill() {
            return this.bizBill;
        }

        public String getOpBizRule() {
            return this.opBizRule;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupKey groupKey = (GroupKey)o;
            return Objects.equals(this.bizBill, groupKey.bizBill) && Objects.equals(this.opBizRule, groupKey.opBizRule);
        }

        public int hashCode() {
            return Objects.hash(this.bizBill, this.opBizRule);
        }
    }
}

