/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.control.lock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTraceIdInfo;
import kd.tmc.fpm.business.mvc.service.IControlTraceService;
import kd.tmc.fpm.business.mvc.service.impl.ControlTraceServiceImpl;
import org.apache.commons.collections.CollectionUtils;

public class ControlTraceLock {
    private IControlTraceService controlTraceService;
    private List<BillBizInfo> billBizInfoList;
    private List<String> lockSuccessControlTraceIds;
    private boolean lock;
    private static final Log logger = LogFactory.getLog(ControlTraceLock.class);
    private static final String OP_KEY = "fpm_controlTraceLock";
    private static final String ENTITY_NAME = "fpm_controlTraceLock";

    public ControlTraceLock(List<BillBizInfo> billBizInfoList) {
        this.billBizInfoList = billBizInfoList;
        this.controlTraceService = new ControlTraceServiceImpl();
        this.lockSuccessControlTraceIds = new ArrayList<String>(billBizInfoList.size());
    }

    public boolean lock() {
        if (this.lock) {
            return true;
        }
        ControlTraceIdInfo controlTraceIds = this.controlTraceService.getControlTraceIds(this.billBizInfoList);
        List waitLockIds = controlTraceIds.getControlTraceIdList().stream().distinct().map(String::valueOf).collect(Collectors.toList());
        logger.info("\u5bf9\u63a7\u5236\u94fe\u8defid:{}\u52a0\u9501", waitLockIds);
        Map controlTraceLock = MutexServiceHelper.batchRequest(waitLockIds, (String)"fpm_controlTraceLock", (String)"fpm_controlTraceLock");
        List successLockIds = controlTraceLock.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
        this.lockSuccessControlTraceIds.addAll(successLockIds);
        try {
            if (successLockIds.size() != waitLockIds.size()) {
                logger.info("\u5bf9\u63a7\u5236\u94fe\u8defid\uff1a{}\u52a0\u9501\uff0c\u5b58\u5728\u52a0\u9501\u5931\u8d25\u7684\u6570\u636e\uff0c\u5931\u8d25\u7684id:{}", waitLockIds, controlTraceLock.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList()));
                this.release();
                return false;
            }
            if (!controlTraceIds.needDoubleCheck()) {
                logger.info("\u4e0d\u5b58\u5728\u9996\u6b21\u83b7\u53d6\u751f\u6210\u7684\u94fe\u8defid\uff0c\u52a0\u9501\u6210\u529f\u3002\u3002\u3002");
                this.lock = true;
                return true;
            }
            List<Long> firstGenLockControlTraceIds = controlTraceIds.getFirstGenControlTraceIds();
            logger.info("\u52a0\u9501\u6210\u529f\u7684\u9996\u6b21\u751f\u6210\u7684\u63a7\u5236\u94fe\u8defid\uff1a{}", firstGenLockControlTraceIds);
            List<BillBizInfo> controlTraceIdFirstBizBillInfoList = controlTraceIds.getControlTraceIdFirstBizBillInfoList();
            ControlTraceIdInfo firstControlTraceIds = this.controlTraceService.getControlTraceIds(controlTraceIdFirstBizBillInfoList);
            List<Long> controlTraceIdList = firstControlTraceIds.getControlTraceIdList();
            logger.info("\u518d\u6b21\u67e5\u8be2\u9996\u6b21\u751f\u6210\u94fe\u8defid\u7684\u4e1a\u52a1\u5355\u636e\u7684\u94fe\u8defid:{}", controlTraceIdList);
            Collection intersection = CollectionUtils.intersection(firstGenLockControlTraceIds, controlTraceIdList);
            firstGenLockControlTraceIds.removeAll(intersection);
            if (EmptyUtil.isEmpty(firstGenLockControlTraceIds)) {
                logger.info("\u4e24\u6b21\u67e5\u8be2\u5230\u7684\u9996\u6b21\u751f\u6210\u7684\u94fe\u8defid\u4e00\u81f4\uff0c\u52a0\u9501\u6210\u529f\u3002\u3002\u3002");
                this.lock = true;
                return true;
            }
            List waitReleaseFirstGenLockControlTraceIds = firstGenLockControlTraceIds.stream().map(String::valueOf).collect(Collectors.toList());
            logger.info("\u5b58\u5728\u9996\u6b21\u751f\u6210\u7684\u94fe\u8defid:{}\u7684\u4e1a\u52a1\u5355\u636e\u518d\u6b21\u67e5\u8be2\u5230\u4e0d\u4e00\u6837\u7684\u94fe\u8defid,\u91ca\u653e\u51c6\u5907\u518d\u6b21\u83b7\u53d6", waitReleaseFirstGenLockControlTraceIds);
            MutexServiceHelper.batchRelease(waitReleaseFirstGenLockControlTraceIds, (String)"fpm_controlTraceLock", (String)"fpm_controlTraceLock");
            this.lockSuccessControlTraceIds.removeAll(waitReleaseFirstGenLockControlTraceIds);
            controlTraceIdList.removeAll(intersection);
            logger.info("\u5b58\u5728\u9996\u6b21\u751f\u6210\u7684\u94fe\u8defid\u7684\u4e1a\u52a1\u5355\u636e\u518d\u6b21\u67e5\u8be2\u5230\u4e0d\u4e00\u6837\u7684\u94fe\u8defid:{},\u51c6\u5907\u518d\u6b21\u83b7\u53d6", controlTraceIdList);
            Map booleanMap = MutexServiceHelper.batchRelease(controlTraceIdList.stream().map(String::valueOf).collect(Collectors.toList()), (String)"fpm_controlTraceLock", (String)"fpm_controlTraceLock");
            List secondLockSuccessIds = booleanMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
            this.lockSuccessControlTraceIds.addAll(secondLockSuccessIds);
            if (secondLockSuccessIds.size() != controlTraceIdList.size()) {
                logger.info("\u518d\u6b21\u5bf9\u63a7\u5236\u94fe\u8defid\u52a0\u9501\u5b58\u5728\u90e8\u5206\u5931\u8d25\u3002\u3002\u3002\u3002");
                MutexServiceHelper.batchRelease(this.lockSuccessControlTraceIds, (String)"fpm_controlTraceLock", (String)"fpm_controlTraceLock");
                return false;
            }
            this.lock = true;
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.release();
            return false;
        }
    }

    public void release() {
        this.lock = false;
        if (EmptyUtil.isEmpty(this.lockSuccessControlTraceIds)) {
            logger.info("\u91ca\u653eControlTraceLock\uff0c\u6ca1\u6709\u52a0\u9501\u6210\u529f\u7684id");
            return;
        }
        logger.info("\u51c6\u5907\u91ca\u653e\u9501ControlTraceLock\uff1a{}", this.lockSuccessControlTraceIds);
        MutexServiceHelper.batchRelease(this.lockSuccessControlTraceIds, (String)"fpm_controlTraceLock", (String)"fpm_controlTraceLock");
        this.lockSuccessControlTraceIds.clear();
    }
}

