/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.control.lock;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReportDataLock {
    private List<String> waitLockReportDataIds;
    private List<String> lockSuccessReportDataIds;
    private boolean lock;
    private static final String OP_KEY = "fpm_control";
    private static final Log logger = LogFactory.getLog(ReportDataLock.class);

    public ReportDataLock(List<String> waitLockReportDataIds) {
        this.waitLockReportDataIds = waitLockReportDataIds.stream().distinct().collect(Collectors.toList());
        this.lockSuccessReportDataIds = new ArrayList<String>(waitLockReportDataIds.size());
    }

    public boolean lock() {
        if (this.lock) {
            return true;
        }
        Map booleanMap = MutexServiceHelper.batchRequest(this.waitLockReportDataIds, (String)"fpm_report", (String)OP_KEY);
        List successIds = booleanMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
        this.lockSuccessReportDataIds.addAll(successIds);
        if (successIds.size() != this.waitLockReportDataIds.size()) {
            logger.info("\u52a0\u9501\u5931\u8d25,\u5931\u8d25\u7684id\uff1a{}", booleanMap.entrySet().stream().filter(en -> (Boolean)en.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList()));
            this.release();
            return false;
        }
        this.lock = true;
        return true;
    }

    public boolean addLock(List<String> waitAddLockReportDataIds) {
        waitAddLockReportDataIds.removeAll(this.lockSuccessReportDataIds);
        waitAddLockReportDataIds = waitAddLockReportDataIds.stream().distinct().collect(Collectors.toList());
        if (EmptyUtil.isEmpty(waitAddLockReportDataIds)) {
            return true;
        }
        Map booleanMap = MutexServiceHelper.batchRequest(waitAddLockReportDataIds, (String)"fpm_report", (String)OP_KEY);
        List successIds = booleanMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
        this.lockSuccessReportDataIds.addAll(successIds);
        return successIds.size() == waitAddLockReportDataIds.size();
    }

    public void release() {
        this.lock = false;
        if (EmptyUtil.isEmpty(this.lockSuccessReportDataIds)) {
            logger.info("ReportDataLock\u91ca\u653e\u9501\uff0c\u6ca1\u6709\u52a0\u9501\u6210\u529f\u7684id");
            return;
        }
        logger.info("\u51c6\u5907\u91ca\u653eReportDataLock\uff1a{}", this.lockSuccessReportDataIds);
        MutexServiceHelper.batchRelease(this.lockSuccessReportDataIds, (String)"fpm_report", (String)OP_KEY);
        this.lockSuccessReportDataIds.clear();
    }

    public List<String> getWaitLockReportDataIds() {
        return this.waitLockReportDataIds;
    }

    public List<String> getLockSuccessReportDataIds() {
        return this.lockSuccessReportDataIds;
    }
}

