/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.control.trace.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTraceIdInfo;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.trace.ControlTraceBroke;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.control.trace.IControlTraceIdGenerator;
import kd.tmc.fpm.business.mvc.service.control.trace.IControlTraceStrategy;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;

public abstract class AbstractControlStrategy
implements IControlTraceStrategy {
    protected static final Log logger = LogFactory.getLog(AbstractControlStrategy.class);
    protected Map<Long, ControlTraceBroke> billControlTraceBroke;
    protected AbstractControlStrategy abstractControlStrategy;
    protected ControlContext controlContext;
    protected Map<Long, ControlTraceBroke> paramBillControlTraceBroke;
    protected IControlTraceIdGenerator controlTraceIdGenerator;
    protected List<ControlExecuteParam> controlExecuteParamList;
    protected Map<Long, Set<Long>> billSystemMap;

    public AbstractControlStrategy(ControlContext controlContext, List<ControlExecuteParam> controlExecuteParamList) {
        this(controlContext, controlExecuteParamList, billBizInfo -> billBizInfo.getBillId());
    }

    public AbstractControlStrategy(ControlContext controlContext, List<ControlExecuteParam> controlExecuteParamList, IControlTraceIdGenerator controlTraceIdGenerator) {
        this.billControlTraceBroke = new HashMap<Long, ControlTraceBroke>(16);
        this.controlContext = controlContext;
        this.paramBillControlTraceBroke = new HashMap<Long, ControlTraceBroke>(16);
        this.billSystemMap = new HashMap<Long, Set<Long>>(16);
        this.controlTraceIdGenerator = controlTraceIdGenerator;
        this.controlExecuteParamList = controlExecuteParamList;
        this.init();
    }

    public AbstractControlStrategy(AbstractControlStrategy abstractControlStrategy) {
        this.abstractControlStrategy = abstractControlStrategy;
        this.billControlTraceBroke = abstractControlStrategy.billControlTraceBroke;
        this.controlContext = abstractControlStrategy.controlContext;
        this.paramBillControlTraceBroke = abstractControlStrategy.paramBillControlTraceBroke;
        this.controlTraceIdGenerator = abstractControlStrategy.controlTraceIdGenerator;
        this.controlExecuteParamList = abstractControlStrategy.controlExecuteParamList;
    }

    private void init() {
        HashMap accountMemberMap = new HashMap(256);
        for (ControlExecuteParam controlExecuteParam : this.controlExecuteParamList) {
            BillBizInfo billBizInfo = controlExecuteParam.getBillBizInfo();
            Set systemIds = this.billSystemMap.computeIfAbsent(billBizInfo.getBillId(), k -> new HashSet(4));
            systemIds.add(controlExecuteParam.getSystemId());
            ControlTraceBroke controlTraceBroke = this.paramBillControlTraceBroke.computeIfAbsent(billBizInfo.getBillId(), k -> new ControlTraceBroke(billBizInfo));
            controlTraceBroke.addReportOrgId(controlExecuteParam.getReportOrgId());
            controlTraceBroke.addAmount(controlExecuteParam.getActAmount());
            Long subjectId = controlExecuteParam.getSubjectId();
            if (EmptyUtil.isEmpty((Long)subjectId)) continue;
            AccountMember accountMember = (AccountMember)accountMemberMap.get(subjectId);
            if (Objects.isNull(accountMember)) {
                FundPlanSystem system = this.controlContext.getSystem(controlExecuteParam.getSystemId());
                Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
                accountMemberMap.putAll(subjectDim.getAllDimMemberList().stream().map(AccountMember.class::cast).collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a)));
                accountMember = (AccountMember)accountMemberMap.get(subjectId);
            }
            controlTraceBroke.addFlowType(accountMember.getFlowType());
        }
    }

    @Override
    public void processControlTraceIds(List<BillBizInfo> billBizInfoList, ControlTraceIdInfo controlTraceIdInfo) {
        if (Objects.isNull(controlTraceIdInfo)) {
            throw new KDBizException("");
        }
        this.filter(billBizInfoList, controlTraceIdInfo);
        if (Objects.nonNull(this.abstractControlStrategy)) {
            this.abstractControlStrategy.processControlTraceIds(billBizInfoList, controlTraceIdInfo);
        }
        if (EmptyUtil.isEmpty(billBizInfoList)) {
            return;
        }
        this.doProcessControlTraceIds(billBizInfoList, controlTraceIdInfo);
    }

    protected void filter(List<BillBizInfo> billBizInfoList, ControlTraceIdInfo controlTraceIdInfo) {
        Iterator<BillBizInfo> iterator = billBizInfoList.iterator();
        while (iterator.hasNext()) {
            BillBizInfo next = iterator.next();
            ControlTraceIdInfo.BillControlTraceIdInfo billControlTraceIdInfo = controlTraceIdInfo.getBillControlTraceIdInfo(next.getBillId());
            if (EmptyUtil.isEmpty((Object)billControlTraceIdInfo)) {
                iterator.remove();
                continue;
            }
            if (!billControlTraceIdInfo.isFirst()) continue;
            iterator.remove();
        }
    }

    protected abstract void doProcessControlTraceIds(List<BillBizInfo> var1, ControlTraceIdInfo var2);

    protected void setNewControlTraceId(BillBizInfo billBizInfo, ControlTraceIdInfo controlTraceIdInfo) {
        Long controlTraceId = this.controlTraceIdGenerator.generateControlTraceId(billBizInfo);
        logger.info("\u4e1a\u52a1\u5355\u636e\uff1a{}\uff0c\u751f\u6210\u7684\u94fe\u8defid\uff1a{}", (Object)billBizInfo.getBillNo(), (Object)controlTraceId);
        ControlTraceIdInfo.BillControlTraceIdInfo billControlTraceIdInfo = controlTraceIdInfo.getBillControlTraceIdInfo(billBizInfo.getBillId());
        billControlTraceIdInfo.setControlTraceId(controlTraceId);
        billControlTraceIdInfo.setFirst(true);
    }

    protected String getGroupKey(Long billId, Long systemId) {
        return String.join((CharSequence)"_", billId.toString(), systemId.toString());
    }
}

