/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.control.trace.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTraceIdInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTraceInfo;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.trace.ControlTraceBroke;
import kd.tmc.fpm.business.mvc.service.IControlTraceService;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.control.trace.impl.AbstractControlStrategy;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import org.apache.commons.collections4.MapUtils;

public class CanBreakControlTraceStrategy
extends AbstractControlStrategy {
    private IControlTraceService controlTraceService = FpmServiceFactory.getBizService(IControlTraceService.class);

    public CanBreakControlTraceStrategy(ControlContext controlContext, List<ControlExecuteParam> controlExecuteParamList) {
        super(controlContext, controlExecuteParamList);
    }

    @Override
    protected void doProcessControlTraceIds(List<BillBizInfo> billBizInfoList, ControlTraceIdInfo controlTraceIdInfo) {
        if (EmptyUtil.isEmpty(billBizInfoList)) {
            return;
        }
        this.fillControlTraceBrokeFromControlTraceInfo(billBizInfoList);
    }

    private void fillControlTraceBrokeFromControlTraceInfo(List<BillBizInfo> billBizInfoList) {
        if (MapUtils.isNotEmpty((Map)this.billControlTraceBroke)) {
            return;
        }
        HashMap accountMemberMap = new HashMap(256);
        Iterator<BillBizInfo> iterator = billBizInfoList.iterator();
        block0: while (iterator.hasNext()) {
            BillBizInfo billBizInfo = iterator.next();
            ControlTraceBroke controlTraceBroke = this.billControlTraceBroke.computeIfAbsent(billBizInfo.getBillId(), k -> new ControlTraceBroke(billBizInfo));
            Set systemIds = (Set)this.billSystemMap.get(billBizInfo.getBillId());
            if (EmptyUtil.isEmpty((Collection)systemIds)) continue;
            for (Long systemId : systemIds) {
                List<PlanExecuteRecord> executeRecordList;
                List<ControlTraceInfo> controlTraceInfoList = this.controlTraceService.getControlTraceInfo(billBizInfo, systemId);
                if (EmptyUtil.isEmpty(controlTraceInfoList)) continue;
                ControlTraceInfo controlTraceInfo = controlTraceInfoList.get(0);
                if (Objects.equals(controlTraceInfo.getBillId(), billBizInfo.getBillId()) && Objects.equals(controlTraceInfo.getEntityType(), billBizInfo.getEntityType())) {
                    iterator.remove();
                    continue block0;
                }
                for (int index = 0; EmptyUtil.isEmpty(executeRecordList = controlTraceInfoList.get(index).getExecuteRecordList()) && index < controlTraceInfoList.size(); ++index) {
                }
                if (EmptyUtil.isEmpty(executeRecordList)) continue;
                for (PlanExecuteRecord planExecuteRecord : executeRecordList) {
                    controlTraceBroke.addReportOrgId(planExecuteRecord.getReportOrgId());
                    controlTraceBroke.addAmount(planExecuteRecord.getActAmount());
                    Long subjectId = planExecuteRecord.getSubjectId();
                    if (!accountMemberMap.containsKey(subjectId)) {
                        FundPlanSystem system = this.controlContext.getSystem(systemId);
                        Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
                        Map subjectMap = subjectDim.getAllDimMemberList().stream().map(AccountMember.class::cast).collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
                        accountMemberMap.putAll(subjectMap);
                    }
                    controlTraceBroke.addFlowType(((AccountMember)accountMemberMap.get(subjectId)).getFlowType());
                }
                if (controlTraceBroke.isExistRecord()) continue;
                controlTraceBroke.setExistRecord(true);
                controlTraceBroke.setControlTraceId(executeRecordList.get(0).getControlTraceId());
            }
        }
    }
}

