/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.dimmapping.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.control.BizProps;
import kd.tmc.fpm.business.domain.model.control.DimensionMemberMappingParam;
import kd.tmc.fpm.business.domain.model.control.MatchMapping;
import kd.tmc.fpm.business.domain.model.dimension.DimMemberMapping;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.match.DimMatchEvent;
import kd.tmc.fpm.business.mvc.service.dimmapping.impl.AbstractDimensionMemberMappingManager;
import kd.tmc.fpm.business.provider.DimMappingBaseDataProvider;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.common.helper.StringHelper;

public class DimensionMemberMappingManager
extends AbstractDimensionMemberMappingManager<Long> {
    @Override
    public void doProcess(List<DimensionMemberMappingParam<Long>> dimensionMemberMappingParamList) {
        List<DimMemberMapping> dimMemberMappingList = dimensionMemberMappingParamList.stream().map(DimensionMemberMappingParam::getBillMatchRule).filter(Objects::nonNull).map(BillMatchRule::getMappings).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).filter(matchMapping -> this.matchAll || this.dimensionIds.contains(matchMapping.getDimId())).map(MatchMapping::getDimMapping).filter(Objects::nonNull).collect(Collectors.toList());
        DimMappingBaseDataProvider dimMappingBaseDataProvider = new DimMappingBaseDataProvider(dimMemberMappingList);
        for (DimensionMemberMappingParam<Long> dimensionMemberMappingParam : dimensionMemberMappingParamList) {
            this.doProcess(dimensionMemberMappingParam, dimMappingBaseDataProvider);
        }
    }

    private void doProcess(DimensionMemberMappingParam<Long> dimensionMemberMappingParam, DimMappingBaseDataProvider dimMappingBaseDataProvider) {
        BillMatchRule matchRule = dimensionMemberMappingParam.getBillMatchRule();
        List<MatchMapping> mappings = matchRule.getMappings();
        FundPlanSystem system = dimensionMemberMappingParam.getFundPlanSystem();
        BiConsumer<Dimension, Long> callBack = dimensionMemberMappingParam.getCallBack();
        for (Long dimensionId : this.dimensionIds) {
            Dimension dimension = system.getMainDimensionByDimensionId(dimensionId);
            Optional<MatchMapping> first = mappings.stream().filter(matchMapping -> Objects.equals(matchMapping.getDimId(), dimensionId)).findFirst();
            if (!first.isPresent()) {
                logger.info("\u7ef4\u5ea6\uff1a{}\uff0c\u4e3a\u5176\u4ed6\u4f53\u7cfb\u7684\u7ef4\u5ea6", (Object)dimensionId);
                continue;
            }
            MatchMapping dimensionMatchMapping = first.get();
            Map<String, Object> billBizPropMap = dimensionMemberMappingParam.getBillBizInfo().getBizProps().stream().collect(Collectors.toMap(BizProps::getBizProp, BizProps::getValue, (a, b) -> a));
            Long memberId = this.getDimMappingMemberId(dimensionMatchMapping, billBizPropMap, dimMappingBaseDataProvider);
            String bizProp = dimensionMatchMapping.getBizProp();
            Object bizPropValue = billBizPropMap.get(bizProp);
            if (EmptyUtil.isNoEmpty((Long)memberId)) {
                logger.info("\u4f53\u7cfb\uff1a{}\uff0c\u5339\u914d\u89c4\u5219\uff1a{}\uff0c\u7ef4\u5ea6\uff1a{}\uff0c\u901a\u8fc7\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u5339\u914d\u5230\u4e86\u7f16\u62a5\u4e3b\u4f53", new Object[]{system.getName(), matchRule.getNumber(), dimension.getName(), memberId});
                callBack.accept(dimension, memberId);
                this.notifySuccess(dimensionMemberMappingParam.getDimMatchListener(), () -> DimMatchEvent.builder().billMatchRule(matchRule).fundPlanSystem(system).matchMapping(dimensionMatchMapping).matchedValue(memberId).dimension(dimension).originalStringValue(StringHelper.getStringValue((Object)bizPropValue)).build());
                continue;
            }
            Predicate<DimMember> reportOrgPredicate = this.getDimensionPredicate(dimensionMatchMapping, bizPropValue);
            List dimMemberList = dimension.getAllDimMemberList().stream().filter(reportOrgPredicate::test).collect(Collectors.toList());
            if (EmptyUtil.isEmpty(dimMemberList)) {
                logger.info("\u4f53\u7cfb\uff1a{}\uff0c\u5339\u914d\u89c4\u5219\uff1a{}\uff0c\u7ef4\u5ea6\uff1a{}\u5bf9\u5e94\u7684\u6210\u5458\u4e2d\uff0c\u5c5e\u6027:{}\u5339\u914d\u5230\u5e95\u5b57\u6bb5\u503c\uff1a{}\u627e\u4e0d\u5230\u6309\uff1a{}\u5339\u914d\u7684\u6210\u5458", new Object[]{system.getName(), matchRule.getNumber(), dimension.getName(), bizProp, bizPropValue, CommonUtils.getEnumNumberOrDefault(dimensionMatchMapping.getMatchPropType(), "")});
                this.notifyFailed(dimensionMemberMappingParam.getDimMatchListener(), () -> DimMatchEvent.builder().billMatchRule(matchRule).fundPlanSystem(system).dimension(dimension).matchMapping(dimensionMatchMapping).originalStringValue(StringHelper.getStringValue((Object)bizPropValue)).build());
                continue;
            }
            for (DimMember dimMember : dimMemberList) {
                logger.info("\u4f53\u7cfb\uff1a{}\uff0c\u5339\u914d\u89c4\u5219\uff1a{}\uff0c\u7ef4\u5ea6\uff1a{}\u5339\u914d\u5230\u6210\u5458:{},id:{}", new Object[]{system.getName(), matchRule.getNumber(), dimension.getName(), dimMember.getName(), dimMember.getId()});
                callBack.accept(dimension, dimMember.getId());
            }
            this.notifySuccess(dimensionMemberMappingParam.getDimMatchListener(), () -> DimMatchEvent.builder().billMatchRule(matchRule).fundPlanSystem(system).matchMapping(dimensionMatchMapping).matchedValue(dimMemberList).dimension(dimension).originalStringValue(StringHelper.getStringValue((Object)bizPropValue)).build());
        }
    }
}

