/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.dto;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;

public class ExecContrCompareParamDTO {
    private BigDecimal actAmount;
    private List<TemplateDim> dimList;
    private List<Object> dimValList;
    private Date executeDate;

    public int compare(ExecContrCompareParamDTO compareParamDTO) {
        boolean dimCheck;
        boolean amtCheck = 0 == this.actAmount.compareTo(compareParamDTO.getActAmount());
        HashSet<Object> dimVals = new HashSet<Object>(this.dimValList);
        boolean dimValListCheck = !dimVals.addAll(compareParamDTO.getDimValList());
        Set dimessionIds = this.dimList.stream().filter(Objects::nonNull).map(o -> o.getDimensionId()).collect(Collectors.toSet());
        Set compareDimessionIds = compareParamDTO.getDimList().stream().filter(Objects::nonNull).map(o -> o.getDimensionId()).collect(Collectors.toSet());
        boolean dimListCheck = !dimessionIds.addAll(compareDimessionIds);
        boolean bl = dimCheck = dimListCheck && dimValListCheck;
        if (amtCheck && dimCheck) {
            return 0;
        }
        if (amtCheck) {
            return 1;
        }
        if (dimCheck) {
            return 2;
        }
        return 3;
    }

    public ExecContrCompareParamDTO() {
    }

    public ExecContrCompareParamDTO(BigDecimal actAmount, List<TemplateDim> dimList, List<Object> dimValList, Date executeDate) {
        this.actAmount = actAmount;
        this.dimList = dimList;
        this.dimValList = dimValList;
        this.executeDate = executeDate;
    }

    public ExecContrCompareParamDTO(PlanExecuteRecord planExecuteRecord) {
        ReportData reportData = planExecuteRecord.getReportData();
        this.actAmount = planExecuteRecord.getUnReleaseAmt();
        this.dimList = planExecuteRecord.getReportData().getDimList();
        this.dimValList = reportData == null ? new ArrayList(0) : reportData.getDimValList();
        this.executeDate = planExecuteRecord.getExecuteDate();
    }

    public BigDecimal getActAmount() {
        return this.actAmount;
    }

    public void setActAmount(BigDecimal actAmount) {
        this.actAmount = actAmount;
    }

    public List<TemplateDim> getDimList() {
        return this.dimList;
    }

    public void setDimList(List<TemplateDim> dimList) {
        this.dimList = dimList;
    }

    public List<Object> getDimValList() {
        return this.dimValList;
    }

    public void setDimValList(List<Object> dimValList) {
        this.dimValList = dimValList;
    }

    public void setExecuteDate(Date executeDate) {
        this.executeDate = executeDate;
    }

    public Date getExecuteDate() {
        return this.executeDate;
    }
}

