/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.domain.model.control.ControlUpdateInfo;
import kd.tmc.fpm.business.domain.service.ControlResult;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.service.IControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.impl.ControlStrategyDelegate;

public abstract class AbstractControlExecuteStrategy
implements IControlExecuteStrategy {
    protected ControlContext controlContext;
    protected static final Log logger = LogFactory.getLog(AbstractControlExecuteStrategy.class);
    protected ControlStrategyDelegate controlStrategyDelegate;
    protected ControlResult controlResult;

    public AbstractControlExecuteStrategy(ControlContext controlContext) {
        this.controlContext = controlContext;
        this.controlStrategyDelegate = new ControlStrategyDelegate(controlContext);
        this.controlResult = new ControlResult();
    }

    public AbstractControlExecuteStrategy(AbstractControlExecuteStrategy controlExecuteStrategy) {
        this.controlContext = controlExecuteStrategy.controlContext;
        this.controlStrategyDelegate = controlExecuteStrategy.controlStrategyDelegate;
        this.controlResult = controlExecuteStrategy.controlResult;
    }

    @Override
    public void beforeDoControl() {
    }

    @Override
    public FpmOperateResult<ControlResult> validate() {
        return FpmOperateResult.success(this.controlResult);
    }

    @Override
    public ControlUpdateInfo handleRecord() {
        return new ControlUpdateInfo();
    }
}

