/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTraceInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTracePlanRecordSort;
import kd.tmc.fpm.business.domain.model.control.ControlUpdateInfo;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.impl.AbstractControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import kd.tmc.fpm.business.utils.CommonUtils;

public class ActualCancelControlExecuteStrategy
extends AbstractControlExecuteStrategy {
    public ActualCancelControlExecuteStrategy(ControlContext controlContext) {
        super(controlContext);
    }

    @Override
    public ControlUpdateInfo handleRecord() {
        List<ControlExecuteParam> controlExecuteParamList = this.controlContext.getControlExecuteParamList();
        Map<String, List<ControlTraceInfo>> controlTraceInfoMap = this.controlContext.getControlTraceInfoMap();
        ControlUpdateInfo controlUpdateInfo = new ControlUpdateInfo();
        logger.info("\u5220\u9664\u5f02\u5e38\u6570\u636e\u3002\u3002\u3002\u3002\u3002");
        this.controlStrategyDelegate.deleteErrorRecordIfNeed(controlUpdateInfo);
        logger.info("\u53c2\u6570\uff1a{}", CommonUtils.getSubListForSize(controlExecuteParamList, 20));
        for (ControlExecuteParam controlExecuteParam : controlExecuteParamList) {
            PlanExecuteRecord cancelActualRecord = this.controlStrategyDelegate.createPlanExecuteRecord(controlExecuteParam);
            controlUpdateInfo.addSavePlanExecuteRecord(cancelActualRecord);
            BillBizInfo billBizInfo = controlExecuteParam.getBillBizInfo();
            String key = String.join((CharSequence)"#", billBizInfo.getBillId().toString(), controlExecuteParam.getSystemId().toString());
            List<ControlTraceInfo> traceInfoList = controlTraceInfoMap.getOrDefault(key, Collections.emptyList());
            ControlTracePlanRecordSort controlTracePlanRecordSort = this.controlStrategyDelegate.sortedExecuteRecord(traceInfoList, key);
            this.controlStrategyDelegate.processCurrentHoldingRecordIfNeed(controlUpdateInfo, controlTracePlanRecordSort, controlExecuteParam);
            PlanExecuteRecord originalPlanExecuteRecord = controlExecuteParam.getOriginalPlanExecuteRecord();
            this.doProcessOriginalRecordReleaseRecordIfNeed(billBizInfo, controlTracePlanRecordSort, originalPlanExecuteRecord);
            cancelActualRecord.setOriginalRecordId(originalPlanExecuteRecord.getId());
        }
        this.controlStrategyDelegate.fillCompleteControlUpdateInfo(controlUpdateInfo);
        return controlUpdateInfo;
    }

    private void doProcessOriginalRecordReleaseRecordIfNeed(BillBizInfo billBizInfo, ControlTracePlanRecordSort controlTracePlanRecordSort, PlanExecuteRecord originalPlanExecuteRecord) {
        List<PlanExecuteRecord> originalRecordReleaseRecordList = controlTracePlanRecordSort.getRecordListByOriginalRecordId(originalPlanExecuteRecord.getId(), billBizInfo);
        for (PlanExecuteRecord originalRecordReleaseRecord : originalRecordReleaseRecordList) {
            controlTracePlanRecordSort.markConsumed(originalRecordReleaseRecord);
            PlanExecuteOpType executeOpType = originalRecordReleaseRecord.getExecuteOpType();
            boolean releaseNegate = !this.controlStrategyDelegate.isRelease(executeOpType);
            boolean occupy = this.controlStrategyDelegate.isOccupy(executeOpType);
            this.controlStrategyDelegate.updateWithHoldingAmt(originalRecordReleaseRecord, releaseNegate, occupy);
        }
        List<PlanExecuteRecord> relateRecordList = controlTracePlanRecordSort.getRecordListByRelateRecordId(originalPlanExecuteRecord.getId());
        if (EmptyUtil.isEmpty(relateRecordList)) {
            logger.info("\u5f53\u524d\u5f85\u53d6\u6d88\u8bb0\u5f55\uff1a{},\u6ca1\u6709\u5bf9\u5e94\u7684\u6d3e\u751f\u5173\u8054\u8bb0\u5f55", (Object)originalPlanExecuteRecord);
            return;
        }
        for (PlanExecuteRecord relateRecord : relateRecordList) {
            PlanExecuteOpType executeOpType = relateRecord.getExecuteOpType();
            boolean releaseNegate = !this.controlStrategyDelegate.isRelease(executeOpType);
            boolean occupy = this.controlStrategyDelegate.isOccupy(executeOpType);
            controlTracePlanRecordSort.markConsumed(relateRecord);
            this.controlStrategyDelegate.updateWithHoldingAmt(relateRecord, releaseNegate, occupy);
        }
    }
}

