/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTraceInfo;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.mvc.service.IControlExecuteParamPostProcessor;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;

public class ActualUpdateCheckPostProcessor
implements IControlExecuteParamPostProcessor {
    private static final Log logger = LogFactory.getLog(ActualUpdateCheckPostProcessor.class);

    @Override
    public void postProcess(ControlContext controlContext, List<ControlExecuteParam> controlExecuteParamList) {
        if (!controlContext.getPlanExecuteOpType().isUpdate()) {
            return;
        }
        logger.info("ActualUpdateCheckPostProcessor \u6821\u9a8c\u524d\u5927\u5c0f\uff1a{}", (Object)controlExecuteParamList.size());
        Iterator<ControlExecuteParam> iterator = controlExecuteParamList.iterator();
        while (iterator.hasNext()) {
            ControlExecuteParam controlExecuteParam = iterator.next();
            if (EmptyUtil.isEmpty((Long)controlExecuteParam.getSubjectId())) {
                iterator.remove();
                continue;
            }
            BillBizInfo billBizInfo = controlExecuteParam.getBillBizInfo();
            List<ControlTraceInfo> controlTraceInfoList = controlContext.getControlTraceInfo(controlExecuteParam.getSystemId(), billBizInfo.getBillId());
            if (EmptyUtil.isEmpty(controlTraceInfoList)) {
                iterator.remove();
                continue;
            }
            ControlTraceInfo controlTraceInfo = controlTraceInfoList.get(0);
            if (!Objects.equals(controlTraceInfo.getBillId(), billBizInfo.getBillId()) || !Objects.equals(controlTraceInfo.getEntityType(), billBizInfo.getEntityType())) {
                iterator.remove();
                continue;
            }
            List<PlanExecuteRecord> executeRecordList = controlTraceInfo.getExecuteRecordList();
            if (EmptyUtil.isEmpty(executeRecordList)) {
                iterator.remove();
                continue;
            }
            Optional<PlanExecuteRecord> first = executeRecordList.stream().filter(p -> p.getExecuteOpType().isWrite()).findFirst();
            if (first.isPresent()) continue;
            iterator.remove();
        }
        logger.info("ActualUpdateCheckPostProcessor \u6821\u9a8c\u540e\u5927\u5c0f\uff1a{}", (Object)controlExecuteParamList.size());
    }

    @Override
    public int getOrder() {
        return 23;
    }
}

