/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTraceInfo;
import kd.tmc.fpm.business.domain.model.control.ControlUpdateInfo;
import kd.tmc.fpm.business.domain.model.control.DimensionMemberMappingParam;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.dimmapping.impl.DimensionMemberMappingManager;
import kd.tmc.fpm.business.mvc.service.impl.AbstractControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class ActualUpdateControlExecuteStrategy
extends AbstractControlExecuteStrategy {
    public ActualUpdateControlExecuteStrategy(ControlContext controlContext) {
        super(controlContext);
    }

    @Override
    public void beforeDoControl() {
        super.beforeDoControl();
        List<ControlExecuteParam> controlExecuteParamList = this.controlContext.getControlExecuteParamList();
        Set bizBillIds = controlExecuteParamList.stream().map(ControlExecuteParam::getBillBizInfo).map(BillBizInfo::getBillId).collect(Collectors.toSet());
        Map<String, List<PlanExecuteRecord>> planExecuteRecordMap = this.controlContext.getControlTraceInfoMap().values().stream().filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).filter(controlTraceInfo -> Objects.equals(controlTraceInfo.getEntityType(), this.controlContext.getEntityType())).filter(controlTraceInfo -> bizBillIds.contains(controlTraceInfo.getBillId())).map(ControlTraceInfo::getExecuteRecordList).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).filter(p -> p.getDeleteStatus() == false).filter(p -> p.getExecuteOpType().isWrite()).distinct().collect(Collectors.groupingBy(p -> this.controlStrategyDelegate.getGroupKey(p.getBillBizInfo(), p.getMatchRuleId())));
        ArrayList<ControlExecuteParam> addList = new ArrayList<ControlExecuteParam>(10);
        List<ActualUpdateDimensionInfo> actualUpdateDimensionInfoList = this.getActualUpdateDimensionInfoList();
        for (ActualUpdateDimensionInfo actualUpdateDimensionInfo : actualUpdateDimensionInfoList) {
            ControlExecuteParam controlExecuteParam = actualUpdateDimensionInfo.getControlExecuteParam();
            String groupKey = this.controlStrategyDelegate.getGroupKey(controlExecuteParam.getBillBizInfo(), controlExecuteParam.getMatchRule());
            List planExecuteRecordList = planExecuteRecordMap.getOrDefault(groupKey, Collections.emptyList());
            if (EmptyUtil.isEmpty(planExecuteRecordList)) continue;
            BigDecimal actAmount = controlExecuteParam.getActAmount();
            boolean used = false;
            block1: for (PlanExecuteRecord planExecuteRecord : planExecuteRecordList) {
                ReportData reportData = planExecuteRecord.getReportData();
                if (Objects.isNull(reportData)) {
                    logger.warn("\u6267\u884c\u8bb0\u5f55\uff1a{} \u5339\u914d\u5230\u7684\u6570\u636e\u4e3a\u7a7a\uff01", (Object)planExecuteRecord.getRecordNumber());
                    continue;
                }
                ArrayList floatMatchedDimIdList = planExecuteRecord.getFloatMatchedDimIdS();
                floatMatchedDimIdList = Objects.isNull(floatMatchedDimIdList) ? new ArrayList(0) : floatMatchedDimIdList;
                HashSet floatMatchedDimIdS = new HashSet(floatMatchedDimIdList);
                DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBeanByFilter(reportData, td -> td.getDimType().isSystemDim() || floatMatchedDimIdS.contains(td.getDimensionId()));
                DimensionInfoBean newBean = new DimensionInfoBean();
                Map<Long, Long> dimensionInfo = actualUpdateDimensionInfo.getDimensionInfo();
                Map dimValueMap = dimensionInfoBean.getDimValueMap();
                for (Map.Entry entry : dimValueMap.entrySet()) {
                    Long value = (Long)entry.getValue();
                    Long one = dimensionInfo.getOrDefault(value, 0L);
                    if (EmptyUtil.isEmpty((Long)one)) continue block1;
                    newBean.addDimensionInfo(one, (Object)value);
                }
                ControlExecuteParam param = controlExecuteParam;
                if (!used) {
                    used = true;
                } else {
                    param = controlExecuteParam.copy();
                    addList.add(param);
                }
                this.controlStrategyDelegate.fillMatchInfo(param, planExecuteRecord);
                param.setActAmountAndClearExchange(actAmount);
                BigDecimal subtract = param.getExecuteActAmount().subtract(planExecuteRecord.getAclRemainAmt());
                param.setActAmount(subtract, true);
                param.setDimensionInfoBean(newBean);
            }
        }
        int size = controlExecuteParamList.size();
        controlExecuteParamList.addAll(addList);
        int addedSize = controlExecuteParamList.size();
        logger.info("\u5b9e\u9645\u6570\u66f4\u65b0\u670d\u52a1\uff0c\u8f93\u5165\u5927\u5c0f\uff1a{}\uff0c\u591a\u7f16\u62a5\u7c7b\u578b\u65b0\u589e\u5927\u5c0f\uff1a{}\uff0c\u79fb\u9664\u672a\u627e\u5230\u76f8\u540c\u7ec4\u5408\u7684\u5b9e\u5360\u8bb0\u5f55\u540e\u5927\u5c0f:{}", new Object[]{size, addedSize, controlExecuteParamList.size()});
    }

    private List<ActualUpdateDimensionInfo> getActualUpdateDimensionInfoList() {
        List<ControlExecuteParam> controlExecuteParamList = this.controlContext.getControlExecuteParamList();
        ArrayList dimensionMemberMappingParamList = new ArrayList(controlExecuteParamList.size());
        ArrayList<ActualUpdateDimensionInfo> actualUpdateDimensionInfoList = new ArrayList<ActualUpdateDimensionInfo>(controlExecuteParamList.size());
        for (ControlExecuteParam controlExecuteParam : controlExecuteParamList) {
            DimensionMemberMappingParam.DimensionMemberMappingParamBuilder builder = DimensionMemberMappingParam.builder();
            DimensionInfoBean dimensionInfoBean = new DimensionInfoBean();
            controlExecuteParam.setDimensionInfoBean(dimensionInfoBean);
            FundPlanSystem system = this.controlContext.getSystem(controlExecuteParam.getSystemId());
            ActualUpdateDimensionInfo actualUpdateDimensionInfo = new ActualUpdateDimensionInfo(controlExecuteParam);
            actualUpdateDimensionInfoList.add(actualUpdateDimensionInfo);
            dimensionMemberMappingParamList.add(builder.billMatchRule(controlExecuteParam.getMatchRule()).callBack((dimension, memberId) -> actualUpdateDimensionInfo.getDimensionInfo().put((Long)memberId, dimension.getId())).billBizInfo(controlExecuteParam.getBillBizInfo()).fundPlanSystem(system).build());
        }
        new DimensionMemberMappingManager().matchAll().process(dimensionMemberMappingParamList);
        return actualUpdateDimensionInfoList;
    }

    @Override
    public ControlUpdateInfo handleRecord() {
        ControlUpdateInfo controlUpdateInfo = super.handleRecord();
        logger.info("\u5220\u9664\u5f02\u5e38\u6570\u636e\u3002\u3002\u3002\u3002\u3002");
        this.controlStrategyDelegate.deleteErrorRecordIfNeed(controlUpdateInfo);
        for (ControlExecuteParam controlExecuteParam : this.controlContext.getControlExecuteParamList()) {
            PlanExecuteRecord currentPlanExecuteRecord = this.controlStrategyDelegate.createPlanExecuteRecord(controlExecuteParam);
            currentPlanExecuteRecord.setAclRemainAmt(controlExecuteParam.getOriginalPlanExecuteRecord().getAclRemainAmt().add(currentPlanExecuteRecord.getActAmount()));
            this.controlStrategyDelegate.addWaitConsumeInfo(currentPlanExecuteRecord);
            controlUpdateInfo.addSavePlanExecuteRecord(currentPlanExecuteRecord);
        }
        this.controlStrategyDelegate.fillCompleteControlUpdateInfo(controlUpdateInfo);
        return controlUpdateInfo;
    }

    static class ActualUpdateDimensionInfo {
        private ControlExecuteParam controlExecuteParam;
        private Map<Long, Long> dimensionInfo;

        public ActualUpdateDimensionInfo(ControlExecuteParam controlExecuteParam) {
            this.controlExecuteParam = controlExecuteParam;
            this.dimensionInfo = new HashMap<Long, Long>(16);
        }

        public ControlExecuteParam getControlExecuteParam() {
            return this.controlExecuteParam;
        }

        public void setControlExecuteParam(ControlExecuteParam controlExecuteParam) {
            this.controlExecuteParam = controlExecuteParam;
        }

        public Map<Long, Long> getDimensionInfo() {
            return this.dimensionInfo;
        }

        public void setDimensionInfo(Map<Long, Long> dimensionInfo) {
            this.dimensionInfo = dimensionInfo;
        }
    }
}

