/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.IFpmPageCacheService;
import kd.tmc.fpm.business.domain.enums.AnalysisReportType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.TemplateDimMemScopeType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.AnalysisReport;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.IAnalysisReportBizService;
import kd.tmc.fpm.business.domain.service.IAnalysisReportService;
import kd.tmc.fpm.business.domain.service.impl.AnalysisReportBizService;
import kd.tmc.fpm.business.domain.service.impl.AnalysisReportService;
import kd.tmc.fpm.business.helper.TemplateInfoHelper;
import kd.tmc.fpm.business.mvc.repository.ITemplateRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.TemplateRepository;
import kd.tmc.fpm.business.mvc.service.IAnalysisReportManageService;
import kd.tmc.fpm.business.mvc.service.ISumPlanBizService;
import kd.tmc.fpm.business.mvc.service.impl.SumPlanBizServiceImpl;
import kd.tmc.fpm.business.spread.datamanager.ReportDataManagerFactory;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportDataManagerV2;
import kd.tmc.fpm.business.spread.generator.executor.IReportDataProcessExecutor;
import kd.tmc.fpm.business.spread.generator.executor.ReportDataProcessExecutorFactory;
import kd.tmc.fpm.common.helper.FpmGlobalConfigHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class AnalysisReportManagerService
implements IAnalysisReportManageService {
    private static Log logger = LogFactory.getLog(AnalysisReportManagerService.class);
    private IAnalysisReportService analysisReportService = new AnalysisReportService();
    private DimensionRepository dimensionRepository = new DimensionRepository();
    private ITemplateRepository templateRepository;
    private IAnalysisReportBizService bizService = new AnalysisReportBizService();
    private ISumPlanBizService sumPlanBizService;

    public AnalysisReportManagerService() {
        this.templateRepository = new TemplateRepository();
        this.sumPlanBizService = new SumPlanBizServiceImpl();
    }

    @Override
    public FpmOperateResult<ReportDataManagerV2> loadAnalysisReport(AnalysisHeader headerInfo, IFpmPageCacheService cacheService) {
        FundPlanSystem fundPlanSystem = this.dimensionRepository.loadSystem(headerInfo.getBodySystemId());
        headerInfo.setFromMultiDim(FpmGlobalConfigHelper.getBooleanConfigByKey((String)"startmutilquery"));
        FpmOperateResult<Report> reportFpmOperateResult = this.bizService.loadReport(headerInfo, fundPlanSystem);
        Report report = reportFpmOperateResult.getData();
        headerInfo.setExchangeRateTableId(report.getExchangeRateTableId());
        headerInfo.setExchangeRateDate(report.getExchangeRateDate());
        if (report.getExchangeRateTableId() == null || CollectionUtils.isEmpty(report.getReportDataList())) {
            return FpmOperateResult.error(ResManager.loadKDString((String)"\u6240\u9009\u7f16\u62a5\u671f\u95f4\u5747\u65e0\u7f16\u62a5\u6570\u636e\u3002", (String)"AnalysisReportManagerService_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        ReportModel analysisReportModel = ReportDataManagerFactory.getAnalysisReportModel((AnalysisReport)report, fundPlanSystem);
        ReportDataManagerV2 managerV2 = new ReportDataManagerV2(cacheService);
        managerV2.setCurrCalcModel(analysisReportModel.getReportCalcModelList().get(0));
        AnalysisReportType analysisReportType = headerInfo.getAnalysisReportType();
        if (analysisReportType.needSaveTemplate()) {
            managerV2.getRepository().saveReportTemplate(report.getTemplate());
            managerV2.getRepository().saveSystem(fundPlanSystem);
        }
        return FpmOperateResult.success(managerV2);
    }

    @Override
    public FpmOperateResult<ReportModel> loadSumPlanAnalysisReportModel(ReportTemplate reportTemplate, AnalysisHeader headerInfo) {
        FundPlanSystem fundPlanSystem = this.dimensionRepository.loadSystem(headerInfo.getBodySystemId());
        Report report = this.loadFixAnalysisReport(fundPlanSystem, reportTemplate, headerInfo);
        ReportModel reportModel = ReportDataManagerFactory.createAnalysisReportModel(fundPlanSystem, report);
        return FpmOperateResult.success(reportModel);
    }

    @Override
    public FpmOperateResult<ReportModel> loadSumPlanDetailAnalysisReportModel(ReportTemplate reportTemplate, AnalysisHeader headerInfo) {
        FundPlanSystem fundPlanSystem = this.dimensionRepository.loadSystem(headerInfo.getBodySystemId());
        Report report = this.loadDetailAnalysisReport(fundPlanSystem, reportTemplate, headerInfo);
        ReportModel reportModel = ReportDataManagerFactory.createAnalysisReportModel(fundPlanSystem, report);
        return FpmOperateResult.success(reportModel);
    }

    @Override
    public FpmOperateResult<Tuple<ReportModel, Report>> loadAnalysisReportModelForExport(ReportTemplate reportTemplate, AnalysisHeader headerInfo) {
        FundPlanSystem fundPlanSystem = this.dimensionRepository.loadSystem(headerInfo.getBodySystemId());
        Report report = reportTemplate.getTemplateType() == TemplateType.DETAIL ? this.loadDetailAnalysisReport(fundPlanSystem, reportTemplate, headerInfo) : this.loadFixAnalysisReport(fundPlanSystem, reportTemplate, headerInfo);
        ReportModel reportModel = new ReportModel();
        IReportDataProcessExecutor analysisReportExecutor = ReportDataProcessExecutorFactory.getAnalysisReportExecutorOfExport(fundPlanSystem, report, headerInfo);
        analysisReportExecutor.executeAction(reportModel);
        report.getTemplate().setTemplateUse(TemplateUseType.ANALYSIS);
        return FpmOperateResult.success(new Tuple((Object)reportModel, (Object)report));
    }

    private Report loadFixAnalysisReport(FundPlanSystem fundPlanSystem, ReportTemplate reportTemplate, AnalysisHeader headerInfo) {
        logger.info("\u5206\u6790\u8868\u67e5\u8be2\uff0c{}", (Object)reportTemplate.getId());
        this.updateTemplateMemberScopeByHeader(fundPlanSystem, reportTemplate, headerInfo);
        FpmOperateResult<Report> result = this.sumPlanBizService.loadSumPlanAnalysisReport(fundPlanSystem, reportTemplate, headerInfo);
        if (CollectionUtils.isNotEmpty(reportTemplate.getPageDimList())) {
            reportTemplate.setTemplateUse(TemplateUseType.SUMMARY);
        } else {
            reportTemplate.setTemplateUse(TemplateUseType.ANALYSIS);
        }
        Report report = result.getData();
        report.setReferencePeriodMember(null);
        report.setTemplate(reportTemplate);
        return report;
    }

    private Report loadDetailAnalysisReport(FundPlanSystem fundPlanSystem, ReportTemplate reportTemplate, AnalysisHeader headerInfo) {
        logger.info("\u5206\u6790\u8868\u67e5\u8be2\uff0c{}", (Object)reportTemplate.getId());
        this.updateDetailTemplateMemberScopeByHeader(reportTemplate, headerInfo);
        FpmOperateResult<Report> result = this.sumPlanBizService.loadSumPlanDetailAnalysisReport(fundPlanSystem, reportTemplate, headerInfo);
        Report report = result.getData();
        report.setReferencePeriodMember(null);
        TemplateInfoHelper.addSubjectFlowColIfDetailTemplateNeed(reportTemplate, fundPlanSystem);
        report.setTemplate(reportTemplate);
        return report;
    }

    private void updateDetailTemplateMemberScopeByHeader(ReportTemplate reportTemplate, AnalysisHeader headerInfo) {
        reportTemplate.getColDimList().removeIf(item -> !item.isVisible());
        reportTemplate.getPageDimList().removeIf(item -> !item.isVisible());
        List allTemplateDim = reportTemplate.getAllTemplateDim().stream().filter(tpl -> !tpl.isViDim()).collect(Collectors.toList());
        for (TemplateDim templateDim : allTemplateDim) {
            DimensionType dimType = templateDim.getDimType();
            switch (dimType) {
                case ORG: {
                    templateDim.setScopeType(TemplateDimMemScopeType.DIRECT_SUB_LEVEL);
                    templateDim.setMemberScope(headerInfo.getOrg());
                    break;
                }
                case PERIOD: {
                    templateDim.setMemberScope(headerInfo.getPeriodId());
                    break;
                }
                case COMPANY: {
                    templateDim.setMemberScope(headerInfo.getCompany());
                    break;
                }
                case CUSTOM: {
                    if (MapUtils.isEmpty(headerInfo.getCustomDimension())) break;
                    Long dimensionId = templateDim.getDimensionId();
                    List memberIds = headerInfo.getCustomDimension().getOrDefault(dimensionId.toString(), new ArrayList(0));
                    templateDim.setMemberScope(memberIds);
                    break;
                }
                case CURRENCY: {
                    templateDim.setMemberScope(headerInfo.getCurrency());
                    break;
                }
                case SETTLEMENT_TYPE: {
                    templateDim.setMemberScope(headerInfo.getSettlementMethod());
                    break;
                }
                case SUBJECTS: {
                    templateDim.setMemberScope(headerInfo.getSubjects());
                    break;
                }
            }
        }
        reportTemplate.getColDimList().removeIf(item -> item.getDimType() == DimensionType.METRIC);
        reportTemplate.setTemplateUse(TemplateUseType.ANALYSIS);
        reportTemplate.setAmountUnit(headerInfo.getAmountUnit());
    }

    private void updateTemplateMemberScopeByHeader(FundPlanSystem fundPlanSystem, ReportTemplate reportTemplate, AnalysisHeader headerInfo) {
        List<TemplateDim> allTemplateDim = reportTemplate.getAllTemplateDim();
        ArrayList<TemplateDim> needRemoveList = new ArrayList<TemplateDim>(4);
        for (TemplateDim templateDim : allTemplateDim) {
            DimensionType dimType = templateDim.getDimType();
            if (!templateDim.isVisible()) {
                needRemoveList.add(templateDim);
            }
            switch (dimType) {
                case ORG: {
                    templateDim.setScopeType(TemplateDimMemScopeType.DIRECT_SUB_LEVEL);
                    templateDim.setMemberScope(headerInfo.getOrg());
                    break;
                }
                case PERIOD: {
                    this.filterPeriod(fundPlanSystem, headerInfo);
                    templateDim.setMemberScope(headerInfo.getPeriodId());
                    break;
                }
                case COMPANY: {
                    templateDim.setMemberScope(headerInfo.getCompany());
                    break;
                }
                case CUSTOM: {
                    if (MapUtils.isEmpty(headerInfo.getCustomDimension())) break;
                    Long dimensionId = templateDim.getDimensionId();
                    List<Long> memberIds = headerInfo.getCustomDimension().get(dimensionId.toString());
                    templateDim.setMemberScope(memberIds);
                    break;
                }
                case CURRENCY: {
                    templateDim.setMemberScope(headerInfo.getCurrency());
                    break;
                }
                case SETTLEMENT_TYPE: {
                    templateDim.setMemberScope(headerInfo.getSettlementMethod());
                    break;
                }
                case SUBJECTS: {
                    templateDim.setMemberScope(headerInfo.getSubjects());
                    break;
                }
            }
            if (!CollectionUtils.isEmpty(templateDim.getMemberScope())) continue;
            needRemoveList.add(templateDim);
            logger.warn("current templatedim id:{} name:{} member scope is null", (Object)templateDim.getDimensionId(), (Object)templateDim.getDimensionName());
        }
        reportTemplate.getColDimList().removeIf(item -> item.getDimType() == DimensionType.METRIC);
        reportTemplate.getColDimList().removeAll(needRemoveList);
        reportTemplate.getRowDimList().removeAll(needRemoveList);
        reportTemplate.getPageDimList().removeAll(needRemoveList);
        reportTemplate.setAmountUnit(headerInfo.getAmountUnit());
    }

    private void filterPeriod(FundPlanSystem fundPlanSystem, AnalysisHeader headerInfo) {
        PeriodMember currPeriodMember;
        Dimension periodDimension = fundPlanSystem.getMainDimensionByDimType(DimensionType.PERIOD);
        Map periodMemberMap = periodDimension.getAllDimMemberList().stream().map(PeriodMember.class::cast).filter(periodMember -> headerInfo.getReportTypeId().equals(periodMember.getPeriodTypeId())).collect(Collectors.toMap(DimMember::getId, Function.identity()));
        ArrayList removeList = new ArrayList(10);
        ArrayList<Long> addList = new ArrayList<Long>(10);
        boolean isShowSuperiorPeriod = false;
        for (Long periodId : headerInfo.getPeriodId()) {
            currPeriodMember = (PeriodMember)periodMemberMap.get(periodId);
            if (!periodMemberMap.containsKey(periodId) || CollectionUtils.isEmpty(currPeriodMember.getChildren())) continue;
            isShowSuperiorPeriod = true;
            removeList.addAll(currPeriodMember.getAllChildMember().stream().map(DimMember::getId).collect(Collectors.toList()));
        }
        headerInfo.getPeriodId().removeAll(removeList);
        removeList.clear();
        for (Long periodId : headerInfo.getPeriodId()) {
            currPeriodMember = (PeriodMember)periodMemberMap.get(periodId);
            if (!isShowSuperiorPeriod || currPeriodMember.getParentId() == null || !CollectionUtils.isEmpty(currPeriodMember.getChildren()) || headerInfo.getPeriodId().contains(currPeriodMember.getParentId())) continue;
            addList.add(currPeriodMember.getParentId());
            removeList.addAll(currPeriodMember.getParent().getAllChildMember().stream().map(DimMember::getId).collect(Collectors.toList()));
        }
        headerInfo.getPeriodId().addAll(addList);
        headerInfo.getPeriodId().removeAll(removeList);
    }

    @Override
    public FpmOperateResult<ReportTemplate> loadAnalysisTemplate(Long templateId) {
        ReportTemplate result = null;
        List<ReportTemplate> reportTemplates = this.templateRepository.loadTemplateBak(Collections.singletonList(templateId));
        if (EmptyUtil.isNoEmpty(reportTemplates)) {
            result = reportTemplates.get(0);
        }
        return FpmOperateResult.success(result);
    }

    @Override
    public FpmOperateResult<ReportModel> loadSumPlanSubReportReport(AnalysisHeader headerInfo, IFpmPageCacheService cacheService) {
        FundPlanSystem fundPlanSystem = this.dimensionRepository.loadSystem(headerInfo.getBodySystemId());
        FpmOperateResult<Report> reportFpmOperateResult = this.bizService.loadSumPlanSubReport(headerInfo, fundPlanSystem, cacheService);
        Report report = reportFpmOperateResult.getData();
        if (report.getExchangeRateTableId() == null) {
            return FpmOperateResult.error(ResManager.loadKDString((String)"\u6240\u9009\u7f16\u62a5\u671f\u95f4\u5747\u65e0\u7f16\u62a5\u6570\u636e\u3002", (String)"AnalysisReportManagerService_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        ReportModel analysisDataManager = ReportDataManagerFactory.createAnalysisSumPlanSubReportModel(fundPlanSystem, report);
        return FpmOperateResult.success(analysisDataManager);
    }
}

