/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.control.BizProps;
import kd.tmc.fpm.business.domain.model.control.MatchMapping;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.mvc.service.IControlExecuteParamPostProcessor;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import kd.tmc.fpm.common.helper.StringHelper;

public class BizCurrencyFillBackPostProcessor
implements IControlExecuteParamPostProcessor {
    @Override
    public void postProcess(ControlContext controlContext, List<ControlExecuteParam> controlExecuteParamList) {
        if (!controlContext.getPlanExecuteOpType().isPositiveOp()) {
            return;
        }
        if (EmptyUtil.isEmpty(controlExecuteParamList)) {
            return;
        }
        List<BizCurrencyMatchInfo> bizCurrencyValueInfos = this.getBizCurrencyValueInfos(controlContext, controlExecuteParamList);
        Map<String, List<BizCurrencyMatchInfo>> stringListMap = bizCurrencyValueInfos.stream().collect(Collectors.groupingBy(BizCurrencyMatchInfo::getMatchField));
        for (Map.Entry<String, List<BizCurrencyMatchInfo>> entry : stringListMap.entrySet()) {
            String key = entry.getKey();
            List<BizCurrencyMatchInfo> value = entry.getValue();
            if (EmptyUtil.isEmpty(value)) {
                return;
            }
            Set matchedValues = value.stream().map(BizCurrencyMatchInfo::getMatchedValues).flatMap(Collection::stream).collect(Collectors.toSet());
            String selectFields = String.join((CharSequence)",", "id", key);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bd_currency", (String)selectFields, (QFilter[])new QFilter[]{new QFilter(key, "in", matchedValues)});
            Map<String, Long> currencyInfoMap = query.stream().collect(Collectors.toMap(dy -> dy.getString(key), dy -> dy.getLong("id"), (a, b) -> a));
            for (BizCurrencyMatchInfo bizCurrencyMatchInfo : value) {
                Map<String, List<ControlExecuteParam>> matchedValueMap = bizCurrencyMatchInfo.getMatchedValueMap();
                matchedValueMap.forEach((k, v) -> v.forEach(p -> p.setBizCurrencyId((Long)currencyInfoMap.get(k))));
            }
        }
    }

    private List<BizCurrencyMatchInfo> getBizCurrencyValueInfos(ControlContext controlContext, List<ControlExecuteParam> controlExecuteParamList) {
        HashMap<Long, BizCurrencyMatchInfo> map = new HashMap<Long, BizCurrencyMatchInfo>(controlExecuteParamList.size());
        for (ControlExecuteParam controlExecuteParam : controlExecuteParamList) {
            BillMatchRule matchRule = controlExecuteParam.getMatchRule();
            Dimension currencyDim = controlContext.getSystem(matchRule.getSystemId()).getMainDimensionByDimType(DimensionType.CURRENCY);
            BizCurrencyMatchInfo bizCurrencyMatchInfo = map.computeIfAbsent(matchRule.getId(), k -> {
                Optional<MatchMapping> first = matchRule.getMappings().stream().filter(m -> Objects.equals(currencyDim.getId(), m.getDimId())).findFirst();
                return first.map(matchMapping -> new BizCurrencyMatchInfo(matchRule.getId(), (MatchMapping)matchMapping)).orElse(null);
            });
            if (bizCurrencyMatchInfo == null) continue;
            bizCurrencyMatchInfo.addMatchedValue(controlExecuteParam);
        }
        return new ArrayList<BizCurrencyMatchInfo>(map.values());
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    static class BizCurrencyMatchInfo {
        private final Long matchRuleId;
        private final String matchField;
        private final String matchedPropName;
        private final Map<String, List<ControlExecuteParam>> matchedValueMap;

        public BizCurrencyMatchInfo(Long matchRuleId, MatchMapping matchMapping) {
            this.matchRuleId = matchRuleId;
            this.matchField = matchMapping.getMatchPropType().getProp();
            this.matchedPropName = matchMapping.getBizProp();
            this.matchedValueMap = new HashMap<String, List<ControlExecuteParam>>(16);
        }

        public Long getMatchRuleId() {
            return this.matchRuleId;
        }

        public String getMatchField() {
            return this.matchField;
        }

        public String getMatchedPropName() {
            return this.matchedPropName;
        }

        public Set<String> getMatchedValues() {
            return this.matchedValueMap.keySet();
        }

        public void addMatchedValue(ControlExecuteParam controlExecuteParam) {
            List<BizProps> bizProps = controlExecuteParam.getBillBizInfo().getBizProps();
            bizProps.stream().filter(bp -> Objects.equals(this.matchedPropName, bp.getBizProp())).map(BizProps::getValue).map(StringHelper::getStringValue).filter(EmptyUtil::isNoEmpty).forEach(v -> this.matchedValueMap.computeIfAbsent((String)v, k -> new ArrayList(16)).add(controlExecuteParam));
        }

        public Map<String, List<ControlExecuteParam>> getMatchedValueMap() {
            return this.matchedValueMap;
        }
    }
}

